# docspring

DocSpring - JavaScript client for docspring
DocSpring provides an API that helps you fill out and sign PDF templates.
This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 2.0.0
- Generator version: 7.11.0
- Build package: org.openapitools.codegen.languages.JavascriptClientCodegen

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/), please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install docspring --save
```

Finally, you need to build the module:

```shell
npm run build
```

##### Local development

To use the library locally without publishing to a remote npm registry, first install the dependencies by changing into the directory containing `package.json` (and this README). Let's call this `JAVASCRIPT_CLIENT_DIR`. Then run:

```shell
npm install
```

Next, [link](https://docs.npmjs.com/cli/link) it globally in npm with the following, also from `JAVASCRIPT_CLIENT_DIR`:

```shell
npm link
```

To use the link you just defined in your project, switch to the directory you want to use your docspring from, and run:

```shell
npm link /path/to/<JAVASCRIPT_CLIENT_DIR>
```

Finally, you need to build the module:

```shell
npm run build
```

#### git

If the library is hosted at a git repository, e.g.https://github.com/GIT_USER_ID/GIT_REPO_ID
then install it via:

```shell
    npm install GIT_USER_ID/GIT_REPO_ID --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

### Webpack Configuration

Using Webpack you may encounter the following error: "Module not found: Error:
Cannot resolve module", most certainly you should disable AMD loader. Add/merge
the following section to your webpack config:

```javascript
module: {
  rules: [
    {
      parser: {
        amd: false
      }
    }
  ]
}
```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var DocSpring = require('docspring');

var defaultClient = DocSpring.ApiClient.instance;
// Configure HTTP basic authorization: api_token_basic
var api_token_basic = defaultClient.authentications['api_token_basic'];
api_token_basic.username = 'YOUR USERNAME'
api_token_basic.password = 'YOUR PASSWORD'

var api = new DocSpring.PDFApi()
var templateId = "tpl_1234567890abcdef02"; // {String} 
var data = new DocSpring.AddFieldsData(); // {AddFieldsData} 
var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.addFieldsToTemplate(templateId, data, callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://sync.api.docspring.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DocSpring.PDFApi* | [**addFieldsToTemplate**](docs/PDFApi.md#addFieldsToTemplate) | **PUT** /templates/{template_id}/add_fields | Add new fields to a Template
*DocSpring.PDFApi* | [**batchGeneratePdfs**](docs/PDFApi.md#batchGeneratePdfs) | **POST** /submissions/batches | Generates multiple PDFs
*DocSpring.PDFApi* | [**combinePdfs**](docs/PDFApi.md#combinePdfs) | **POST** /combined_submissions?v&#x3D;2 | Merge submission PDFs, template PDFs, or custom files
*DocSpring.PDFApi* | [**combineSubmissions**](docs/PDFApi.md#combineSubmissions) | **POST** /combined_submissions | Merge generated PDFs together
*DocSpring.PDFApi* | [**copyTemplate**](docs/PDFApi.md#copyTemplate) | **POST** /templates/{template_id}/copy | Copy a Template
*DocSpring.PDFApi* | [**createCustomFileFromUpload**](docs/PDFApi.md#createCustomFileFromUpload) | **POST** /custom_files | Create a new custom file from a cached presign upload
*DocSpring.PDFApi* | [**createDataRequestEvent**](docs/PDFApi.md#createDataRequestEvent) | **POST** /data_requests/{data_request_id}/events | Creates a new event for emailing a signee a request for signature
*DocSpring.PDFApi* | [**createDataRequestToken**](docs/PDFApi.md#createDataRequestToken) | **POST** /data_requests/{data_request_id}/tokens | Creates a new data request token for form authentication
*DocSpring.PDFApi* | [**createFolder**](docs/PDFApi.md#createFolder) | **POST** /folders/ | Create a folder
*DocSpring.PDFApi* | [**createHTMLTemplate**](docs/PDFApi.md#createHTMLTemplate) | **POST** /templates?endpoint_description&#x3D;html | Create a new HTML template
*DocSpring.PDFApi* | [**createPDFTemplate**](docs/PDFApi.md#createPDFTemplate) | **POST** /templates | Create a new PDF template with a form POST file upload
*DocSpring.PDFApi* | [**createPDFTemplateFromUpload**](docs/PDFApi.md#createPDFTemplateFromUpload) | **POST** /templates?endpoint_description&#x3D;cached_upload | Create a new PDF template from a cached presign upload
*DocSpring.PDFApi* | [**deleteFolder**](docs/PDFApi.md#deleteFolder) | **DELETE** /folders/{folder_id} | Delete a folder
*DocSpring.PDFApi* | [**deleteTemplate**](docs/PDFApi.md#deleteTemplate) | **DELETE** /templates/{template_id} | Delete a template
*DocSpring.PDFApi* | [**expireCombinedSubmission**](docs/PDFApi.md#expireCombinedSubmission) | **DELETE** /combined_submissions/{combined_submission_id} | Expire a combined submission
*DocSpring.PDFApi* | [**expireSubmission**](docs/PDFApi.md#expireSubmission) | **DELETE** /submissions/{submission_id} | Expire a PDF submission
*DocSpring.PDFApi* | [**generatePdf**](docs/PDFApi.md#generatePdf) | **POST** /templates/{template_id}/submissions | Generates a new PDF
*DocSpring.PDFApi* | [**generatePdfForHtmlTemplate**](docs/PDFApi.md#generatePdfForHtmlTemplate) | **POST** /templates/{template_id}/submissions?endpoint_description&#x3D;html_templates | Generates a new PDF for an HTML template
*DocSpring.PDFApi* | [**generatePreview**](docs/PDFApi.md#generatePreview) | **POST** /submissions/{submission_id}/generate_preview | Generated a preview PDF for partially completed data requests
*DocSpring.PDFApi* | [**getCombinedSubmission**](docs/PDFApi.md#getCombinedSubmission) | **GET** /combined_submissions/{combined_submission_id} | Check the status of a combined submission (merged PDFs)
*DocSpring.PDFApi* | [**getDataRequest**](docs/PDFApi.md#getDataRequest) | **GET** /data_requests/{data_request_id} | Look up a submission data request
*DocSpring.PDFApi* | [**getFullTemplate**](docs/PDFApi.md#getFullTemplate) | **GET** /templates/{template_id}?full&#x3D;true | Fetch the full template attributes
*DocSpring.PDFApi* | [**getPresignUrl**](docs/PDFApi.md#getPresignUrl) | **GET** /uploads/presign | Get a presigned URL so that you can upload a file to our AWS S3 bucket
*DocSpring.PDFApi* | [**getSubmission**](docs/PDFApi.md#getSubmission) | **GET** /submissions/{submission_id} | Check the status of a PDF
*DocSpring.PDFApi* | [**getSubmissionBatch**](docs/PDFApi.md#getSubmissionBatch) | **GET** /submissions/batches/{submission_batch_id} | Check the status of a submission batch job
*DocSpring.PDFApi* | [**getTemplate**](docs/PDFApi.md#getTemplate) | **GET** /templates/{template_id} | Check the status of an uploaded template
*DocSpring.PDFApi* | [**getTemplateSchema**](docs/PDFApi.md#getTemplateSchema) | **GET** /templates/{template_id}/schema | Fetch the JSON schema for a template
*DocSpring.PDFApi* | [**listCombinedSubmissions**](docs/PDFApi.md#listCombinedSubmissions) | **GET** /combined_submissions | Get a list of all combined submissions
*DocSpring.PDFApi* | [**listFolders**](docs/PDFApi.md#listFolders) | **GET** /folders/ | Get a list of all folders
*DocSpring.PDFApi* | [**listSubmissions**](docs/PDFApi.md#listSubmissions) | **GET** /submissions | List all submissions
*DocSpring.PDFApi* | [**listTemplateSubmissions**](docs/PDFApi.md#listTemplateSubmissions) | **GET** /templates/{template_id}/submissions | List all submissions for a given template
*DocSpring.PDFApi* | [**listTemplates**](docs/PDFApi.md#listTemplates) | **GET** /templates | Get a list of all templates
*DocSpring.PDFApi* | [**moveFolderToFolder**](docs/PDFApi.md#moveFolderToFolder) | **POST** /folders/{folder_id}/move | Move a folder
*DocSpring.PDFApi* | [**moveTemplateToFolder**](docs/PDFApi.md#moveTemplateToFolder) | **POST** /templates/{template_id}/move | Move Template to folder
*DocSpring.PDFApi* | [**renameFolder**](docs/PDFApi.md#renameFolder) | **POST** /folders/{folder_id}/rename | Rename a folder
*DocSpring.PDFApi* | [**testAuthentication**](docs/PDFApi.md#testAuthentication) | **GET** /authentication | Test Authentication
*DocSpring.PDFApi* | [**updateDataRequest**](docs/PDFApi.md#updateDataRequest) | **PUT** /data_requests/{data_request_id} | Update a submission data request
*DocSpring.PDFApi* | [**updateTemplate**](docs/PDFApi.md#updateTemplate) | **PUT** /templates/{template_id} | Update a Template


## Documentation for Models

 - [DocSpring.AddFieldsData](docs/AddFieldsData.md)
 - [DocSpring.BatchGeneratePdfs201Response](docs/BatchGeneratePdfs201Response.md)
 - [DocSpring.CombinePdfsData](docs/CombinePdfsData.md)
 - [DocSpring.CombinedSubmission](docs/CombinedSubmission.md)
 - [DocSpring.CombinedSubmissionAction](docs/CombinedSubmissionAction.md)
 - [DocSpring.CombinedSubmissionData](docs/CombinedSubmissionData.md)
 - [DocSpring.CopyTemplateOptions](docs/CopyTemplateOptions.md)
 - [DocSpring.CreateCombinedSubmissionResponse](docs/CreateCombinedSubmissionResponse.md)
 - [DocSpring.CreateCustomFileData](docs/CreateCustomFileData.md)
 - [DocSpring.CreateCustomFileResponse](docs/CreateCustomFileResponse.md)
 - [DocSpring.CreateFolderData](docs/CreateFolderData.md)
 - [DocSpring.CreateHtmlSubmissionData](docs/CreateHtmlSubmissionData.md)
 - [DocSpring.CreateHtmlTemplate](docs/CreateHtmlTemplate.md)
 - [DocSpring.CreatePdfSubmissionData](docs/CreatePdfSubmissionData.md)
 - [DocSpring.CreatePdfTemplate](docs/CreatePdfTemplate.md)
 - [DocSpring.CreateSubmissionDataRequestData](docs/CreateSubmissionDataRequestData.md)
 - [DocSpring.CreateSubmissionDataRequestEventRequest](docs/CreateSubmissionDataRequestEventRequest.md)
 - [DocSpring.CreateSubmissionDataRequestEventResponse](docs/CreateSubmissionDataRequestEventResponse.md)
 - [DocSpring.CreateSubmissionDataRequestResponse](docs/CreateSubmissionDataRequestResponse.md)
 - [DocSpring.CreateSubmissionDataRequestTokenResponse](docs/CreateSubmissionDataRequestTokenResponse.md)
 - [DocSpring.CreateSubmissionResponse](docs/CreateSubmissionResponse.md)
 - [DocSpring.CustomFile](docs/CustomFile.md)
 - [DocSpring.ErrorResponse](docs/ErrorResponse.md)
 - [DocSpring.Folder](docs/Folder.md)
 - [DocSpring.JsonSchema](docs/JsonSchema.md)
 - [DocSpring.ListSubmissionsResponse](docs/ListSubmissionsResponse.md)
 - [DocSpring.MoveFolderData](docs/MoveFolderData.md)
 - [DocSpring.MoveTemplateData](docs/MoveTemplateData.md)
 - [DocSpring.MultipleErrorsResponse](docs/MultipleErrorsResponse.md)
 - [DocSpring.RenameFolderData](docs/RenameFolderData.md)
 - [DocSpring.Submission](docs/Submission.md)
 - [DocSpring.SubmissionAction](docs/SubmissionAction.md)
 - [DocSpring.SubmissionBatch](docs/SubmissionBatch.md)
 - [DocSpring.SubmissionBatchData](docs/SubmissionBatchData.md)
 - [DocSpring.SubmissionBatchWithSubmissions](docs/SubmissionBatchWithSubmissions.md)
 - [DocSpring.SubmissionDataRequest](docs/SubmissionDataRequest.md)
 - [DocSpring.SubmissionDataRequestEvent](docs/SubmissionDataRequestEvent.md)
 - [DocSpring.SubmissionDataRequestShow](docs/SubmissionDataRequestShow.md)
 - [DocSpring.SubmissionDataRequestToken](docs/SubmissionDataRequestToken.md)
 - [DocSpring.SubmissionPreview](docs/SubmissionPreview.md)
 - [DocSpring.SuccessErrorResponse](docs/SuccessErrorResponse.md)
 - [DocSpring.SuccessMultipleErrorsResponse](docs/SuccessMultipleErrorsResponse.md)
 - [DocSpring.Template](docs/Template.md)
 - [DocSpring.TemplateAddFieldsResponse](docs/TemplateAddFieldsResponse.md)
 - [DocSpring.TemplatePreview](docs/TemplatePreview.md)
 - [DocSpring.UpdateHtmlTemplate](docs/UpdateHtmlTemplate.md)
 - [DocSpring.UpdateSubmissionDataRequestData](docs/UpdateSubmissionDataRequestData.md)
 - [DocSpring.UploadPresignResponse](docs/UploadPresignResponse.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### api_token_basic

- **Type**: HTTP basic authentication

