/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import AddFieldsData from '../model/AddFieldsData';
import BatchGeneratePdfs201Response from '../model/BatchGeneratePdfs201Response';
import CombinePdfsData from '../model/CombinePdfsData';
import CombinedSubmission from '../model/CombinedSubmission';
import CombinedSubmissionData from '../model/CombinedSubmissionData';
import CopyTemplateOptions from '../model/CopyTemplateOptions';
import CreateCombinedSubmissionResponse from '../model/CreateCombinedSubmissionResponse';
import CreateCustomFileData from '../model/CreateCustomFileData';
import CreateCustomFileResponse from '../model/CreateCustomFileResponse';
import CreateFolderData from '../model/CreateFolderData';
import CreateHtmlSubmissionData from '../model/CreateHtmlSubmissionData';
import CreateHtmlTemplate from '../model/CreateHtmlTemplate';
import CreatePdfSubmissionData from '../model/CreatePdfSubmissionData';
import CreatePdfTemplate from '../model/CreatePdfTemplate';
import CreateSubmissionDataRequestEventRequest from '../model/CreateSubmissionDataRequestEventRequest';
import CreateSubmissionDataRequestEventResponse from '../model/CreateSubmissionDataRequestEventResponse';
import CreateSubmissionDataRequestResponse from '../model/CreateSubmissionDataRequestResponse';
import CreateSubmissionDataRequestTokenResponse from '../model/CreateSubmissionDataRequestTokenResponse';
import CreateSubmissionResponse from '../model/CreateSubmissionResponse';
import ErrorResponse from '../model/ErrorResponse';
import Folder from '../model/Folder';
import JsonSchema from '../model/JsonSchema';
import ListSubmissionsResponse from '../model/ListSubmissionsResponse';
import MoveFolderData from '../model/MoveFolderData';
import MoveTemplateData from '../model/MoveTemplateData';
import MultipleErrorsResponse from '../model/MultipleErrorsResponse';
import RenameFolderData from '../model/RenameFolderData';
import Submission from '../model/Submission';
import SubmissionBatchData from '../model/SubmissionBatchData';
import SubmissionBatchWithSubmissions from '../model/SubmissionBatchWithSubmissions';
import SubmissionDataRequestShow from '../model/SubmissionDataRequestShow';
import SubmissionPreview from '../model/SubmissionPreview';
import SuccessErrorResponse from '../model/SuccessErrorResponse';
import SuccessMultipleErrorsResponse from '../model/SuccessMultipleErrorsResponse';
import Template from '../model/Template';
import TemplateAddFieldsResponse from '../model/TemplateAddFieldsResponse';
import TemplatePreview from '../model/TemplatePreview';
import UpdateHtmlTemplate from '../model/UpdateHtmlTemplate';
import UpdateSubmissionDataRequestData from '../model/UpdateSubmissionDataRequestData';
import UploadPresignResponse from '../model/UploadPresignResponse';

/**
* PDF service.
* @module api/PDFApi
* @version 2.0.0
*/
export default class PDFApi {

    /**
    * Constructs a new PDFApi. 
    * @alias module:api/PDFApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the addFieldsToTemplate operation.
     * @callback module:api/PDFApi~addFieldsToTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplateAddFieldsResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Add new fields to a Template
     * @param {String} templateId 
     * @param {module:model/AddFieldsData} data 
     * @param {module:api/PDFApi~addFieldsToTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplateAddFieldsResponse}
     */
    addFieldsToTemplate(templateId, data, callback) {
      let postBody = data;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling addFieldsToTemplate");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling addFieldsToTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = TemplateAddFieldsResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}/add_fields', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the batchGeneratePdfs operation.
     * @callback module:api/PDFApi~batchGeneratePdfsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/BatchGeneratePdfs201Response} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Generates multiple PDFs
     * @param {module:model/SubmissionBatchData} data 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [wait = true)] Wait for submission batch to be processed before returning. Set to false to return immediately. Default: true (on sync.* subdomain)
     * @param {module:api/PDFApi~batchGeneratePdfsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/BatchGeneratePdfs201Response}
     */
    batchGeneratePdfs(data, opts, callback) {
      opts = opts || {};
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling batchGeneratePdfs");
      }

      let pathParams = {
      };
      let queryParams = {
        'wait': opts['wait']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = BatchGeneratePdfs201Response;
      return this.apiClient.callApi(
        '/submissions/batches', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the combinePdfs operation.
     * @callback module:api/PDFApi~combinePdfsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateCombinedSubmissionResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Merge submission PDFs, template PDFs, or custom files
     * @param {module:model/CombinePdfsData} data 
     * @param {module:api/PDFApi~combinePdfsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateCombinedSubmissionResponse}
     */
    combinePdfs(data, callback) {
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling combinePdfs");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateCombinedSubmissionResponse;
      return this.apiClient.callApi(
        '/combined_submissions?v=2', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the combineSubmissions operation.
     * @callback module:api/PDFApi~combineSubmissionsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateCombinedSubmissionResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Merge generated PDFs together
     * @param {module:model/CombinedSubmissionData} data 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [wait = true)] Wait for combined submission to be processed before returning. Set to false to return immediately. Default: true (on sync.* subdomain)
     * @param {module:api/PDFApi~combineSubmissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateCombinedSubmissionResponse}
     */
    combineSubmissions(data, opts, callback) {
      opts = opts || {};
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling combineSubmissions");
      }

      let pathParams = {
      };
      let queryParams = {
        'wait': opts['wait']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateCombinedSubmissionResponse;
      return this.apiClient.callApi(
        '/combined_submissions', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the copyTemplate operation.
     * @callback module:api/PDFApi~copyTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Copy a Template
     * @param {String} templateId 
     * @param {Object} opts Optional parameters
     * @param {module:model/CopyTemplateOptions} [options] 
     * @param {module:api/PDFApi~copyTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    copyTemplate(templateId, opts, callback) {
      opts = opts || {};
      let postBody = opts['options'];
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling copyTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates/{template_id}/copy', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createCustomFileFromUpload operation.
     * @callback module:api/PDFApi~createCustomFileFromUploadCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateCustomFileResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new custom file from a cached presign upload
     * @param {module:model/CreateCustomFileData} data 
     * @param {module:api/PDFApi~createCustomFileFromUploadCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateCustomFileResponse}
     */
    createCustomFileFromUpload(data, callback) {
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling createCustomFileFromUpload");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateCustomFileResponse;
      return this.apiClient.callApi(
        '/custom_files', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createDataRequestEvent operation.
     * @callback module:api/PDFApi~createDataRequestEventCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateSubmissionDataRequestEventResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Creates a new event for emailing a signee a request for signature
     * @param {String} dataRequestId 
     * @param {module:model/CreateSubmissionDataRequestEventRequest} event 
     * @param {module:api/PDFApi~createDataRequestEventCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateSubmissionDataRequestEventResponse}
     */
    createDataRequestEvent(dataRequestId, event, callback) {
      let postBody = event;
      // verify the required parameter 'dataRequestId' is set
      if (dataRequestId === undefined || dataRequestId === null) {
        throw new Error("Missing the required parameter 'dataRequestId' when calling createDataRequestEvent");
      }
      // verify the required parameter 'event' is set
      if (event === undefined || event === null) {
        throw new Error("Missing the required parameter 'event' when calling createDataRequestEvent");
      }

      let pathParams = {
        'data_request_id': dataRequestId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateSubmissionDataRequestEventResponse;
      return this.apiClient.callApi(
        '/data_requests/{data_request_id}/events', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createDataRequestToken operation.
     * @callback module:api/PDFApi~createDataRequestTokenCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateSubmissionDataRequestTokenResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Creates a new data request token for form authentication
     * @param {String} dataRequestId 
     * @param {Object} opts Optional parameters
     * @param {module:model/String} [type] 
     * @param {module:api/PDFApi~createDataRequestTokenCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateSubmissionDataRequestTokenResponse}
     */
    createDataRequestToken(dataRequestId, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'dataRequestId' is set
      if (dataRequestId === undefined || dataRequestId === null) {
        throw new Error("Missing the required parameter 'dataRequestId' when calling createDataRequestToken");
      }

      let pathParams = {
        'data_request_id': dataRequestId
      };
      let queryParams = {
        'type': opts['type']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CreateSubmissionDataRequestTokenResponse;
      return this.apiClient.callApi(
        '/data_requests/{data_request_id}/tokens', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createFolder operation.
     * @callback module:api/PDFApi~createFolderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Folder} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a folder
     * @param {module:model/CreateFolderData} data 
     * @param {module:api/PDFApi~createFolderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Folder}
     */
    createFolder(data, callback) {
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling createFolder");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Folder;
      return this.apiClient.callApi(
        '/folders/', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createHTMLTemplate operation.
     * @callback module:api/PDFApi~createHTMLTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new HTML template
     * @param {module:model/CreateHtmlTemplate} data 
     * @param {module:api/PDFApi~createHTMLTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    createHTMLTemplate(data, callback) {
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling createHTMLTemplate");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates?endpoint_description=html', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createPDFTemplate operation.
     * @callback module:api/PDFApi~createPDFTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new PDF template with a form POST file upload
     * @param {File} templateDocument 
     * @param {String} templateName 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [wait = true)] Wait for template document to be processed before returning. Set to false to return immediately. Default: true (on sync.* subdomain)
     * @param {String} [templateDescription] 
     * @param {String} [templateParentFolderId] 
     * @param {module:api/PDFApi~createPDFTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    createPDFTemplate(templateDocument, templateName, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'templateDocument' is set
      if (templateDocument === undefined || templateDocument === null) {
        throw new Error("Missing the required parameter 'templateDocument' when calling createPDFTemplate");
      }
      // verify the required parameter 'templateName' is set
      if (templateName === undefined || templateName === null) {
        throw new Error("Missing the required parameter 'templateName' when calling createPDFTemplate");
      }

      let pathParams = {
      };
      let queryParams = {
        'wait': opts['wait']
      };
      let headerParams = {
      };
      let formParams = {
        'template[document]': templateDocument,
        'template[name]': templateName,
        'template[description]': opts['templateDescription'],
        'template[parent_folder_id]': opts['templateParentFolderId']
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['multipart/form-data'];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the createPDFTemplateFromUpload operation.
     * @callback module:api/PDFApi~createPDFTemplateFromUploadCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new PDF template from a cached presign upload
     * @param {module:model/CreatePdfTemplate} data 
     * @param {module:api/PDFApi~createPDFTemplateFromUploadCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    createPDFTemplateFromUpload(data, callback) {
      let postBody = data;
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling createPDFTemplateFromUpload");
      }

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates?endpoint_description=cached_upload', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteFolder operation.
     * @callback module:api/PDFApi~deleteFolderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Folder} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a folder
     * @param {String} folderId 
     * @param {module:api/PDFApi~deleteFolderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Folder}
     */
    deleteFolder(folderId, callback) {
      let postBody = null;
      // verify the required parameter 'folderId' is set
      if (folderId === undefined || folderId === null) {
        throw new Error("Missing the required parameter 'folderId' when calling deleteFolder");
      }

      let pathParams = {
        'folder_id': folderId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Folder;
      return this.apiClient.callApi(
        '/folders/{folder_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteTemplate operation.
     * @callback module:api/PDFApi~deleteTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SuccessMultipleErrorsResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a template
     * @param {String} templateId 
     * @param {module:api/PDFApi~deleteTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SuccessMultipleErrorsResponse}
     */
    deleteTemplate(templateId, callback) {
      let postBody = null;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling deleteTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SuccessMultipleErrorsResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the expireCombinedSubmission operation.
     * @callback module:api/PDFApi~expireCombinedSubmissionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CombinedSubmission} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Expire a combined submission
     * @param {String} combinedSubmissionId 
     * @param {module:api/PDFApi~expireCombinedSubmissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CombinedSubmission}
     */
    expireCombinedSubmission(combinedSubmissionId, callback) {
      let postBody = null;
      // verify the required parameter 'combinedSubmissionId' is set
      if (combinedSubmissionId === undefined || combinedSubmissionId === null) {
        throw new Error("Missing the required parameter 'combinedSubmissionId' when calling expireCombinedSubmission");
      }

      let pathParams = {
        'combined_submission_id': combinedSubmissionId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CombinedSubmission;
      return this.apiClient.callApi(
        '/combined_submissions/{combined_submission_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the expireSubmission operation.
     * @callback module:api/PDFApi~expireSubmissionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SubmissionPreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Expire a PDF submission
     * @param {String} submissionId 
     * @param {module:api/PDFApi~expireSubmissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SubmissionPreview}
     */
    expireSubmission(submissionId, callback) {
      let postBody = null;
      // verify the required parameter 'submissionId' is set
      if (submissionId === undefined || submissionId === null) {
        throw new Error("Missing the required parameter 'submissionId' when calling expireSubmission");
      }

      let pathParams = {
        'submission_id': submissionId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SubmissionPreview;
      return this.apiClient.callApi(
        '/submissions/{submission_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the generatePdf operation.
     * @callback module:api/PDFApi~generatePdfCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateSubmissionResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Generates a new PDF
     * @param {String} templateId 
     * @param {module:model/CreatePdfSubmissionData} submission 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [wait = true)] Wait for submission to be processed before returning. Set to false to return immediately. Default: true (on sync.* subdomain)
     * @param {module:api/PDFApi~generatePdfCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateSubmissionResponse}
     */
    generatePdf(templateId, submission, opts, callback) {
      opts = opts || {};
      let postBody = submission;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling generatePdf");
      }
      // verify the required parameter 'submission' is set
      if (submission === undefined || submission === null) {
        throw new Error("Missing the required parameter 'submission' when calling generatePdf");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
        'wait': opts['wait']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateSubmissionResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}/submissions', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the generatePdfForHtmlTemplate operation.
     * @callback module:api/PDFApi~generatePdfForHtmlTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateSubmissionResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Generates a new PDF for an HTML template
     * @param {String} templateId 
     * @param {module:model/CreateHtmlSubmissionData} submission 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [wait = true)] Wait for submission to be processed before returning. Set to false to return immediately. Default: true (on sync.* subdomain)
     * @param {module:api/PDFApi~generatePdfForHtmlTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateSubmissionResponse}
     */
    generatePdfForHtmlTemplate(templateId, submission, opts, callback) {
      opts = opts || {};
      let postBody = submission;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling generatePdfForHtmlTemplate");
      }
      // verify the required parameter 'submission' is set
      if (submission === undefined || submission === null) {
        throw new Error("Missing the required parameter 'submission' when calling generatePdfForHtmlTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
        'wait': opts['wait']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateSubmissionResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}/submissions?endpoint_description=html_templates', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the generatePreview operation.
     * @callback module:api/PDFApi~generatePreviewCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SuccessErrorResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Generated a preview PDF for partially completed data requests
     * @param {String} submissionId 
     * @param {module:api/PDFApi~generatePreviewCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SuccessErrorResponse}
     */
    generatePreview(submissionId, callback) {
      let postBody = null;
      // verify the required parameter 'submissionId' is set
      if (submissionId === undefined || submissionId === null) {
        throw new Error("Missing the required parameter 'submissionId' when calling generatePreview");
      }

      let pathParams = {
        'submission_id': submissionId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SuccessErrorResponse;
      return this.apiClient.callApi(
        '/submissions/{submission_id}/generate_preview', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getCombinedSubmission operation.
     * @callback module:api/PDFApi~getCombinedSubmissionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CombinedSubmission} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Check the status of a combined submission (merged PDFs)
     * @param {String} combinedSubmissionId 
     * @param {module:api/PDFApi~getCombinedSubmissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CombinedSubmission}
     */
    getCombinedSubmission(combinedSubmissionId, callback) {
      let postBody = null;
      // verify the required parameter 'combinedSubmissionId' is set
      if (combinedSubmissionId === undefined || combinedSubmissionId === null) {
        throw new Error("Missing the required parameter 'combinedSubmissionId' when calling getCombinedSubmission");
      }

      let pathParams = {
        'combined_submission_id': combinedSubmissionId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = CombinedSubmission;
      return this.apiClient.callApi(
        '/combined_submissions/{combined_submission_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getDataRequest operation.
     * @callback module:api/PDFApi~getDataRequestCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SubmissionDataRequestShow} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Look up a submission data request
     * @param {String} dataRequestId 
     * @param {module:api/PDFApi~getDataRequestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SubmissionDataRequestShow}
     */
    getDataRequest(dataRequestId, callback) {
      let postBody = null;
      // verify the required parameter 'dataRequestId' is set
      if (dataRequestId === undefined || dataRequestId === null) {
        throw new Error("Missing the required parameter 'dataRequestId' when calling getDataRequest");
      }

      let pathParams = {
        'data_request_id': dataRequestId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SubmissionDataRequestShow;
      return this.apiClient.callApi(
        '/data_requests/{data_request_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getFullTemplate operation.
     * @callback module:api/PDFApi~getFullTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Template} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch the full template attributes
     * @param {String} templateId 
     * @param {module:api/PDFApi~getFullTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Template}
     */
    getFullTemplate(templateId, callback) {
      let postBody = null;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling getFullTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Template;
      return this.apiClient.callApi(
        '/templates/{template_id}?full=true', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getPresignUrl operation.
     * @callback module:api/PDFApi~getPresignUrlCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UploadPresignResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a presigned URL so that you can upload a file to our AWS S3 bucket
     * @param {module:api/PDFApi~getPresignUrlCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UploadPresignResponse}
     */
    getPresignUrl(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = UploadPresignResponse;
      return this.apiClient.callApi(
        '/uploads/presign', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSubmission operation.
     * @callback module:api/PDFApi~getSubmissionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Submission} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Check the status of a PDF
     * @param {String} submissionId 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [includeData] 
     * @param {module:api/PDFApi~getSubmissionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Submission}
     */
    getSubmission(submissionId, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'submissionId' is set
      if (submissionId === undefined || submissionId === null) {
        throw new Error("Missing the required parameter 'submissionId' when calling getSubmission");
      }

      let pathParams = {
        'submission_id': submissionId
      };
      let queryParams = {
        'include_data': opts['includeData']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = Submission;
      return this.apiClient.callApi(
        '/submissions/{submission_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getSubmissionBatch operation.
     * @callback module:api/PDFApi~getSubmissionBatchCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SubmissionBatchWithSubmissions} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Check the status of a submission batch job
     * @param {String} submissionBatchId 
     * @param {Object} opts Optional parameters
     * @param {Boolean} [includeSubmissions] 
     * @param {module:api/PDFApi~getSubmissionBatchCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SubmissionBatchWithSubmissions}
     */
    getSubmissionBatch(submissionBatchId, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'submissionBatchId' is set
      if (submissionBatchId === undefined || submissionBatchId === null) {
        throw new Error("Missing the required parameter 'submissionBatchId' when calling getSubmissionBatch");
      }

      let pathParams = {
        'submission_batch_id': submissionBatchId
      };
      let queryParams = {
        'include_submissions': opts['includeSubmissions']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SubmissionBatchWithSubmissions;
      return this.apiClient.callApi(
        '/submissions/batches/{submission_batch_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTemplate operation.
     * @callback module:api/PDFApi~getTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Check the status of an uploaded template
     * @param {String} templateId 
     * @param {module:api/PDFApi~getTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    getTemplate(templateId, callback) {
      let postBody = null;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling getTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates/{template_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getTemplateSchema operation.
     * @callback module:api/PDFApi~getTemplateSchemaCallback
     * @param {String} error Error message, if any.
     * @param {module:model/JsonSchema} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch the JSON schema for a template
     * @param {String} templateId 
     * @param {module:api/PDFApi~getTemplateSchemaCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/JsonSchema}
     */
    getTemplateSchema(templateId, callback) {
      let postBody = null;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling getTemplateSchema");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = JsonSchema;
      return this.apiClient.callApi(
        '/templates/{template_id}/schema', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the listCombinedSubmissions operation.
     * @callback module:api/PDFApi~listCombinedSubmissionsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/CombinedSubmission>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a list of all combined submissions
     * @param {Object} opts Optional parameters
     * @param {Number} [page] Default: 1
     * @param {Number} [perPage] Default: 50
     * @param {module:api/PDFApi~listCombinedSubmissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/CombinedSubmission>}
     */
    listCombinedSubmissions(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'page': opts['page'],
        'per_page': opts['perPage']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [CombinedSubmission];
      return this.apiClient.callApi(
        '/combined_submissions', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the listFolders operation.
     * @callback module:api/PDFApi~listFoldersCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/Folder>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a list of all folders
     * @param {Object} opts Optional parameters
     * @param {String} [parentFolderId] Filter By Folder Id
     * @param {module:api/PDFApi~listFoldersCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/Folder>}
     */
    listFolders(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'parent_folder_id': opts['parentFolderId']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [Folder];
      return this.apiClient.callApi(
        '/folders/', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the listSubmissions operation.
     * @callback module:api/PDFApi~listSubmissionsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ListSubmissionsResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * List all submissions
     * @param {Object} opts Optional parameters
     * @param {String} [cursor] 
     * @param {Number} [limit] 
     * @param {String} [createdAfter] 
     * @param {String} [createdBefore] 
     * @param {String} [type] 
     * @param {Boolean} [includeData] 
     * @param {module:api/PDFApi~listSubmissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ListSubmissionsResponse}
     */
    listSubmissions(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'cursor': opts['cursor'],
        'limit': opts['limit'],
        'created_after': opts['createdAfter'],
        'created_before': opts['createdBefore'],
        'type': opts['type'],
        'include_data': opts['includeData']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ListSubmissionsResponse;
      return this.apiClient.callApi(
        '/submissions', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the listTemplateSubmissions operation.
     * @callback module:api/PDFApi~listTemplateSubmissionsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/ListSubmissionsResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * List all submissions for a given template
     * @param {String} templateId 
     * @param {Object} opts Optional parameters
     * @param {String} [cursor] 
     * @param {Number} [limit] 
     * @param {String} [createdAfter] 
     * @param {String} [createdBefore] 
     * @param {String} [type] 
     * @param {Boolean} [includeData] 
     * @param {module:api/PDFApi~listTemplateSubmissionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/ListSubmissionsResponse}
     */
    listTemplateSubmissions(templateId, opts, callback) {
      opts = opts || {};
      let postBody = null;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling listTemplateSubmissions");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
        'cursor': opts['cursor'],
        'limit': opts['limit'],
        'created_after': opts['createdAfter'],
        'created_before': opts['createdBefore'],
        'type': opts['type'],
        'include_data': opts['includeData']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = ListSubmissionsResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}/submissions', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the listTemplates operation.
     * @callback module:api/PDFApi~listTemplatesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/TemplatePreview>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a list of all templates
     * @param {Object} opts Optional parameters
     * @param {String} [query] Search By Name
     * @param {String} [parentFolderId] Filter By Folder Id
     * @param {Number} [page] Default: 1
     * @param {Number} [perPage] Default: 50
     * @param {module:api/PDFApi~listTemplatesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/TemplatePreview>}
     */
    listTemplates(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'query': opts['query'],
        'parent_folder_id': opts['parentFolderId'],
        'page': opts['page'],
        'per_page': opts['perPage']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [TemplatePreview];
      return this.apiClient.callApi(
        '/templates', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the moveFolderToFolder operation.
     * @callback module:api/PDFApi~moveFolderToFolderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Folder} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Move a folder
     * @param {String} folderId 
     * @param {module:model/MoveFolderData} data 
     * @param {module:api/PDFApi~moveFolderToFolderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Folder}
     */
    moveFolderToFolder(folderId, data, callback) {
      let postBody = data;
      // verify the required parameter 'folderId' is set
      if (folderId === undefined || folderId === null) {
        throw new Error("Missing the required parameter 'folderId' when calling moveFolderToFolder");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling moveFolderToFolder");
      }

      let pathParams = {
        'folder_id': folderId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Folder;
      return this.apiClient.callApi(
        '/folders/{folder_id}/move', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the moveTemplateToFolder operation.
     * @callback module:api/PDFApi~moveTemplateToFolderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/TemplatePreview} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Move Template to folder
     * @param {String} templateId 
     * @param {module:model/MoveTemplateData} data 
     * @param {module:api/PDFApi~moveTemplateToFolderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/TemplatePreview}
     */
    moveTemplateToFolder(templateId, data, callback) {
      let postBody = data;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling moveTemplateToFolder");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling moveTemplateToFolder");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = TemplatePreview;
      return this.apiClient.callApi(
        '/templates/{template_id}/move', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the renameFolder operation.
     * @callback module:api/PDFApi~renameFolderCallback
     * @param {String} error Error message, if any.
     * @param {module:model/Folder} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Rename a folder
     * @param {String} folderId 
     * @param {module:model/RenameFolderData} data 
     * @param {module:api/PDFApi~renameFolderCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/Folder}
     */
    renameFolder(folderId, data, callback) {
      let postBody = data;
      // verify the required parameter 'folderId' is set
      if (folderId === undefined || folderId === null) {
        throw new Error("Missing the required parameter 'folderId' when calling renameFolder");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling renameFolder");
      }

      let pathParams = {
        'folder_id': folderId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = Folder;
      return this.apiClient.callApi(
        '/folders/{folder_id}/rename', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the testAuthentication operation.
     * @callback module:api/PDFApi~testAuthenticationCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SuccessErrorResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Test Authentication
     * @param {module:api/PDFApi~testAuthenticationCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SuccessErrorResponse}
     */
    testAuthentication(callback) {
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = SuccessErrorResponse;
      return this.apiClient.callApi(
        '/authentication', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the updateDataRequest operation.
     * @callback module:api/PDFApi~updateDataRequestCallback
     * @param {String} error Error message, if any.
     * @param {module:model/CreateSubmissionDataRequestResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a submission data request
     * @param {String} dataRequestId 
     * @param {module:model/UpdateSubmissionDataRequestData} data 
     * @param {module:api/PDFApi~updateDataRequestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/CreateSubmissionDataRequestResponse}
     */
    updateDataRequest(dataRequestId, data, callback) {
      let postBody = data;
      // verify the required parameter 'dataRequestId' is set
      if (dataRequestId === undefined || dataRequestId === null) {
        throw new Error("Missing the required parameter 'dataRequestId' when calling updateDataRequest");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling updateDataRequest");
      }

      let pathParams = {
        'data_request_id': dataRequestId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = CreateSubmissionDataRequestResponse;
      return this.apiClient.callApi(
        '/data_requests/{data_request_id}', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the updateTemplate operation.
     * @callback module:api/PDFApi~updateTemplateCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SuccessMultipleErrorsResponse} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a Template
     * @param {String} templateId 
     * @param {module:model/UpdateHtmlTemplate} data 
     * @param {module:api/PDFApi~updateTemplateCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SuccessMultipleErrorsResponse}
     */
    updateTemplate(templateId, data, callback) {
      let postBody = data;
      // verify the required parameter 'templateId' is set
      if (templateId === undefined || templateId === null) {
        throw new Error("Missing the required parameter 'templateId' when calling updateTemplate");
      }
      // verify the required parameter 'data' is set
      if (data === undefined || data === null) {
        throw new Error("Missing the required parameter 'data' when calling updateTemplate");
      }

      let pathParams = {
        'template_id': templateId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['api_token_basic'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = SuccessMultipleErrorsResponse;
      return this.apiClient.callApi(
        '/templates/{template_id}', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
