/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import SubmissionBatch from './SubmissionBatch';

/**
 * The BatchGeneratePdfs201Response model module.
 * @module model/BatchGeneratePdfs201Response
 * @version 2.0.0
 */
class BatchGeneratePdfs201Response {
    /**
     * Constructs a new <code>BatchGeneratePdfs201Response</code>.
     * @alias module:model/BatchGeneratePdfs201Response
     * @param status {module:model/BatchGeneratePdfs201Response.StatusEnum} 
     * @param submissionBatch {module:model/SubmissionBatch} 
     * @param submissions {Array.<Object>} 
     */
    constructor(status, submissionBatch, submissions) { 
        
        BatchGeneratePdfs201Response.initialize(this, status, submissionBatch, submissions);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, status, submissionBatch, submissions) { 
        obj['status'] = status;
        obj['submission_batch'] = submissionBatch;
        obj['submissions'] = submissions;
    }

    /**
     * Constructs a <code>BatchGeneratePdfs201Response</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/BatchGeneratePdfs201Response} obj Optional instance to populate.
     * @return {module:model/BatchGeneratePdfs201Response} The populated <code>BatchGeneratePdfs201Response</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new BatchGeneratePdfs201Response();

            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('error')) {
                obj['error'] = ApiClient.convertToType(data['error'], 'String');
            }
            if (data.hasOwnProperty('errors')) {
                obj['errors'] = ApiClient.convertToType(data['errors'], ['String']);
            }
            if (data.hasOwnProperty('submission_batch')) {
                obj['submission_batch'] = SubmissionBatch.constructFromObject(data['submission_batch']);
            }
            if (data.hasOwnProperty('submissions')) {
                obj['submissions'] = ApiClient.convertToType(data['submissions'], [Object]);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>BatchGeneratePdfs201Response</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>BatchGeneratePdfs201Response</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of BatchGeneratePdfs201Response.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['status'] && !(typeof data['status'] === 'string' || data['status'] instanceof String)) {
            throw new Error("Expected the field `status` to be a primitive type in the JSON string but got " + data['status']);
        }
        // ensure the json data is a string
        if (data['error'] && !(typeof data['error'] === 'string' || data['error'] instanceof String)) {
            throw new Error("Expected the field `error` to be a primitive type in the JSON string but got " + data['error']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['errors'])) {
            throw new Error("Expected the field `errors` to be an array in the JSON data but got " + data['errors']);
        }
        // validate the optional field `submission_batch`
        if (data['submission_batch']) { // data not null
          SubmissionBatch.validateJSON(data['submission_batch']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['submissions'])) {
            throw new Error("Expected the field `submissions` to be an array in the JSON data but got " + data['submissions']);
        }

        return true;
    }


}

BatchGeneratePdfs201Response.RequiredProperties = ["status", "submission_batch", "submissions"];

/**
 * @member {module:model/BatchGeneratePdfs201Response.StatusEnum} status
 */
BatchGeneratePdfs201Response.prototype['status'] = undefined;

/**
 * @member {String} error
 */
BatchGeneratePdfs201Response.prototype['error'] = undefined;

/**
 * @member {Array.<String>} errors
 */
BatchGeneratePdfs201Response.prototype['errors'] = undefined;

/**
 * @member {module:model/SubmissionBatch} submission_batch
 */
BatchGeneratePdfs201Response.prototype['submission_batch'] = undefined;

/**
 * @member {Array.<Object>} submissions
 */
BatchGeneratePdfs201Response.prototype['submissions'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
BatchGeneratePdfs201Response['StatusEnum'] = {

    /**
     * value: "success"
     * @const
     */
    "success": "success",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default BatchGeneratePdfs201Response;

