/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import CombinedSubmissionAction from './CombinedSubmissionAction';

/**
 * The CombinedSubmission model module.
 * @module model/CombinedSubmission
 * @version 2.0.0
 */
class CombinedSubmission {
    /**
     * Constructs a new <code>CombinedSubmission</code>.
     * @alias module:model/CombinedSubmission
     * @param id {String} 
     * @param state {module:model/CombinedSubmission.StateEnum} 
     * @param expired {Boolean} 
     * @param expiresIn {Number} 
     * @param expiresAt {String} 
     * @param processedAt {String} 
     * @param errorMessage {String} 
     * @param submissionIds {Array.<String>} 
     * @param sourcePdfs {Array.<Object>} 
     * @param metadata {Object} 
     * @param password {String} 
     * @param pdfHash {String} 
     * @param downloadUrl {String} 
     * @param actions {Array.<module:model/CombinedSubmissionAction>} 
     */
    constructor(id, state, expired, expiresIn, expiresAt, processedAt, errorMessage, submissionIds, sourcePdfs, metadata, password, pdfHash, downloadUrl, actions) { 
        
        CombinedSubmission.initialize(this, id, state, expired, expiresIn, expiresAt, processedAt, errorMessage, submissionIds, sourcePdfs, metadata, password, pdfHash, downloadUrl, actions);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, state, expired, expiresIn, expiresAt, processedAt, errorMessage, submissionIds, sourcePdfs, metadata, password, pdfHash, downloadUrl, actions) { 
        obj['id'] = id;
        obj['state'] = state;
        obj['expired'] = expired;
        obj['expires_in'] = expiresIn;
        obj['expires_at'] = expiresAt;
        obj['processed_at'] = processedAt;
        obj['error_message'] = errorMessage;
        obj['submission_ids'] = submissionIds;
        obj['source_pdfs'] = sourcePdfs;
        obj['metadata'] = metadata;
        obj['password'] = password;
        obj['pdf_hash'] = pdfHash;
        obj['download_url'] = downloadUrl;
        obj['actions'] = actions;
    }

    /**
     * Constructs a <code>CombinedSubmission</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CombinedSubmission} obj Optional instance to populate.
     * @return {module:model/CombinedSubmission} The populated <code>CombinedSubmission</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CombinedSubmission();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('state')) {
                obj['state'] = ApiClient.convertToType(data['state'], 'String');
            }
            if (data.hasOwnProperty('expired')) {
                obj['expired'] = ApiClient.convertToType(data['expired'], 'Boolean');
            }
            if (data.hasOwnProperty('expires_in')) {
                obj['expires_in'] = ApiClient.convertToType(data['expires_in'], 'Number');
            }
            if (data.hasOwnProperty('expires_at')) {
                obj['expires_at'] = ApiClient.convertToType(data['expires_at'], 'String');
            }
            if (data.hasOwnProperty('processed_at')) {
                obj['processed_at'] = ApiClient.convertToType(data['processed_at'], 'String');
            }
            if (data.hasOwnProperty('error_message')) {
                obj['error_message'] = ApiClient.convertToType(data['error_message'], 'String');
            }
            if (data.hasOwnProperty('submission_ids')) {
                obj['submission_ids'] = ApiClient.convertToType(data['submission_ids'], ['String']);
            }
            if (data.hasOwnProperty('source_pdfs')) {
                obj['source_pdfs'] = ApiClient.convertToType(data['source_pdfs'], [Object]);
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('password')) {
                obj['password'] = ApiClient.convertToType(data['password'], 'String');
            }
            if (data.hasOwnProperty('pdf_hash')) {
                obj['pdf_hash'] = ApiClient.convertToType(data['pdf_hash'], 'String');
            }
            if (data.hasOwnProperty('download_url')) {
                obj['download_url'] = ApiClient.convertToType(data['download_url'], 'String');
            }
            if (data.hasOwnProperty('actions')) {
                obj['actions'] = ApiClient.convertToType(data['actions'], [CombinedSubmissionAction]);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CombinedSubmission</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CombinedSubmission</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CombinedSubmission.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['state'] && !(typeof data['state'] === 'string' || data['state'] instanceof String)) {
            throw new Error("Expected the field `state` to be a primitive type in the JSON string but got " + data['state']);
        }
        // ensure the json data is a string
        if (data['expires_at'] && !(typeof data['expires_at'] === 'string' || data['expires_at'] instanceof String)) {
            throw new Error("Expected the field `expires_at` to be a primitive type in the JSON string but got " + data['expires_at']);
        }
        // ensure the json data is a string
        if (data['processed_at'] && !(typeof data['processed_at'] === 'string' || data['processed_at'] instanceof String)) {
            throw new Error("Expected the field `processed_at` to be a primitive type in the JSON string but got " + data['processed_at']);
        }
        // ensure the json data is a string
        if (data['error_message'] && !(typeof data['error_message'] === 'string' || data['error_message'] instanceof String)) {
            throw new Error("Expected the field `error_message` to be a primitive type in the JSON string but got " + data['error_message']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['submission_ids'])) {
            throw new Error("Expected the field `submission_ids` to be an array in the JSON data but got " + data['submission_ids']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['source_pdfs'])) {
            throw new Error("Expected the field `source_pdfs` to be an array in the JSON data but got " + data['source_pdfs']);
        }
        // ensure the json data is a string
        if (data['password'] && !(typeof data['password'] === 'string' || data['password'] instanceof String)) {
            throw new Error("Expected the field `password` to be a primitive type in the JSON string but got " + data['password']);
        }
        // ensure the json data is a string
        if (data['pdf_hash'] && !(typeof data['pdf_hash'] === 'string' || data['pdf_hash'] instanceof String)) {
            throw new Error("Expected the field `pdf_hash` to be a primitive type in the JSON string but got " + data['pdf_hash']);
        }
        // ensure the json data is a string
        if (data['download_url'] && !(typeof data['download_url'] === 'string' || data['download_url'] instanceof String)) {
            throw new Error("Expected the field `download_url` to be a primitive type in the JSON string but got " + data['download_url']);
        }
        if (data['actions']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['actions'])) {
                throw new Error("Expected the field `actions` to be an array in the JSON data but got " + data['actions']);
            }
            // validate the optional field `actions` (array)
            for (const item of data['actions']) {
                CombinedSubmissionAction.validateJSON(item);
            };
        }

        return true;
    }


}

CombinedSubmission.RequiredProperties = ["id", "state", "expired", "expires_in", "expires_at", "processed_at", "error_message", "submission_ids", "source_pdfs", "metadata", "password", "pdf_hash", "download_url", "actions"];

/**
 * @member {String} id
 */
CombinedSubmission.prototype['id'] = undefined;

/**
 * @member {module:model/CombinedSubmission.StateEnum} state
 */
CombinedSubmission.prototype['state'] = undefined;

/**
 * @member {Boolean} expired
 */
CombinedSubmission.prototype['expired'] = undefined;

/**
 * @member {Number} expires_in
 */
CombinedSubmission.prototype['expires_in'] = undefined;

/**
 * @member {String} expires_at
 */
CombinedSubmission.prototype['expires_at'] = undefined;

/**
 * @member {String} processed_at
 */
CombinedSubmission.prototype['processed_at'] = undefined;

/**
 * @member {String} error_message
 */
CombinedSubmission.prototype['error_message'] = undefined;

/**
 * @member {Array.<String>} submission_ids
 */
CombinedSubmission.prototype['submission_ids'] = undefined;

/**
 * @member {Array.<Object>} source_pdfs
 */
CombinedSubmission.prototype['source_pdfs'] = undefined;

/**
 * @member {Object} metadata
 */
CombinedSubmission.prototype['metadata'] = undefined;

/**
 * @member {String} password
 */
CombinedSubmission.prototype['password'] = undefined;

/**
 * @member {String} pdf_hash
 */
CombinedSubmission.prototype['pdf_hash'] = undefined;

/**
 * @member {String} download_url
 */
CombinedSubmission.prototype['download_url'] = undefined;

/**
 * @member {Array.<module:model/CombinedSubmissionAction>} actions
 */
CombinedSubmission.prototype['actions'] = undefined;





/**
 * Allowed values for the <code>state</code> property.
 * @enum {String}
 * @readonly
 */
CombinedSubmission['StateEnum'] = {

    /**
     * value: "pending"
     * @const
     */
    "pending": "pending",

    /**
     * value: "processed"
     * @const
     */
    "processed": "processed",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default CombinedSubmission;

