/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The CombinedSubmissionData model module.
 * @module model/CombinedSubmissionData
 * @version 2.0.0
 */
class CombinedSubmissionData {
    /**
     * Constructs a new <code>CombinedSubmissionData</code>.
     * @alias module:model/CombinedSubmissionData
     * @param submissionIds {Array.<String>} 
     */
    constructor(submissionIds) { 
        
        CombinedSubmissionData.initialize(this, submissionIds);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, submissionIds) { 
        obj['submission_ids'] = submissionIds;
    }

    /**
     * Constructs a <code>CombinedSubmissionData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CombinedSubmissionData} obj Optional instance to populate.
     * @return {module:model/CombinedSubmissionData} The populated <code>CombinedSubmissionData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CombinedSubmissionData();

            if (data.hasOwnProperty('expires_in')) {
                obj['expires_in'] = ApiClient.convertToType(data['expires_in'], 'Number');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('password')) {
                obj['password'] = ApiClient.convertToType(data['password'], 'String');
            }
            if (data.hasOwnProperty('submission_ids')) {
                obj['submission_ids'] = ApiClient.convertToType(data['submission_ids'], ['String']);
            }
            if (data.hasOwnProperty('test')) {
                obj['test'] = ApiClient.convertToType(data['test'], 'Boolean');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CombinedSubmissionData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CombinedSubmissionData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CombinedSubmissionData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['password'] && !(typeof data['password'] === 'string' || data['password'] instanceof String)) {
            throw new Error("Expected the field `password` to be a primitive type in the JSON string but got " + data['password']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['submission_ids'])) {
            throw new Error("Expected the field `submission_ids` to be an array in the JSON data but got " + data['submission_ids']);
        }

        return true;
    }


}

CombinedSubmissionData.RequiredProperties = ["submission_ids"];

/**
 * @member {Number} expires_in
 */
CombinedSubmissionData.prototype['expires_in'] = undefined;

/**
 * @member {Object} metadata
 */
CombinedSubmissionData.prototype['metadata'] = undefined;

/**
 * @member {String} password
 */
CombinedSubmissionData.prototype['password'] = undefined;

/**
 * @member {Array.<String>} submission_ids
 */
CombinedSubmissionData.prototype['submission_ids'] = undefined;

/**
 * @member {Boolean} test
 */
CombinedSubmissionData.prototype['test'] = undefined;






export default CombinedSubmissionData;

