/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import CombinedSubmission from './CombinedSubmission';

/**
 * The CreateCombinedSubmissionResponse model module.
 * @module model/CreateCombinedSubmissionResponse
 * @version 2.0.0
 */
class CreateCombinedSubmissionResponse {
    /**
     * Constructs a new <code>CreateCombinedSubmissionResponse</code>.
     * @alias module:model/CreateCombinedSubmissionResponse
     * @param status {module:model/CreateCombinedSubmissionResponse.StatusEnum} 
     * @param combinedSubmission {module:model/CombinedSubmission} 
     */
    constructor(status, combinedSubmission) { 
        
        CreateCombinedSubmissionResponse.initialize(this, status, combinedSubmission);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, status, combinedSubmission) { 
        obj['status'] = status;
        obj['combined_submission'] = combinedSubmission;
    }

    /**
     * Constructs a <code>CreateCombinedSubmissionResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateCombinedSubmissionResponse} obj Optional instance to populate.
     * @return {module:model/CreateCombinedSubmissionResponse} The populated <code>CreateCombinedSubmissionResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateCombinedSubmissionResponse();

            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('combined_submission')) {
                obj['combined_submission'] = CombinedSubmission.constructFromObject(data['combined_submission']);
            }
            if (data.hasOwnProperty('errors')) {
                obj['errors'] = ApiClient.convertToType(data['errors'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateCombinedSubmissionResponse</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateCombinedSubmissionResponse</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateCombinedSubmissionResponse.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['status'] && !(typeof data['status'] === 'string' || data['status'] instanceof String)) {
            throw new Error("Expected the field `status` to be a primitive type in the JSON string but got " + data['status']);
        }
        // validate the optional field `combined_submission`
        if (data['combined_submission']) { // data not null
          CombinedSubmission.validateJSON(data['combined_submission']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['errors'])) {
            throw new Error("Expected the field `errors` to be an array in the JSON data but got " + data['errors']);
        }

        return true;
    }


}

CreateCombinedSubmissionResponse.RequiredProperties = ["status", "combined_submission"];

/**
 * @member {module:model/CreateCombinedSubmissionResponse.StatusEnum} status
 */
CreateCombinedSubmissionResponse.prototype['status'] = undefined;

/**
 * @member {module:model/CombinedSubmission} combined_submission
 */
CreateCombinedSubmissionResponse.prototype['combined_submission'] = undefined;

/**
 * @member {Array.<String>} errors
 */
CreateCombinedSubmissionResponse.prototype['errors'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
CreateCombinedSubmissionResponse['StatusEnum'] = {

    /**
     * value: "success"
     * @const
     */
    "success": "success",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default CreateCombinedSubmissionResponse;

