/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import CreateSubmissionDataRequestData from './CreateSubmissionDataRequestData';

/**
 * The CreatePdfSubmissionData model module.
 * @module model/CreatePdfSubmissionData
 * @version 2.0.0
 */
class CreatePdfSubmissionData {
    /**
     * Constructs a new <code>CreatePdfSubmissionData</code>.
     * @alias module:model/CreatePdfSubmissionData
     * @param data {Object} 
     */
    constructor(data) { 
        
        CreatePdfSubmissionData.initialize(this, data);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, data) { 
        obj['data'] = data;
    }

    /**
     * Constructs a <code>CreatePdfSubmissionData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreatePdfSubmissionData} obj Optional instance to populate.
     * @return {module:model/CreatePdfSubmissionData} The populated <code>CreatePdfSubmissionData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreatePdfSubmissionData();

            if (data.hasOwnProperty('data')) {
                obj['data'] = ApiClient.convertToType(data['data'], Object);
            }
            if (data.hasOwnProperty('data_requests')) {
                obj['data_requests'] = ApiClient.convertToType(data['data_requests'], [CreateSubmissionDataRequestData]);
            }
            if (data.hasOwnProperty('editable')) {
                obj['editable'] = ApiClient.convertToType(data['editable'], 'Boolean');
            }
            if (data.hasOwnProperty('expires_in')) {
                obj['expires_in'] = ApiClient.convertToType(data['expires_in'], 'Number');
            }
            if (data.hasOwnProperty('field_overrides')) {
                obj['field_overrides'] = ApiClient.convertToType(data['field_overrides'], Object);
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('password')) {
                obj['password'] = ApiClient.convertToType(data['password'], 'String');
            }
            if (data.hasOwnProperty('test')) {
                obj['test'] = ApiClient.convertToType(data['test'], 'Boolean');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreatePdfSubmissionData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreatePdfSubmissionData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreatePdfSubmissionData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        if (data['data_requests']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['data_requests'])) {
                throw new Error("Expected the field `data_requests` to be an array in the JSON data but got " + data['data_requests']);
            }
            // validate the optional field `data_requests` (array)
            for (const item of data['data_requests']) {
                CreateSubmissionDataRequestData.validateJSON(item);
            };
        }
        // ensure the json data is a string
        if (data['password'] && !(typeof data['password'] === 'string' || data['password'] instanceof String)) {
            throw new Error("Expected the field `password` to be a primitive type in the JSON string but got " + data['password']);
        }

        return true;
    }


}

CreatePdfSubmissionData.RequiredProperties = ["data"];

/**
 * @member {Object} data
 */
CreatePdfSubmissionData.prototype['data'] = undefined;

/**
 * @member {Array.<module:model/CreateSubmissionDataRequestData>} data_requests
 */
CreatePdfSubmissionData.prototype['data_requests'] = undefined;

/**
 * @member {Boolean} editable
 */
CreatePdfSubmissionData.prototype['editable'] = undefined;

/**
 * @member {Number} expires_in
 */
CreatePdfSubmissionData.prototype['expires_in'] = undefined;

/**
 * @member {Object} field_overrides
 */
CreatePdfSubmissionData.prototype['field_overrides'] = undefined;

/**
 * @member {Object} metadata
 */
CreatePdfSubmissionData.prototype['metadata'] = undefined;

/**
 * @member {String} password
 */
CreatePdfSubmissionData.prototype['password'] = undefined;

/**
 * @member {Boolean} test
 */
CreatePdfSubmissionData.prototype['test'] = undefined;






export default CreatePdfSubmissionData;

