/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import SubmissionDataRequestEvent from './SubmissionDataRequestEvent';

/**
 * The CreateSubmissionDataRequestEventResponse model module.
 * @module model/CreateSubmissionDataRequestEventResponse
 * @version 2.0.0
 */
class CreateSubmissionDataRequestEventResponse {
    /**
     * Constructs a new <code>CreateSubmissionDataRequestEventResponse</code>.
     * @alias module:model/CreateSubmissionDataRequestEventResponse
     * @param status {module:model/CreateSubmissionDataRequestEventResponse.StatusEnum} 
     * @param event {module:model/SubmissionDataRequestEvent} 
     */
    constructor(status, event) { 
        
        CreateSubmissionDataRequestEventResponse.initialize(this, status, event);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, status, event) { 
        obj['status'] = status;
        obj['event'] = event;
    }

    /**
     * Constructs a <code>CreateSubmissionDataRequestEventResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateSubmissionDataRequestEventResponse} obj Optional instance to populate.
     * @return {module:model/CreateSubmissionDataRequestEventResponse} The populated <code>CreateSubmissionDataRequestEventResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateSubmissionDataRequestEventResponse();

            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('event')) {
                obj['event'] = SubmissionDataRequestEvent.constructFromObject(data['event']);
            }
            if (data.hasOwnProperty('errors')) {
                obj['errors'] = ApiClient.convertToType(data['errors'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateSubmissionDataRequestEventResponse</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateSubmissionDataRequestEventResponse</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateSubmissionDataRequestEventResponse.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['status'] && !(typeof data['status'] === 'string' || data['status'] instanceof String)) {
            throw new Error("Expected the field `status` to be a primitive type in the JSON string but got " + data['status']);
        }
        // validate the optional field `event`
        if (data['event']) { // data not null
          SubmissionDataRequestEvent.validateJSON(data['event']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['errors'])) {
            throw new Error("Expected the field `errors` to be an array in the JSON data but got " + data['errors']);
        }

        return true;
    }


}

CreateSubmissionDataRequestEventResponse.RequiredProperties = ["status", "event"];

/**
 * @member {module:model/CreateSubmissionDataRequestEventResponse.StatusEnum} status
 */
CreateSubmissionDataRequestEventResponse.prototype['status'] = undefined;

/**
 * @member {module:model/SubmissionDataRequestEvent} event
 */
CreateSubmissionDataRequestEventResponse.prototype['event'] = undefined;

/**
 * @member {Array.<String>} errors
 */
CreateSubmissionDataRequestEventResponse.prototype['errors'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
CreateSubmissionDataRequestEventResponse['StatusEnum'] = {

    /**
     * value: "success"
     * @const
     */
    "success": "success",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default CreateSubmissionDataRequestEventResponse;

