/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import SubmissionDataRequestShow from './SubmissionDataRequestShow';

/**
 * The CreateSubmissionDataRequestResponse model module.
 * @module model/CreateSubmissionDataRequestResponse
 * @version 2.0.0
 */
class CreateSubmissionDataRequestResponse {
    /**
     * Constructs a new <code>CreateSubmissionDataRequestResponse</code>.
     * @alias module:model/CreateSubmissionDataRequestResponse
     * @param status {module:model/CreateSubmissionDataRequestResponse.StatusEnum} 
     * @param dataRequest {module:model/SubmissionDataRequestShow} 
     */
    constructor(status, dataRequest) { 
        
        CreateSubmissionDataRequestResponse.initialize(this, status, dataRequest);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, status, dataRequest) { 
        obj['status'] = status;
        obj['data_request'] = dataRequest;
    }

    /**
     * Constructs a <code>CreateSubmissionDataRequestResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateSubmissionDataRequestResponse} obj Optional instance to populate.
     * @return {module:model/CreateSubmissionDataRequestResponse} The populated <code>CreateSubmissionDataRequestResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateSubmissionDataRequestResponse();

            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('data_request')) {
                obj['data_request'] = SubmissionDataRequestShow.constructFromObject(data['data_request']);
            }
            if (data.hasOwnProperty('errors')) {
                obj['errors'] = ApiClient.convertToType(data['errors'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateSubmissionDataRequestResponse</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateSubmissionDataRequestResponse</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateSubmissionDataRequestResponse.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['status'] && !(typeof data['status'] === 'string' || data['status'] instanceof String)) {
            throw new Error("Expected the field `status` to be a primitive type in the JSON string but got " + data['status']);
        }
        // validate the optional field `data_request`
        if (data['data_request']) { // data not null
          SubmissionDataRequestShow.validateJSON(data['data_request']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['errors'])) {
            throw new Error("Expected the field `errors` to be an array in the JSON data but got " + data['errors']);
        }

        return true;
    }


}

CreateSubmissionDataRequestResponse.RequiredProperties = ["status", "data_request"];

/**
 * @member {module:model/CreateSubmissionDataRequestResponse.StatusEnum} status
 */
CreateSubmissionDataRequestResponse.prototype['status'] = undefined;

/**
 * @member {module:model/SubmissionDataRequestShow} data_request
 */
CreateSubmissionDataRequestResponse.prototype['data_request'] = undefined;

/**
 * @member {Array.<String>} errors
 */
CreateSubmissionDataRequestResponse.prototype['errors'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
CreateSubmissionDataRequestResponse['StatusEnum'] = {

    /**
     * value: "success"
     * @const
     */
    "success": "success",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default CreateSubmissionDataRequestResponse;

