/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import SubmissionDataRequestToken from './SubmissionDataRequestToken';

/**
 * The CreateSubmissionDataRequestTokenResponse model module.
 * @module model/CreateSubmissionDataRequestTokenResponse
 * @version 2.0.0
 */
class CreateSubmissionDataRequestTokenResponse {
    /**
     * Constructs a new <code>CreateSubmissionDataRequestTokenResponse</code>.
     * @alias module:model/CreateSubmissionDataRequestTokenResponse
     * @param status {module:model/CreateSubmissionDataRequestTokenResponse.StatusEnum} 
     * @param token {module:model/SubmissionDataRequestToken} 
     */
    constructor(status, token) { 
        
        CreateSubmissionDataRequestTokenResponse.initialize(this, status, token);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, status, token) { 
        obj['status'] = status;
        obj['token'] = token;
    }

    /**
     * Constructs a <code>CreateSubmissionDataRequestTokenResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CreateSubmissionDataRequestTokenResponse} obj Optional instance to populate.
     * @return {module:model/CreateSubmissionDataRequestTokenResponse} The populated <code>CreateSubmissionDataRequestTokenResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CreateSubmissionDataRequestTokenResponse();

            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('token')) {
                obj['token'] = SubmissionDataRequestToken.constructFromObject(data['token']);
            }
            if (data.hasOwnProperty('errors')) {
                obj['errors'] = ApiClient.convertToType(data['errors'], ['String']);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>CreateSubmissionDataRequestTokenResponse</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>CreateSubmissionDataRequestTokenResponse</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of CreateSubmissionDataRequestTokenResponse.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['status'] && !(typeof data['status'] === 'string' || data['status'] instanceof String)) {
            throw new Error("Expected the field `status` to be a primitive type in the JSON string but got " + data['status']);
        }
        // validate the optional field `token`
        if (data['token']) { // data not null
          SubmissionDataRequestToken.validateJSON(data['token']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['errors'])) {
            throw new Error("Expected the field `errors` to be an array in the JSON data but got " + data['errors']);
        }

        return true;
    }


}

CreateSubmissionDataRequestTokenResponse.RequiredProperties = ["status", "token"];

/**
 * @member {module:model/CreateSubmissionDataRequestTokenResponse.StatusEnum} status
 */
CreateSubmissionDataRequestTokenResponse.prototype['status'] = undefined;

/**
 * @member {module:model/SubmissionDataRequestToken} token
 */
CreateSubmissionDataRequestTokenResponse.prototype['token'] = undefined;

/**
 * @member {Array.<String>} errors
 */
CreateSubmissionDataRequestTokenResponse.prototype['errors'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
CreateSubmissionDataRequestTokenResponse['StatusEnum'] = {

    /**
     * value: "success"
     * @const
     */
    "success": "success",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default CreateSubmissionDataRequestTokenResponse;

