/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The Folder model module.
 * @module model/Folder
 * @version 2.0.0
 */
class Folder {
    /**
     * Constructs a new <code>Folder</code>.
     * @alias module:model/Folder
     * @param id {String} 
     * @param name {String} 
     * @param path {String} 
     * @param parentFolderId {String} 
     */
    constructor(id, name, path, parentFolderId) { 
        
        Folder.initialize(this, id, name, path, parentFolderId);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, name, path, parentFolderId) { 
        obj['id'] = id;
        obj['name'] = name;
        obj['path'] = path;
        obj['parent_folder_id'] = parentFolderId;
    }

    /**
     * Constructs a <code>Folder</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Folder} obj Optional instance to populate.
     * @return {module:model/Folder} The populated <code>Folder</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Folder();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('path')) {
                obj['path'] = ApiClient.convertToType(data['path'], 'String');
            }
            if (data.hasOwnProperty('parent_folder_id')) {
                obj['parent_folder_id'] = ApiClient.convertToType(data['parent_folder_id'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>Folder</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>Folder</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of Folder.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is a string
        if (data['path'] && !(typeof data['path'] === 'string' || data['path'] instanceof String)) {
            throw new Error("Expected the field `path` to be a primitive type in the JSON string but got " + data['path']);
        }
        // ensure the json data is a string
        if (data['parent_folder_id'] && !(typeof data['parent_folder_id'] === 'string' || data['parent_folder_id'] instanceof String)) {
            throw new Error("Expected the field `parent_folder_id` to be a primitive type in the JSON string but got " + data['parent_folder_id']);
        }

        return true;
    }


}

Folder.RequiredProperties = ["id", "name", "path", "parent_folder_id"];

/**
 * @member {String} id
 */
Folder.prototype['id'] = undefined;

/**
 * @member {String} name
 */
Folder.prototype['name'] = undefined;

/**
 * @member {String} path
 */
Folder.prototype['path'] = undefined;

/**
 * @member {String} parent_folder_id
 */
Folder.prototype['parent_folder_id'] = undefined;






export default Folder;

