/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import Submission from './Submission';

/**
 * The ListSubmissionsResponse model module.
 * @module model/ListSubmissionsResponse
 * @version 2.0.0
 */
class ListSubmissionsResponse {
    /**
     * Constructs a new <code>ListSubmissionsResponse</code>.
     * @alias module:model/ListSubmissionsResponse
     * @param submissions {Array.<module:model/Submission>} 
     * @param limit {Number} 
     * @param nextCursor {String} 
     */
    constructor(submissions, limit, nextCursor) { 
        
        ListSubmissionsResponse.initialize(this, submissions, limit, nextCursor);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, submissions, limit, nextCursor) { 
        obj['submissions'] = submissions;
        obj['limit'] = limit;
        obj['next_cursor'] = nextCursor;
    }

    /**
     * Constructs a <code>ListSubmissionsResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ListSubmissionsResponse} obj Optional instance to populate.
     * @return {module:model/ListSubmissionsResponse} The populated <code>ListSubmissionsResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ListSubmissionsResponse();

            if (data.hasOwnProperty('submissions')) {
                obj['submissions'] = ApiClient.convertToType(data['submissions'], [Submission]);
            }
            if (data.hasOwnProperty('limit')) {
                obj['limit'] = ApiClient.convertToType(data['limit'], 'Number');
            }
            if (data.hasOwnProperty('next_cursor')) {
                obj['next_cursor'] = ApiClient.convertToType(data['next_cursor'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>ListSubmissionsResponse</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>ListSubmissionsResponse</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of ListSubmissionsResponse.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        if (data['submissions']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['submissions'])) {
                throw new Error("Expected the field `submissions` to be an array in the JSON data but got " + data['submissions']);
            }
            // validate the optional field `submissions` (array)
            for (const item of data['submissions']) {
                Submission.validateJSON(item);
            };
        }
        // ensure the json data is a string
        if (data['next_cursor'] && !(typeof data['next_cursor'] === 'string' || data['next_cursor'] instanceof String)) {
            throw new Error("Expected the field `next_cursor` to be a primitive type in the JSON string but got " + data['next_cursor']);
        }

        return true;
    }


}

ListSubmissionsResponse.RequiredProperties = ["submissions", "limit", "next_cursor"];

/**
 * @member {Array.<module:model/Submission>} submissions
 */
ListSubmissionsResponse.prototype['submissions'] = undefined;

/**
 * @member {Number} limit
 */
ListSubmissionsResponse.prototype['limit'] = undefined;

/**
 * @member {String} next_cursor
 */
ListSubmissionsResponse.prototype['next_cursor'] = undefined;






export default ListSubmissionsResponse;

