/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubmissionAction model module.
 * @module model/SubmissionAction
 * @version 2.0.0
 */
class SubmissionAction {
    /**
     * Constructs a new <code>SubmissionAction</code>.
     * @alias module:model/SubmissionAction
     * @param id {String} 
     * @param integrationId {String} 
     * @param state {module:model/SubmissionAction.StateEnum} 
     * @param actionType {module:model/SubmissionAction.ActionTypeEnum} 
     * @param actionCategory {module:model/SubmissionAction.ActionCategoryEnum} 
     * @param resultData {Object} 
     */
    constructor(id, integrationId, state, actionType, actionCategory, resultData) { 
        
        SubmissionAction.initialize(this, id, integrationId, state, actionType, actionCategory, resultData);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, integrationId, state, actionType, actionCategory, resultData) { 
        obj['id'] = id;
        obj['integration_id'] = integrationId;
        obj['state'] = state;
        obj['action_type'] = actionType;
        obj['action_category'] = actionCategory;
        obj['result_data'] = resultData;
    }

    /**
     * Constructs a <code>SubmissionAction</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionAction} obj Optional instance to populate.
     * @return {module:model/SubmissionAction} The populated <code>SubmissionAction</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionAction();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('integration_id')) {
                obj['integration_id'] = ApiClient.convertToType(data['integration_id'], 'String');
            }
            if (data.hasOwnProperty('state')) {
                obj['state'] = ApiClient.convertToType(data['state'], 'String');
            }
            if (data.hasOwnProperty('action_type')) {
                obj['action_type'] = ApiClient.convertToType(data['action_type'], 'String');
            }
            if (data.hasOwnProperty('action_category')) {
                obj['action_category'] = ApiClient.convertToType(data['action_category'], 'String');
            }
            if (data.hasOwnProperty('result_data')) {
                obj['result_data'] = ApiClient.convertToType(data['result_data'], Object);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionAction</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionAction</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionAction.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['integration_id'] && !(typeof data['integration_id'] === 'string' || data['integration_id'] instanceof String)) {
            throw new Error("Expected the field `integration_id` to be a primitive type in the JSON string but got " + data['integration_id']);
        }
        // ensure the json data is a string
        if (data['state'] && !(typeof data['state'] === 'string' || data['state'] instanceof String)) {
            throw new Error("Expected the field `state` to be a primitive type in the JSON string but got " + data['state']);
        }
        // ensure the json data is a string
        if (data['action_type'] && !(typeof data['action_type'] === 'string' || data['action_type'] instanceof String)) {
            throw new Error("Expected the field `action_type` to be a primitive type in the JSON string but got " + data['action_type']);
        }
        // ensure the json data is a string
        if (data['action_category'] && !(typeof data['action_category'] === 'string' || data['action_category'] instanceof String)) {
            throw new Error("Expected the field `action_category` to be a primitive type in the JSON string but got " + data['action_category']);
        }

        return true;
    }


}

SubmissionAction.RequiredProperties = ["id", "integration_id", "state", "action_type", "action_category", "result_data"];

/**
 * @member {String} id
 */
SubmissionAction.prototype['id'] = undefined;

/**
 * @member {String} integration_id
 */
SubmissionAction.prototype['integration_id'] = undefined;

/**
 * @member {module:model/SubmissionAction.StateEnum} state
 */
SubmissionAction.prototype['state'] = undefined;

/**
 * @member {module:model/SubmissionAction.ActionTypeEnum} action_type
 */
SubmissionAction.prototype['action_type'] = undefined;

/**
 * @member {module:model/SubmissionAction.ActionCategoryEnum} action_category
 */
SubmissionAction.prototype['action_category'] = undefined;

/**
 * @member {Object} result_data
 */
SubmissionAction.prototype['result_data'] = undefined;





/**
 * Allowed values for the <code>state</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionAction['StateEnum'] = {

    /**
     * value: "pending"
     * @const
     */
    "pending": "pending",

    /**
     * value: "processed"
     * @const
     */
    "processed": "processed",

    /**
     * value: "failed"
     * @const
     */
    "failed": "failed",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};


/**
 * Allowed values for the <code>action_type</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionAction['ActionTypeEnum'] = {

    /**
     * value: "webhook"
     * @const
     */
    "webhook": "webhook",

    /**
     * value: "slack_webhook"
     * @const
     */
    "slack_webhook": "slack_webhook",

    /**
     * value: "email"
     * @const
     */
    "email": "email",

    /**
     * value: "aws_s3_upload"
     * @const
     */
    "aws_s3_upload": "aws_s3_upload"
};


/**
 * Allowed values for the <code>action_category</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionAction['ActionCategoryEnum'] = {

    /**
     * value: "notification"
     * @const
     */
    "notification": "notification",

    /**
     * value: "file_upload"
     * @const
     */
    "file_upload": "file_upload"
};



export default SubmissionAction;

