/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubmissionBatch model module.
 * @module model/SubmissionBatch
 * @version 2.0.0
 */
class SubmissionBatch {
    /**
     * Constructs a new <code>SubmissionBatch</code>.
     * @alias module:model/SubmissionBatch
     * @param id {String} 
     * @param state {module:model/SubmissionBatch.StateEnum} 
     * @param metadata {Object} 
     * @param processedAt {String} 
     * @param totalCount {Number} 
     * @param pendingCount {Number} 
     * @param errorCount {Number} 
     * @param completionPercentage {Number} 
     */
    constructor(id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage) { 
        
        SubmissionBatch.initialize(this, id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage) { 
        obj['id'] = id;
        obj['state'] = state;
        obj['metadata'] = metadata;
        obj['processed_at'] = processedAt;
        obj['total_count'] = totalCount;
        obj['pending_count'] = pendingCount;
        obj['error_count'] = errorCount;
        obj['completion_percentage'] = completionPercentage;
    }

    /**
     * Constructs a <code>SubmissionBatch</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionBatch} obj Optional instance to populate.
     * @return {module:model/SubmissionBatch} The populated <code>SubmissionBatch</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionBatch();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('state')) {
                obj['state'] = ApiClient.convertToType(data['state'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('processed_at')) {
                obj['processed_at'] = ApiClient.convertToType(data['processed_at'], 'String');
            }
            if (data.hasOwnProperty('total_count')) {
                obj['total_count'] = ApiClient.convertToType(data['total_count'], 'Number');
            }
            if (data.hasOwnProperty('pending_count')) {
                obj['pending_count'] = ApiClient.convertToType(data['pending_count'], 'Number');
            }
            if (data.hasOwnProperty('error_count')) {
                obj['error_count'] = ApiClient.convertToType(data['error_count'], 'Number');
            }
            if (data.hasOwnProperty('completion_percentage')) {
                obj['completion_percentage'] = ApiClient.convertToType(data['completion_percentage'], 'Number');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionBatch</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionBatch</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionBatch.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['state'] && !(typeof data['state'] === 'string' || data['state'] instanceof String)) {
            throw new Error("Expected the field `state` to be a primitive type in the JSON string but got " + data['state']);
        }
        // ensure the json data is a string
        if (data['processed_at'] && !(typeof data['processed_at'] === 'string' || data['processed_at'] instanceof String)) {
            throw new Error("Expected the field `processed_at` to be a primitive type in the JSON string but got " + data['processed_at']);
        }

        return true;
    }


}

SubmissionBatch.RequiredProperties = ["id", "state", "metadata", "processed_at", "total_count", "pending_count", "error_count", "completion_percentage"];

/**
 * @member {String} id
 */
SubmissionBatch.prototype['id'] = undefined;

/**
 * @member {module:model/SubmissionBatch.StateEnum} state
 */
SubmissionBatch.prototype['state'] = undefined;

/**
 * @member {Object} metadata
 */
SubmissionBatch.prototype['metadata'] = undefined;

/**
 * @member {String} processed_at
 */
SubmissionBatch.prototype['processed_at'] = undefined;

/**
 * @member {Number} total_count
 */
SubmissionBatch.prototype['total_count'] = undefined;

/**
 * @member {Number} pending_count
 */
SubmissionBatch.prototype['pending_count'] = undefined;

/**
 * @member {Number} error_count
 */
SubmissionBatch.prototype['error_count'] = undefined;

/**
 * @member {Number} completion_percentage
 */
SubmissionBatch.prototype['completion_percentage'] = undefined;





/**
 * Allowed values for the <code>state</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionBatch['StateEnum'] = {

    /**
     * value: "pending"
     * @const
     */
    "pending": "pending",

    /**
     * value: "processed"
     * @const
     */
    "processed": "processed",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default SubmissionBatch;

