/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubmissionBatchData model module.
 * @module model/SubmissionBatchData
 * @version 2.0.0
 */
class SubmissionBatchData {
    /**
     * Constructs a new <code>SubmissionBatchData</code>.
     * @alias module:model/SubmissionBatchData
     * @param submissions {Array.<Object>} 
     */
    constructor(submissions) { 
        
        SubmissionBatchData.initialize(this, submissions);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, submissions) { 
        obj['submissions'] = submissions;
    }

    /**
     * Constructs a <code>SubmissionBatchData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionBatchData} obj Optional instance to populate.
     * @return {module:model/SubmissionBatchData} The populated <code>SubmissionBatchData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionBatchData();

            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('submissions')) {
                obj['submissions'] = ApiClient.convertToType(data['submissions'], [Object]);
            }
            if (data.hasOwnProperty('test')) {
                obj['test'] = ApiClient.convertToType(data['test'], 'Boolean');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionBatchData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionBatchData</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionBatchData.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is an array
        if (!Array.isArray(data['submissions'])) {
            throw new Error("Expected the field `submissions` to be an array in the JSON data but got " + data['submissions']);
        }

        return true;
    }


}

SubmissionBatchData.RequiredProperties = ["submissions"];

/**
 * @member {Object} metadata
 */
SubmissionBatchData.prototype['metadata'] = undefined;

/**
 * @member {Array.<Object>} submissions
 */
SubmissionBatchData.prototype['submissions'] = undefined;

/**
 * @member {Boolean} test
 */
SubmissionBatchData.prototype['test'] = undefined;






export default SubmissionBatchData;

