/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import SubmissionPreview from './SubmissionPreview';

/**
 * The SubmissionBatchWithSubmissions model module.
 * @module model/SubmissionBatchWithSubmissions
 * @version 2.0.0
 */
class SubmissionBatchWithSubmissions {
    /**
     * Constructs a new <code>SubmissionBatchWithSubmissions</code>.
     * @alias module:model/SubmissionBatchWithSubmissions
     * @param id {String} 
     * @param state {module:model/SubmissionBatchWithSubmissions.StateEnum} 
     * @param metadata {Object} 
     * @param processedAt {String} 
     * @param totalCount {Number} 
     * @param pendingCount {Number} 
     * @param errorCount {Number} 
     * @param completionPercentage {Number} 
     */
    constructor(id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage) { 
        
        SubmissionBatchWithSubmissions.initialize(this, id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, state, metadata, processedAt, totalCount, pendingCount, errorCount, completionPercentage) { 
        obj['id'] = id;
        obj['state'] = state;
        obj['metadata'] = metadata;
        obj['processed_at'] = processedAt;
        obj['total_count'] = totalCount;
        obj['pending_count'] = pendingCount;
        obj['error_count'] = errorCount;
        obj['completion_percentage'] = completionPercentage;
    }

    /**
     * Constructs a <code>SubmissionBatchWithSubmissions</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionBatchWithSubmissions} obj Optional instance to populate.
     * @return {module:model/SubmissionBatchWithSubmissions} The populated <code>SubmissionBatchWithSubmissions</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionBatchWithSubmissions();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('state')) {
                obj['state'] = ApiClient.convertToType(data['state'], 'String');
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('processed_at')) {
                obj['processed_at'] = ApiClient.convertToType(data['processed_at'], 'String');
            }
            if (data.hasOwnProperty('total_count')) {
                obj['total_count'] = ApiClient.convertToType(data['total_count'], 'Number');
            }
            if (data.hasOwnProperty('pending_count')) {
                obj['pending_count'] = ApiClient.convertToType(data['pending_count'], 'Number');
            }
            if (data.hasOwnProperty('error_count')) {
                obj['error_count'] = ApiClient.convertToType(data['error_count'], 'Number');
            }
            if (data.hasOwnProperty('completion_percentage')) {
                obj['completion_percentage'] = ApiClient.convertToType(data['completion_percentage'], 'Number');
            }
            if (data.hasOwnProperty('submissions')) {
                obj['submissions'] = ApiClient.convertToType(data['submissions'], [SubmissionPreview]);
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionBatchWithSubmissions</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionBatchWithSubmissions</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionBatchWithSubmissions.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['state'] && !(typeof data['state'] === 'string' || data['state'] instanceof String)) {
            throw new Error("Expected the field `state` to be a primitive type in the JSON string but got " + data['state']);
        }
        // ensure the json data is a string
        if (data['processed_at'] && !(typeof data['processed_at'] === 'string' || data['processed_at'] instanceof String)) {
            throw new Error("Expected the field `processed_at` to be a primitive type in the JSON string but got " + data['processed_at']);
        }
        if (data['submissions']) { // data not null
            // ensure the json data is an array
            if (!Array.isArray(data['submissions'])) {
                throw new Error("Expected the field `submissions` to be an array in the JSON data but got " + data['submissions']);
            }
            // validate the optional field `submissions` (array)
            for (const item of data['submissions']) {
                SubmissionPreview.validateJSON(item);
            };
        }

        return true;
    }


}

SubmissionBatchWithSubmissions.RequiredProperties = ["id", "state", "metadata", "processed_at", "total_count", "pending_count", "error_count", "completion_percentage"];

/**
 * @member {String} id
 */
SubmissionBatchWithSubmissions.prototype['id'] = undefined;

/**
 * @member {module:model/SubmissionBatchWithSubmissions.StateEnum} state
 */
SubmissionBatchWithSubmissions.prototype['state'] = undefined;

/**
 * @member {Object} metadata
 */
SubmissionBatchWithSubmissions.prototype['metadata'] = undefined;

/**
 * @member {String} processed_at
 */
SubmissionBatchWithSubmissions.prototype['processed_at'] = undefined;

/**
 * @member {Number} total_count
 */
SubmissionBatchWithSubmissions.prototype['total_count'] = undefined;

/**
 * @member {Number} pending_count
 */
SubmissionBatchWithSubmissions.prototype['pending_count'] = undefined;

/**
 * @member {Number} error_count
 */
SubmissionBatchWithSubmissions.prototype['error_count'] = undefined;

/**
 * @member {Number} completion_percentage
 */
SubmissionBatchWithSubmissions.prototype['completion_percentage'] = undefined;

/**
 * @member {Array.<module:model/SubmissionPreview>} submissions
 */
SubmissionBatchWithSubmissions.prototype['submissions'] = undefined;





/**
 * Allowed values for the <code>state</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionBatchWithSubmissions['StateEnum'] = {

    /**
     * value: "pending"
     * @const
     */
    "pending": "pending",

    /**
     * value: "processed"
     * @const
     */
    "processed": "processed",

    /**
     * value: "error"
     * @const
     */
    "error": "error"
};



export default SubmissionBatchWithSubmissions;

