/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubmissionDataRequest model module.
 * @module model/SubmissionDataRequest
 * @version 2.0.0
 */
class SubmissionDataRequest {
    /**
     * Constructs a new <code>SubmissionDataRequest</code>.
     * @alias module:model/SubmissionDataRequest
     * @param id {String} 
     * @param email {String} 
     * @param name {String} 
     * @param order {Number} 
     * @param sortOrder {Number} 
     * @param fields {Array.<String>} 
     * @param metadata {Object} 
     * @param state {module:model/SubmissionDataRequest.StateEnum} 
     * @param viewedAt {String} 
     * @param completedAt {String} 
     * @param data {Object} 
     * @param authType {module:model/SubmissionDataRequest.AuthTypeEnum} 
     * @param authSecondFactorType {module:model/SubmissionDataRequest.AuthSecondFactorTypeEnum} 
     * @param authProvider {String} 
     * @param authSessionStartedAt {String} 
     * @param authSessionIdHash {String} 
     * @param authUserIdHash {String} 
     * @param authUsernameHash {String} 
     * @param authPhoneNumberHash {String} 
     * @param ipAddress {String} 
     * @param userAgent {String} 
     */
    constructor(id, email, name, order, sortOrder, fields, metadata, state, viewedAt, completedAt, data, authType, authSecondFactorType, authProvider, authSessionStartedAt, authSessionIdHash, authUserIdHash, authUsernameHash, authPhoneNumberHash, ipAddress, userAgent) { 
        
        SubmissionDataRequest.initialize(this, id, email, name, order, sortOrder, fields, metadata, state, viewedAt, completedAt, data, authType, authSecondFactorType, authProvider, authSessionStartedAt, authSessionIdHash, authUserIdHash, authUsernameHash, authPhoneNumberHash, ipAddress, userAgent);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, email, name, order, sortOrder, fields, metadata, state, viewedAt, completedAt, data, authType, authSecondFactorType, authProvider, authSessionStartedAt, authSessionIdHash, authUserIdHash, authUsernameHash, authPhoneNumberHash, ipAddress, userAgent) { 
        obj['id'] = id;
        obj['email'] = email;
        obj['name'] = name;
        obj['order'] = order;
        obj['sort_order'] = sortOrder;
        obj['fields'] = fields;
        obj['metadata'] = metadata;
        obj['state'] = state;
        obj['viewed_at'] = viewedAt;
        obj['completed_at'] = completedAt;
        obj['data'] = data;
        obj['auth_type'] = authType;
        obj['auth_second_factor_type'] = authSecondFactorType;
        obj['auth_provider'] = authProvider;
        obj['auth_session_started_at'] = authSessionStartedAt;
        obj['auth_session_id_hash'] = authSessionIdHash;
        obj['auth_user_id_hash'] = authUserIdHash;
        obj['auth_username_hash'] = authUsernameHash;
        obj['auth_phone_number_hash'] = authPhoneNumberHash;
        obj['ip_address'] = ipAddress;
        obj['user_agent'] = userAgent;
    }

    /**
     * Constructs a <code>SubmissionDataRequest</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionDataRequest} obj Optional instance to populate.
     * @return {module:model/SubmissionDataRequest} The populated <code>SubmissionDataRequest</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionDataRequest();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('email')) {
                obj['email'] = ApiClient.convertToType(data['email'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('order')) {
                obj['order'] = ApiClient.convertToType(data['order'], 'Number');
            }
            if (data.hasOwnProperty('sort_order')) {
                obj['sort_order'] = ApiClient.convertToType(data['sort_order'], 'Number');
            }
            if (data.hasOwnProperty('fields')) {
                obj['fields'] = ApiClient.convertToType(data['fields'], ['String']);
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('state')) {
                obj['state'] = ApiClient.convertToType(data['state'], 'String');
            }
            if (data.hasOwnProperty('viewed_at')) {
                obj['viewed_at'] = ApiClient.convertToType(data['viewed_at'], 'String');
            }
            if (data.hasOwnProperty('completed_at')) {
                obj['completed_at'] = ApiClient.convertToType(data['completed_at'], 'String');
            }
            if (data.hasOwnProperty('data')) {
                obj['data'] = ApiClient.convertToType(data['data'], Object);
            }
            if (data.hasOwnProperty('auth_type')) {
                obj['auth_type'] = ApiClient.convertToType(data['auth_type'], 'String');
            }
            if (data.hasOwnProperty('auth_second_factor_type')) {
                obj['auth_second_factor_type'] = ApiClient.convertToType(data['auth_second_factor_type'], 'String');
            }
            if (data.hasOwnProperty('auth_provider')) {
                obj['auth_provider'] = ApiClient.convertToType(data['auth_provider'], 'String');
            }
            if (data.hasOwnProperty('auth_session_started_at')) {
                obj['auth_session_started_at'] = ApiClient.convertToType(data['auth_session_started_at'], 'String');
            }
            if (data.hasOwnProperty('auth_session_id_hash')) {
                obj['auth_session_id_hash'] = ApiClient.convertToType(data['auth_session_id_hash'], 'String');
            }
            if (data.hasOwnProperty('auth_user_id_hash')) {
                obj['auth_user_id_hash'] = ApiClient.convertToType(data['auth_user_id_hash'], 'String');
            }
            if (data.hasOwnProperty('auth_username_hash')) {
                obj['auth_username_hash'] = ApiClient.convertToType(data['auth_username_hash'], 'String');
            }
            if (data.hasOwnProperty('auth_phone_number_hash')) {
                obj['auth_phone_number_hash'] = ApiClient.convertToType(data['auth_phone_number_hash'], 'String');
            }
            if (data.hasOwnProperty('ip_address')) {
                obj['ip_address'] = ApiClient.convertToType(data['ip_address'], 'String');
            }
            if (data.hasOwnProperty('user_agent')) {
                obj['user_agent'] = ApiClient.convertToType(data['user_agent'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionDataRequest</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionDataRequest</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionDataRequest.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['email'] && !(typeof data['email'] === 'string' || data['email'] instanceof String)) {
            throw new Error("Expected the field `email` to be a primitive type in the JSON string but got " + data['email']);
        }
        // ensure the json data is a string
        if (data['name'] && !(typeof data['name'] === 'string' || data['name'] instanceof String)) {
            throw new Error("Expected the field `name` to be a primitive type in the JSON string but got " + data['name']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['fields'])) {
            throw new Error("Expected the field `fields` to be an array in the JSON data but got " + data['fields']);
        }
        // ensure the json data is a string
        if (data['state'] && !(typeof data['state'] === 'string' || data['state'] instanceof String)) {
            throw new Error("Expected the field `state` to be a primitive type in the JSON string but got " + data['state']);
        }
        // ensure the json data is a string
        if (data['viewed_at'] && !(typeof data['viewed_at'] === 'string' || data['viewed_at'] instanceof String)) {
            throw new Error("Expected the field `viewed_at` to be a primitive type in the JSON string but got " + data['viewed_at']);
        }
        // ensure the json data is a string
        if (data['completed_at'] && !(typeof data['completed_at'] === 'string' || data['completed_at'] instanceof String)) {
            throw new Error("Expected the field `completed_at` to be a primitive type in the JSON string but got " + data['completed_at']);
        }
        // ensure the json data is a string
        if (data['auth_type'] && !(typeof data['auth_type'] === 'string' || data['auth_type'] instanceof String)) {
            throw new Error("Expected the field `auth_type` to be a primitive type in the JSON string but got " + data['auth_type']);
        }
        // ensure the json data is a string
        if (data['auth_second_factor_type'] && !(typeof data['auth_second_factor_type'] === 'string' || data['auth_second_factor_type'] instanceof String)) {
            throw new Error("Expected the field `auth_second_factor_type` to be a primitive type in the JSON string but got " + data['auth_second_factor_type']);
        }
        // ensure the json data is a string
        if (data['auth_provider'] && !(typeof data['auth_provider'] === 'string' || data['auth_provider'] instanceof String)) {
            throw new Error("Expected the field `auth_provider` to be a primitive type in the JSON string but got " + data['auth_provider']);
        }
        // ensure the json data is a string
        if (data['auth_session_started_at'] && !(typeof data['auth_session_started_at'] === 'string' || data['auth_session_started_at'] instanceof String)) {
            throw new Error("Expected the field `auth_session_started_at` to be a primitive type in the JSON string but got " + data['auth_session_started_at']);
        }
        // ensure the json data is a string
        if (data['auth_session_id_hash'] && !(typeof data['auth_session_id_hash'] === 'string' || data['auth_session_id_hash'] instanceof String)) {
            throw new Error("Expected the field `auth_session_id_hash` to be a primitive type in the JSON string but got " + data['auth_session_id_hash']);
        }
        // ensure the json data is a string
        if (data['auth_user_id_hash'] && !(typeof data['auth_user_id_hash'] === 'string' || data['auth_user_id_hash'] instanceof String)) {
            throw new Error("Expected the field `auth_user_id_hash` to be a primitive type in the JSON string but got " + data['auth_user_id_hash']);
        }
        // ensure the json data is a string
        if (data['auth_username_hash'] && !(typeof data['auth_username_hash'] === 'string' || data['auth_username_hash'] instanceof String)) {
            throw new Error("Expected the field `auth_username_hash` to be a primitive type in the JSON string but got " + data['auth_username_hash']);
        }
        // ensure the json data is a string
        if (data['auth_phone_number_hash'] && !(typeof data['auth_phone_number_hash'] === 'string' || data['auth_phone_number_hash'] instanceof String)) {
            throw new Error("Expected the field `auth_phone_number_hash` to be a primitive type in the JSON string but got " + data['auth_phone_number_hash']);
        }
        // ensure the json data is a string
        if (data['ip_address'] && !(typeof data['ip_address'] === 'string' || data['ip_address'] instanceof String)) {
            throw new Error("Expected the field `ip_address` to be a primitive type in the JSON string but got " + data['ip_address']);
        }
        // ensure the json data is a string
        if (data['user_agent'] && !(typeof data['user_agent'] === 'string' || data['user_agent'] instanceof String)) {
            throw new Error("Expected the field `user_agent` to be a primitive type in the JSON string but got " + data['user_agent']);
        }

        return true;
    }


}

SubmissionDataRequest.RequiredProperties = ["id", "email", "name", "order", "sort_order", "fields", "metadata", "state", "viewed_at", "completed_at", "data", "auth_type", "auth_second_factor_type", "auth_provider", "auth_session_started_at", "auth_session_id_hash", "auth_user_id_hash", "auth_username_hash", "auth_phone_number_hash", "ip_address", "user_agent"];

/**
 * @member {String} id
 */
SubmissionDataRequest.prototype['id'] = undefined;

/**
 * @member {String} email
 */
SubmissionDataRequest.prototype['email'] = undefined;

/**
 * @member {String} name
 */
SubmissionDataRequest.prototype['name'] = undefined;

/**
 * @member {Number} order
 */
SubmissionDataRequest.prototype['order'] = undefined;

/**
 * @member {Number} sort_order
 */
SubmissionDataRequest.prototype['sort_order'] = undefined;

/**
 * @member {Array.<String>} fields
 */
SubmissionDataRequest.prototype['fields'] = undefined;

/**
 * @member {Object} metadata
 */
SubmissionDataRequest.prototype['metadata'] = undefined;

/**
 * @member {module:model/SubmissionDataRequest.StateEnum} state
 */
SubmissionDataRequest.prototype['state'] = undefined;

/**
 * @member {String} viewed_at
 */
SubmissionDataRequest.prototype['viewed_at'] = undefined;

/**
 * @member {String} completed_at
 */
SubmissionDataRequest.prototype['completed_at'] = undefined;

/**
 * @member {Object} data
 */
SubmissionDataRequest.prototype['data'] = undefined;

/**
 * @member {module:model/SubmissionDataRequest.AuthTypeEnum} auth_type
 */
SubmissionDataRequest.prototype['auth_type'] = undefined;

/**
 * @member {module:model/SubmissionDataRequest.AuthSecondFactorTypeEnum} auth_second_factor_type
 */
SubmissionDataRequest.prototype['auth_second_factor_type'] = undefined;

/**
 * @member {String} auth_provider
 */
SubmissionDataRequest.prototype['auth_provider'] = undefined;

/**
 * @member {String} auth_session_started_at
 */
SubmissionDataRequest.prototype['auth_session_started_at'] = undefined;

/**
 * @member {String} auth_session_id_hash
 */
SubmissionDataRequest.prototype['auth_session_id_hash'] = undefined;

/**
 * @member {String} auth_user_id_hash
 */
SubmissionDataRequest.prototype['auth_user_id_hash'] = undefined;

/**
 * @member {String} auth_username_hash
 */
SubmissionDataRequest.prototype['auth_username_hash'] = undefined;

/**
 * @member {String} auth_phone_number_hash
 */
SubmissionDataRequest.prototype['auth_phone_number_hash'] = undefined;

/**
 * @member {String} ip_address
 */
SubmissionDataRequest.prototype['ip_address'] = undefined;

/**
 * @member {String} user_agent
 */
SubmissionDataRequest.prototype['user_agent'] = undefined;





/**
 * Allowed values for the <code>state</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionDataRequest['StateEnum'] = {

    /**
     * value: "pending"
     * @const
     */
    "pending": "pending",

    /**
     * value: "completed"
     * @const
     */
    "completed": "completed"
};


/**
 * Allowed values for the <code>auth_type</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionDataRequest['AuthTypeEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "password"
     * @const
     */
    "password": "password",

    /**
     * value: "oauth"
     * @const
     */
    "oauth": "oauth",

    /**
     * value: "email_link"
     * @const
     */
    "email_link": "email_link",

    /**
     * value: "phone_number"
     * @const
     */
    "phone_number": "phone_number",

    /**
     * value: "ldap"
     * @const
     */
    "ldap": "ldap",

    /**
     * value: "saml"
     * @const
     */
    "saml": "saml"
};


/**
 * Allowed values for the <code>auth_second_factor_type</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionDataRequest['AuthSecondFactorTypeEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "phone_number"
     * @const
     */
    "phone_number": "phone_number",

    /**
     * value: "totp"
     * @const
     */
    "totp": "totp",

    /**
     * value: "mobile_push"
     * @const
     */
    "mobile_push": "mobile_push",

    /**
     * value: "security_key"
     * @const
     */
    "security_key": "security_key",

    /**
     * value: "fingerprint"
     * @const
     */
    "fingerprint": "fingerprint"
};



export default SubmissionDataRequest;

