/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SubmissionDataRequestEvent model module.
 * @module model/SubmissionDataRequestEvent
 * @version 2.0.0
 */
class SubmissionDataRequestEvent {
    /**
     * Constructs a new <code>SubmissionDataRequestEvent</code>.
     * @alias module:model/SubmissionDataRequestEvent
     * @param id {String} 
     * @param submissionId {String} 
     * @param submissionDataRequestId {String} 
     * @param eventType {module:model/SubmissionDataRequestEvent.EventTypeEnum} 
     * @param messageType {module:model/SubmissionDataRequestEvent.MessageTypeEnum} 
     * @param messageRecipient {String} 
     * @param occurredAt {String} 
     */
    constructor(id, submissionId, submissionDataRequestId, eventType, messageType, messageRecipient, occurredAt) { 
        
        SubmissionDataRequestEvent.initialize(this, id, submissionId, submissionDataRequestId, eventType, messageType, messageRecipient, occurredAt);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, id, submissionId, submissionDataRequestId, eventType, messageType, messageRecipient, occurredAt) { 
        obj['id'] = id;
        obj['submission_id'] = submissionId;
        obj['submission_data_request_id'] = submissionDataRequestId;
        obj['event_type'] = eventType;
        obj['message_type'] = messageType;
        obj['message_recipient'] = messageRecipient;
        obj['occurred_at'] = occurredAt;
    }

    /**
     * Constructs a <code>SubmissionDataRequestEvent</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SubmissionDataRequestEvent} obj Optional instance to populate.
     * @return {module:model/SubmissionDataRequestEvent} The populated <code>SubmissionDataRequestEvent</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SubmissionDataRequestEvent();

            if (data.hasOwnProperty('id')) {
                obj['id'] = ApiClient.convertToType(data['id'], 'String');
            }
            if (data.hasOwnProperty('submission_id')) {
                obj['submission_id'] = ApiClient.convertToType(data['submission_id'], 'String');
            }
            if (data.hasOwnProperty('submission_data_request_id')) {
                obj['submission_data_request_id'] = ApiClient.convertToType(data['submission_data_request_id'], 'String');
            }
            if (data.hasOwnProperty('event_type')) {
                obj['event_type'] = ApiClient.convertToType(data['event_type'], 'String');
            }
            if (data.hasOwnProperty('message_type')) {
                obj['message_type'] = ApiClient.convertToType(data['message_type'], 'String');
            }
            if (data.hasOwnProperty('message_recipient')) {
                obj['message_recipient'] = ApiClient.convertToType(data['message_recipient'], 'String');
            }
            if (data.hasOwnProperty('occurred_at')) {
                obj['occurred_at'] = ApiClient.convertToType(data['occurred_at'], 'String');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>SubmissionDataRequestEvent</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>SubmissionDataRequestEvent</code>.
     */
    static validateJSON(data) {
        // check to make sure all required properties are present in the JSON string
        for (const property of SubmissionDataRequestEvent.RequiredProperties) {
            if (!data.hasOwnProperty(property)) {
                throw new Error("The required field `" + property + "` is not found in the JSON data: " + JSON.stringify(data));
            }
        }
        // ensure the json data is a string
        if (data['id'] && !(typeof data['id'] === 'string' || data['id'] instanceof String)) {
            throw new Error("Expected the field `id` to be a primitive type in the JSON string but got " + data['id']);
        }
        // ensure the json data is a string
        if (data['submission_id'] && !(typeof data['submission_id'] === 'string' || data['submission_id'] instanceof String)) {
            throw new Error("Expected the field `submission_id` to be a primitive type in the JSON string but got " + data['submission_id']);
        }
        // ensure the json data is a string
        if (data['submission_data_request_id'] && !(typeof data['submission_data_request_id'] === 'string' || data['submission_data_request_id'] instanceof String)) {
            throw new Error("Expected the field `submission_data_request_id` to be a primitive type in the JSON string but got " + data['submission_data_request_id']);
        }
        // ensure the json data is a string
        if (data['event_type'] && !(typeof data['event_type'] === 'string' || data['event_type'] instanceof String)) {
            throw new Error("Expected the field `event_type` to be a primitive type in the JSON string but got " + data['event_type']);
        }
        // ensure the json data is a string
        if (data['message_type'] && !(typeof data['message_type'] === 'string' || data['message_type'] instanceof String)) {
            throw new Error("Expected the field `message_type` to be a primitive type in the JSON string but got " + data['message_type']);
        }
        // ensure the json data is a string
        if (data['message_recipient'] && !(typeof data['message_recipient'] === 'string' || data['message_recipient'] instanceof String)) {
            throw new Error("Expected the field `message_recipient` to be a primitive type in the JSON string but got " + data['message_recipient']);
        }
        // ensure the json data is a string
        if (data['occurred_at'] && !(typeof data['occurred_at'] === 'string' || data['occurred_at'] instanceof String)) {
            throw new Error("Expected the field `occurred_at` to be a primitive type in the JSON string but got " + data['occurred_at']);
        }

        return true;
    }


}

SubmissionDataRequestEvent.RequiredProperties = ["id", "submission_id", "submission_data_request_id", "event_type", "message_type", "message_recipient", "occurred_at"];

/**
 * @member {String} id
 */
SubmissionDataRequestEvent.prototype['id'] = undefined;

/**
 * @member {String} submission_id
 */
SubmissionDataRequestEvent.prototype['submission_id'] = undefined;

/**
 * @member {String} submission_data_request_id
 */
SubmissionDataRequestEvent.prototype['submission_data_request_id'] = undefined;

/**
 * @member {module:model/SubmissionDataRequestEvent.EventTypeEnum} event_type
 */
SubmissionDataRequestEvent.prototype['event_type'] = undefined;

/**
 * @member {module:model/SubmissionDataRequestEvent.MessageTypeEnum} message_type
 */
SubmissionDataRequestEvent.prototype['message_type'] = undefined;

/**
 * @member {String} message_recipient
 */
SubmissionDataRequestEvent.prototype['message_recipient'] = undefined;

/**
 * @member {String} occurred_at
 */
SubmissionDataRequestEvent.prototype['occurred_at'] = undefined;





/**
 * Allowed values for the <code>event_type</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionDataRequestEvent['EventTypeEnum'] = {

    /**
     * value: "send_request"
     * @const
     */
    "send_request": "send_request",

    /**
     * value: "view_request"
     * @const
     */
    "view_request": "view_request",

    /**
     * value: "accepted_terms"
     * @const
     */
    "accepted_terms": "accepted_terms",

    /**
     * value: "decline_request"
     * @const
     */
    "decline_request": "decline_request",

    /**
     * value: "sign_request"
     * @const
     */
    "sign_request": "sign_request",

    /**
     * value: "all_completed"
     * @const
     */
    "all_completed": "all_completed"
};


/**
 * Allowed values for the <code>message_type</code> property.
 * @enum {String}
 * @readonly
 */
SubmissionDataRequestEvent['MessageTypeEnum'] = {

    /**
     * value: "email"
     * @const
     */
    "email": "email",

    /**
     * value: "sms"
     * @const
     */
    "sms": "sms",

    /**
     * value: "fax"
     * @const
     */
    "fax": "fax",

    /**
     * value: "mail"
     * @const
     */
    "mail": "mail",

    /**
     * value: "slack"
     * @const
     */
    "slack": "slack",

    /**
     * value: "msteams"
     * @const
     */
    "msteams": "msteams",

    /**
     * value: "discord"
     * @const
     */
    "discord": "discord",

    /**
     * value: "telegram"
     * @const
     */
    "telegram": "telegram",

    /**
     * value: "whatsapp"
     * @const
     */
    "whatsapp": "whatsapp"
};



export default SubmissionDataRequestEvent;

