/**
 * DocSpring API
 * DocSpring provides an API that helps you fill out and sign PDF templates.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The UpdateSubmissionDataRequestData model module.
 * @module model/UpdateSubmissionDataRequestData
 * @version 2.0.0
 */
class UpdateSubmissionDataRequestData {
    /**
     * Constructs a new <code>UpdateSubmissionDataRequestData</code>.
     * @alias module:model/UpdateSubmissionDataRequestData
     */
    constructor() { 
        
        UpdateSubmissionDataRequestData.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>UpdateSubmissionDataRequestData</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/UpdateSubmissionDataRequestData} obj Optional instance to populate.
     * @return {module:model/UpdateSubmissionDataRequestData} The populated <code>UpdateSubmissionDataRequestData</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new UpdateSubmissionDataRequestData();

            if (data.hasOwnProperty('auth_type')) {
                obj['auth_type'] = ApiClient.convertToType(data['auth_type'], 'String');
            }
            if (data.hasOwnProperty('fields')) {
                obj['fields'] = ApiClient.convertToType(data['fields'], ['String']);
            }
            if (data.hasOwnProperty('metadata')) {
                obj['metadata'] = ApiClient.convertToType(data['metadata'], Object);
            }
            if (data.hasOwnProperty('order')) {
                obj['order'] = ApiClient.convertToType(data['order'], 'Number');
            }
        }
        return obj;
    }

    /**
     * Validates the JSON data with respect to <code>UpdateSubmissionDataRequestData</code>.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @return {boolean} to indicate whether the JSON data is valid with respect to <code>UpdateSubmissionDataRequestData</code>.
     */
    static validateJSON(data) {
        // ensure the json data is a string
        if (data['auth_type'] && !(typeof data['auth_type'] === 'string' || data['auth_type'] instanceof String)) {
            throw new Error("Expected the field `auth_type` to be a primitive type in the JSON string but got " + data['auth_type']);
        }
        // ensure the json data is an array
        if (!Array.isArray(data['fields'])) {
            throw new Error("Expected the field `fields` to be an array in the JSON data but got " + data['fields']);
        }

        return true;
    }


}



/**
 * @member {module:model/UpdateSubmissionDataRequestData.AuthTypeEnum} auth_type
 */
UpdateSubmissionDataRequestData.prototype['auth_type'] = undefined;

/**
 * @member {Array.<String>} fields
 */
UpdateSubmissionDataRequestData.prototype['fields'] = undefined;

/**
 * @member {Object} metadata
 */
UpdateSubmissionDataRequestData.prototype['metadata'] = undefined;

/**
 * @member {Number} order
 */
UpdateSubmissionDataRequestData.prototype['order'] = undefined;





/**
 * Allowed values for the <code>auth_type</code> property.
 * @enum {String}
 * @readonly
 */
UpdateSubmissionDataRequestData['AuthTypeEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "password"
     * @const
     */
    "password": "password",

    /**
     * value: "oauth"
     * @const
     */
    "oauth": "oauth",

    /**
     * value: "email_link"
     * @const
     */
    "email_link": "email_link",

    /**
     * value: "phone_number"
     * @const
     */
    "phone_number": "phone_number",

    /**
     * value: "ldap"
     * @const
     */
    "ldap": "ldap",

    /**
     * value: "saml"
     * @const
     */
    "saml": "saml"
};



export default UpdateSubmissionDataRequestData;

