/* ============================================================================
 * Copyright (c) 1997-1998 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. Every modification must be notified to the Java Apache Project
 *    and redistribution of the modified code without prior notification
 *    is NOT permitted in any form.
 *
 * 4. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Java Apache Project
 *    (http://java.apache.org/)."
 *
 * 5. The names "JServ", "JServ Servlet Engine" and "Java Apache Project"
 *    must not be used to endorse or promote products derived from this 
 *    software without prior written permission.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Java Apache Project
 *    (http://java.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Group. For more information 
 * on the Java Apache Project and the JServ Servlet Engine project, 
 * please see <http://java.apache.org/>.
 *
 */

package org.apache.jserv;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.java.io.*;

/**
 * ServletInputStream handles presenting the content-body to servlets.
 *
 * @author Alexei Kosut
 * @author Francis J. Lacoste
 * @author Stefano Mazzocchi
 * @author Ed Korthof
 * @version $Revision: 1.11 $ $Date: 1998/10/22 11:05:50 $
 **/
private class JServInputStream extends ServletInputStream {
    // bytes remaining to be read from the input stream. This is
    // initialized from CONTENT_LENGTH (or getContentLength()).
    // This is used in order to correctly return a -1 when all the
    // data POSTed was read.
    long available = -1;

    private InputStream in;

    public JServInputStream(InputStream in) {
        this.in = in;
        available = getContentLength();
    }

    public int read() throws IOException {
        if (available > 0) {
            available--;
            return in.read();
        }
        return -1;
    }

    public int read(byte b[]) throws IOException {
        return read(b, 0, b.length);
    }

    public int read(byte b[], int off, int len) throws IOException {
        if (available > 0) {
            if (len > available) {
                // shrink len
                len = (int) available;
            }
            int read = in.read(b, off, len);
            if (read != -1) {
                available -= read;
            } else {
                available = -1;
            }
            return read;
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        long skip = in.skip(n);
        available -= skip;
        return skip;
    }

    public void close() throws IOException {
        // Ignore closing of the input stream since it also
        // close the output stream.
        // conn.in.close();
    }
}

/**
 * ServletOutputStream implementation as inner class
 */
class JServOutputStream extends ServletOutputStream {
    private OutputStream out;

    public JServOutputStream(OutputStream out) {
        this.out = out;
    }
    
    public void write(int b) throws IOException {
        sendHttpHeaders();
        out.write(b);
    }
        
    public void write(byte b[], int off, int len) throws IOException {
        sendHttpHeaders();
        out.write(b, off, len);
    }
        
    public void flush() throws IOException {
        sendHttpHeaders();
        out.flush();
    }
    
    public void close() throws IOException {
        sendHttpHeaders();
        out.close();
    }
}
