::
:: Win32 build script for Java side
::
:: @author Stefano Mazzocchi <stefano@apache.org>
:: @version $Revision: 1.7 $ $Date: 1998/12/14 01:10:30 $
::

@echo off

:: WARNING: directories in different drives and names with spaces may cause
:: problems in this script. You may want to use short names here.

:: Set the JServ home directory
if "%jserv_home%"=="" set jserv_home=c:\jserv

:: Set the java compiler
if "%javac%"=="" set javac=javac

:: Set the jar flag to "false" to indicate you don't want to build a jar file
if "%jar%"=="" set jar=true

:: Set the java source directory (relative from this directory or absolute)
if "%java_src%"=="" set java_src=%jserv_home%\src\java

:: Set the java destination directory (relative from %java_src% or absolute)
if "%java_dest%"=="" set java_dest=%jserv_home%\bin\java

echo.
echo Compile Java distribution:
echo.

echo  * Checking source existance...
if not exist %java_src%\org\apache\jserv\JServ.java goto srcnotfound

echo  * Checking if destination directory exists and is readable...
echo temp > %java_dest%\temp.tmp
if not exist %java_dest%\temp.tmp goto destnotfound
del %java_dest%\temp.tmp > nul

echo  * Compiling using %javac%...

:javac
if not "%javac%"=="javac" goto jikes
:::::::: Use JavaSoft's Javac compiler (found in the Java Development Kit)
%javac% -O -J-Djavac.pipe.output=true -d %java_dest% -classpath %classpath%;%java_src% %java_src%\org\apache\jserv\JServ.java > make.java.error
:: NOTE: Javac has an undocumented feature that allow you to redirect its
::       output to STDOUT instead of using STDERR (its default stream).
::       This is done by setting the system property "javac.pipe.output" to 
::       "true".
if errorlevel 1 goto fatal
goto next

:jikes
if not "%javac%"=="jikes" goto other
:::::::: Use IBM Jikes compiler (http://www.alphaworks.ibm.com/formula/jikes)
if "%javac%"=="jikes" %javac% -O -depend -d %java_dest% -classpath %classpath%;%java_src% %java_src%\org\apache\jserv\JServ.java > make.java.error
:: NOTE: Jikes smartly uses STDOUT as default output stream
if errorlevel 1 goto fatal
goto next

:other
echo.
echo Don't know how to use %javac%
goto error

:next
del make.java.error > nul
if "%jar%"=="false" goto done
:: Stupid "jar" stores path information only from local directory (this changes in jdk1.2)
cd %java_dest%
echo  * Creating java archive ApacheJServ.jar...
jar cf0 ApacheJServ.jar .
if errorlevel 1 goto package
echo  * Removing java classes...
deltree /y %java_dest%\org > nul
goto done

:srcnotfound
echo.
echo The specified path does not contain the proper Java source.
echo Please, check the path %java_src% and try again.
goto error

:destnotfound
echo.
echo The specified destination path doesn't exist or it's readonly.
echo Please, check the path %java_dest% and try again.
goto error

:fatal
echo Sore error occurred during compilation.
echo See the file make.java.error for more information.
echo.
echo Make sure to have the Javasoft Java Servlet Development Kit 2.0 
echo visible at the Java compiler (place jsdk.jar into the classpath).
goto error

:package
del ApacheJServ.jar  > nul
echo Some error occurred during Jar packaging.

:error
goto end

:done
echo  * done.

:end

