::
:: Win32 build script for javadocs
::
:: @author Stefano Mazzocchi <stefano@apache.org>
:: @version $Revision: 1.5 $ $Date: 1998/12/03 20:09:27 $
::

@echo off

:: WARNING: directories in different drives and names with spaces may cause
:: problems in this script. Use may want to use short name here.

:: Set the JServ home directory
if "%jserv_home%"=="" set jserv_home=c:\jserv

:: Set the JServ java source directory
if "%java_src%"=="" set java_src=%jserv_home%\src\java

:: Set the JDK source file home directory
if "%jdk_src%"=="" set jdk_src=c:\java\jdk1.2\src

:: Set the java destination directory
if "%docs_dest%"=="" set docs_dest=%jserv_home%\docs\api

:: Set the javadoc tool
if "%javadoc%"=="" set javadoc=javadoc

:: Set the generation tool
if "%javadoc_ver%"=="" set javadoc_ver=jdk12

echo.
echo Generate javadoc documentation:
echo.

echo  * Checking source existance...
if not exist %java_src%\org\apache\jserv\JServ.java goto srcnotfound

echo  * Checking if destination directory exists and is readable...
echo temp > %docs_dest%\temp.tmp
if not exist %docs_dest%\temp.tmp goto destnotfound
del %docs_dest%\temp.tmp > nul

echo  * Generating using %javadoc% %javadoc_ver%...
if not "%javadoc%"=="javadoc" goto other
:::::::: Use JavaSoft's Javadoc version 1.1 (found in the Java Development Kit 1.1.x)
if "%javadoc_ver%"=="jdk11" %javadoc% -sourcepath %java_src%;%jdk_src% -d %docs_dest% -version -author -private org.apache.jserv org.apache.java.io org.apache.java.util org.apache.java.net org.apache.java.lang org.apache.java.security
:::::::: Use JavaSoft's Javadoc version 1.2beta4 (found in the Java Development Kit 1.2beta4)
if "%javadoc_ver%"=="jdk12beta4" %javadoc% -sourcepath %java_src%;%jdk_src% -d %docs_dest% -version -author -private -title "Java Apache Project APIs Specification" -footer "Copyright (c) 1998 The Java Apache Project" org.apache.jserv org.apache.java.io org.apache.java.util org.apache.java.net org.apache.java.lang org.apache.java.security
:::::::: Use JavaSoft's Javadoc version 1.2rc1 (found in the Java Development Kit 1.2rc1)
if "%javadoc_ver%"=="jdk12rc1" %javadoc% -sourcepath %java_src%;%jdk_src% -d %docs_dest% -version -author -private -doctitle "Java Apache Project APIs Specification" -footer "Copyright (c) 1998 The Java Apache Project" -group "Generic Apache Packages" "org.apache.java.*" -group "Apache JServ Packages" "org.apache.jserv.*" org.apache.jserv org.apache.java.io org.apache.java.util org.apache.java.net org.apache.java.lang org.apache.java.security
:::::::: Use JavaSoft's Javadoc version 1.2 (found in the Java Development Kit 1.2.x)
if "%javadoc_ver%"=="jdk12" %javadoc% -sourcepath %java_src%;%jdk_src% -d %docs_dest% -version -author -private -doctitle "Java Apache Project APIs Specification" -footer "Copyright (c) 1998 The Java Apache Project" -group "Generic Apache Packages" "org.apache.java.*" -group "Apache JServ Packages" "org.apache.jserv.*" org.apache.jserv org.apache.java.io org.apache.java.util org.apache.java.net org.apache.java.lang org.apache.java.security
goto done

:other
:: place here other javadoc tools (polardoc and others)

:notavailable
echo Sorry, don't know how to use %javadoc%.
goto error

:srcnotfound
echo.
echo The specified path does not contain the proper java source.
echo Please, check the path %java_src% and try again.
goto error

:destnotfound
echo.
echo The specified destination path doesn't exist or it's readonly.
echo Please, check the path %docs_dest% and try again.
goto error

:error
goto end

:done
echo  * done.

:end
