// ====================================================================
// Copyright (c) 1997,1998 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//
// This software consists of voluntary contributions made by many
// individuals on behalf of the Apache Group and was originally based
// on public domain software written at the National Center for
// Supercomputing Applications, University of Illinois, Urbana-Champaign.
// For more information on the Apache Group and the Apache HTTP server
// project, please see <http://www.apache.org/>.

// JServ - Serve up Java servlets
// by Alexei Kosut <akosut@apache.org>

// Parts are based on examples from  _Java in a Nutshell_ by David Flanagan:
// Written by David Flanagan.  Copyright (c) 1996 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

// JServContext.java:
// - org.apache.jserv.JServContext

package org.apache.jserv;

import java.io.CharArrayWriter;
import java.io.PrintWriter;

import java.util.Vector;
import java.util.Stack;
import java.util.Properties;
import java.util.Hashtable;
import java.util.Enumeration;

import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

/*
 * FIXME: Is there any good reason why ServletConfig and ServletContext
 * are implemented in the same class? <mbp@pharos.com.au>
 */

/**
 * This class implements the parts of the servlet that are longer-lived
 * than a single request, ServletConfig and ServletContext.
 *
 * <P>There is one <CODE>JServContext</CODE> object for each servlet,
 * and they are managed by <CODE>JServServletManager</CODE>.
 *
 * @author Alexei Kosut
 * @author Francis J. Lacoste
 **/
class JServContext implements ServletConfig, ServletContext, JServSendError {
    private JServServletManager servletMgr;

    // The servlet itself
    Servlet servlet;

    // Servlet metadata
    private Properties initargs;
    Stack log_messages;

    JServLock lock;

    // Constructor
    public JServContext(Servlet servlet, JServServletManager manager,
			Properties initargs) {
	this.servlet = servlet;

	this.servletMgr = manager;
	this.initargs = initargs;

	log_messages = new Stack();
	lock = new JServLock();
    }


    //----------------------------------------- Implementation of ServletConfig
    /**
     * Returns the context for the servlet.
     */
    public ServletContext getServletContext() {
	return this;
    }

    /**
     * Returns a string containing the value of the named
     * initialization parameter of the servlet, or null if the
     * parameter does not exist.  Init parameters have a single string
     * value; it is the responsibility of the servlet writer to
     * interpret the string.
     * @param name the name of the parameter whose value is requested.
     */
    public String getInitParameter(String name) {
	return initargs.getProperty(name);
    }

    /**
     * Returns the names of the servlet's initialization parameters
     * as an enumeration of strings, or an empty enumeration if there
     * are no initialization parameters.
     */
    public Enumeration getInitParameterNames() {
	return initargs.propertyNames();
    }

    //------------------------------------ Implementation of ServletContext
  
    /**
     * Returns the servlet of the specified name, or null if not
     * found.  When the servlet is returned it is initialized and
     * ready to accept service requests.
     * <p>
     * <i>Note:</i> This is a <b>dangerous</b> method to call for the
     * following reasons.
     * <p>
     * <UL><LI> When this method is called the state of the servlet may not
     *      be known, and this could cause problems with the server's
     *      servlet state machine.
     * <LI> It is a security risk to allow any servlet to be able to
     *      access the methods of another servlet.
     * </UL>
     * @param name the name of the desired servlet.
     * @excpeption if the servlet could not be initialized
     */
    public Servlet getServlet(String name) throws ServletException {
	JServContext s = servletMgr.loadServlet( name, this );
	return ( s != null ) ? s.servlet : null;
    }

    /**
     * Returns an enumeration of the Servlet objects in this server.
     * Only servlets that are accessible (i.e., from the same namespace)
     * will be returned.  The enumeration always includes the servlet
     * itself.
     * <p>
     * <i>Note:</i> This is a <b>dangerous</b> method to call for the
     * following reasons.
     * <p>
     * <UL><LI> When this method is called the state of the servlet may not
     *      be known, and this could cause problems with the server's
     *      servlet state machine.
     * <LI> It is a security risk to allow any servlet to be able to
     *      access the methods of another servlet.
     * </UL>
     * @see getServletNames
     * @see getServlet
     * @deprecated Please use getServletNames in conjunction with getServlet
     */
    public Enumeration getServlets() {
	return servletMgr.getLoadedServlets();
    }

    /**
     * Returns an enumeration of the Servlet object names in this server.
     * Only servlets that are accessible (i.e., from the same namespace)
     * will be returned.  The enumeration always includes the servlet
     * itself.
     * <p>
     * <i>Note:</i> This is a <b>dangerous</b> method to call for the
     * following reasons.
     * <p>
     * <UL><LI> When this method is called the state of the servlet may not
     *      be known, and this could cause problems with the server's
     *      servlet state machine.
     * <LI> It is a security risk to allow any servlet to be able to
     *      access the methods of another servlet.
     * </UL>
     */
    public Enumeration getServletNames() {
	return servletMgr.getServletNames();
    }

    /**
     * Writes the given message string to the servlet log file.
     * The name of the servlet log file is server specific; it
     * is normally an event log.
     * @param msg the message to be written
     */
    public void log(String msg) {
	synchronized(log_messages) {
	    log_messages.push(msg);
	}
    }

    /**
     * Applies alias rules to the specified virtual path and returns the
     * corresponding real path.  For example, in an HTTP servlet,
     * this method would resolve the path against the HTTP service's
     * docroot.  Returns null if virtual paths are not supported, or if the
     * translation could not be performed for any reason.
     * @param path the virtual path to be translated into a real path
     */
    public String getRealPath(String path) {
	// FIXME: See the note under JServConnection.getRealPath()
	// Until then, we return null for "not supported"
	return null;
    }

    /**
     * Returns the mime type of the specified file, or null if not known.
     * @param file name of the file whose mime type is required
     */
    public String getMimeType(String file) {
	// FIXME: See above. This should talk to Apache, do a subrequest
	// and return the content type. But we can't do that right now,
	// so we test a few common types, and return them. *sigh*

	if (file.endsWith(".html") || file.endsWith(".htm"))
	    return "text/html";
	if (file.endsWith(".txt"))
	    return "text/plain";
	if (file.endsWith(".gif"))
	    return "image/gif";
	if (file.endsWith(".jpg") || file.endsWith(".jpeg"))
	    return "image/jpeg";
	if (file.endsWith(".class"))
	    return "application/octet-stream";

	return null;
    }

    /**
     * Returns the name and version of the network service under which
     * the servlet is running. For example, if the network service was
     * an HTTP service, then this would be the same as the CGI variable 
     * SERVER_SOFTWARE.
     *
     */
    public String getServerInfo() {
	// This isn't quite SERVER_INFO, but I guess it's the
	// most direct 'server' to the servlet.
	return JServHandler.version;
    }

    /**
     * Returns the value of the named attribute of the network service,
     * or null if the attribute does not exist.  This method allows
     * access to additional information about the service, not already
     * provided by the other methods in this interface. Attribute names
     * should follow the same convention as package names.  The package
     * names java.* and javax.* are reserved for use by Javasoft, and
     * com.sun.* is reserved for use by Sun Microsystems.
     * @param name the name of the attribute whose value is required
     * @return the value of the attribute, or null if the attribute
     * does not exist.
     */
    public Object getAttribute(String name) {
	// We don't have any attributes for the network service
	return null;
    }

    //-------------------------------------- Implementation of JServSendError
    public void sendError(int sc, String msg) {
	log( JServConnection.findStatusString( sc ) + ": " + msg );
    }
    
    public void sendError(Throwable ex) {
	CharArrayWriter buf = new CharArrayWriter();
	PrintWriter writer = new PrintWriter( buf );
	ex.printStackTrace( writer );
	log( buf.toString() );
    }

}
