// ====================================================================
// Copyright (c) 1997, 1998 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//

/* SSIServlet
 * 
 * Servlet that supports server side includes servlets with the 
 * <servlet></servlet> style tag. It reads the outgoing .jhtml file
 * and tries to figure out the servlet to execute. Once found, it 
 * loads the servlet and execute it. 
 */

package org.apache.jserv;

import java.io.*;
import java.lang.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.jserv.*;

public class SSIServlet extends HttpServlet 
{
	/*constants*/
	static public final String START_DELIMITOR_UPPER = "<SERVLET";
	static public final String START_DELIMITOR_LOWER = "<servlet";
	static public final String STOP_DELIMITOR_UPPER = "</SERVLET>";
	static public final String STOP_DELIMITOR_LOWER = "</servlet>";

	static public final String PARAM_UPPER = "<PARAM";
	static public final String PARAM_LOWER = "<param";

	static public final String CODE_ATTRIBUTE_UPPER  = "CODE";
	static public final String CODE_ATTRIBUTE_LOWER  = "code";
	static public final String NAME_ATTRIBUTE_UPPER = "NAME";
	static public final String NAME_ATTRIBUTE_LOWER = "name";
	static public final String VALUE_ATTRIBUTE_UPPER = "VALUE";
	static public final String VALUE_ATTRIBUTE_LOWER = "value";

	static public final String TOKEN_DELIMITOR = " =";

	static public final char EQUALS = '=';
	static public final char SPACE = ' ';
	static public final char QUOTE = '"';
	static public final char CLOSER = '>';

	/*servlet attributes*/
	Hashtable servletAttributes = null;
	Hashtable originalParameters = null;

	public SSIServlet()
	{
		servletAttributes = new Hashtable(2);
		originalParameters = new Hashtable();
	}

	/*utility function to return a value for a specified key in */
	/*the form of key = value. Returns null if key's not found. */
	private String getValue(String currentLine, String key)
	{
		String value = null;
		String token;
		StringTokenizer tokenizedLine;

		try{
				/*see if current line contains key value*/
				if(currentLine.indexOf(key) == -1) 
				{
					return null;
				}

				tokenizedLine = new StringTokenizer(currentLine, TOKEN_DELIMITOR);
				while(tokenizedLine.hasMoreTokens())
				{
					token = tokenizedLine.nextToken();
					
					if(token.equals(key))
					{
						value = tokenizedLine.nextToken();
						/*get rid of un-needed garbage*/
						value = value.replace(CLOSER, SPACE);
						value = value.replace(QUOTE, SPACE);
						value = value.trim();
/*
System.out.println("Token = "+token+" ; Value = "+value);
*/
						return value;
					}

				}
		}
		catch(Exception e)
		{
			System.out.println("Caught "+e+" in getValue()");
		}

		/*if we get this far, something's wrong*/
		return value;
	}

	private void addParameter(String currentLine, JServConnection servletRequest)
	{
		String          name;
		String          value;
		String          orgValue; 

		try{
			name = getValue(currentLine, NAME_ATTRIBUTE_UPPER);
			if( name == null)
			{
				name = getValue(currentLine, NAME_ATTRIBUTE_LOWER);
			}
	
			value = getValue(currentLine, VALUE_ATTRIBUTE_UPPER);
			if( value == null)
			{
				value = getValue(currentLine, VALUE_ATTRIBUTE_LOWER);
			}
	
			if((name != null) && (value != null))
			{
				/*See if there's already a parameter by the same name*/
				/*Need this to load the original parameter hashtable */
				/* as the JServConnection does lazy parameter reading*/
				orgValue = servletRequest.getParameter(name);
				if(orgValue != null)
				{
					originalParameters.put(name, orgValue);
				}

/*
System.out.println("Name = "+name+" ; Value = "+value);
System.out.println("Old value of "+name+" = "+servletRequest.getParameter(name));
*/

				/*FIXME - should unset these parameters before */
				/*        invoking the next servlet on the page*/
				servletRequest.setParameter(name, value);
/*
System.out.println("New value of "+name+" = "+servletRequest.getParameter(name));
*/
			}
		}
		catch(Exception e)
		{
			System.out.println("Caught "+e+" in addParameter()");
		}
	}

	private void getServletAttributes(String currentLine)
	{
		String servletName;
		String className;

		try{
			servletName = getValue(currentLine, NAME_ATTRIBUTE_UPPER);
			if( servletName == null)
			{
				servletName = getValue(currentLine, NAME_ATTRIBUTE_LOWER);
			}
	
			className = getValue(currentLine, CODE_ATTRIBUTE_UPPER);
			if( className == null)
			{
				className = getValue(currentLine, CODE_ATTRIBUTE_LOWER);
			}

			if( servletName != null)
			{
				servletAttributes.put(NAME_ATTRIBUTE_LOWER, className);
			}
			else
			{
				System.out.println("No servlet name specified");
			}


			if( className != null)
			{
				servletAttributes.put(CODE_ATTRIBUTE_LOWER, className);
			}
			else
			{
				throw (new ServletException("No servlet class specified"));
			}
		}
		catch(Exception e)
		{
			System.out.println("Caught "+e+" in getServletAttribute()");
		}
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	{
		doGet(req, res);
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	{
		int			index;
		boolean isInsideTag = false;
		String docPath = null;
		String realDoc = null;
		String selfName = null;
		String lineText = null;
		String servletName = null;
		String servletClass = null;
		String token = null;
		StringTokenizer tokenLine = null;
		BufferedReader fis = null;
		ServletOutputStream out = null;

		try{
			out = res.getOutputStream();

			docPath = req.getRequestURI(); 
//out.println("Requested URI: "+docPath);
			selfName = this.getClass().getName(); 
//out.println("self name: "+selfName);
			index = docPath.indexOf(selfName); 
//out.println("self name index: "+index);
			docPath = docPath.substring(index+selfName.length()); 
//out.println("docPath: "+docPath);
			realDoc = req.getRealPath(docPath); 
//out.println("Real doc path: "+realDoc);

			fis = new BufferedReader(new FileReader(realDoc));

			res.setContentType("text/html");
			lineText = fis.readLine();
			while(lineText != null)
			{
				/*see if the current line has embedded applet tag*/
				if(lineText.indexOf(START_DELIMITOR_UPPER) != -1 ||
				   lineText.indexOf(START_DELIMITOR_LOWER) != -1) 
				{
					isInsideTag = true;

					getServletAttributes(lineText);
/*
System.out.println("Class name = "+servletAttributes.get("name")+" ; class file = "+servletAttributes.get("code"));
*/

				}
				else if(lineText.indexOf(STOP_DELIMITOR_UPPER) != -1
				  || lineText.indexOf(STOP_DELIMITOR_LOWER) != -1) 
				{
					/*now we're out of the <servlet> tag*/
					isInsideTag = false;

					/*try to run the servlet*/
					servletName = (String) servletAttributes.get(NAME_ATTRIBUTE_LOWER);
					servletClass = (String) servletAttributes.get(CODE_ATTRIBUTE_LOWER);

					/*now try to load the class*/
					if(servletClass.indexOf(".class") != -1)
					{
						servletClass = servletClass.substring(0,servletClass.lastIndexOf(".class"));
					}

//System.out.println("Loading class "+servletClass);
//TEST - begins
/*
Enumeration enum;
enum = req.getParameterNames();
while(enum.hasMoreElements())
{
	String param = (String)enum.nextElement();
	System.out.println("Parameter: "+param+" = "+req.getParameter(param));
}
*/
//TEST - ends
					HttpServlet runner = (HttpServlet) Class.forName(servletClass).newInstance();
//System.out.println("Loaded class "+runner.toString());
//System.out.println("Invoking servlet with "+req.toString()+" and "+res.toString());
//System.out.println("Type is: "+req.getParameter("type"));
					runner.service((ServletRequest)req, (ServletResponse)res);
//System.out.println("After invoking servlet object");

					/* so we dont' print the </servlet> tag*/
					lineText = " ";
				}
				/*if the servlet is running with parameters*/
				else if(lineText.indexOf(PARAM_UPPER) != -1
				  || lineText.indexOf(PARAM_LOWER) != -1) 
				{
					addParameter(lineText, (JServConnection)req);
/*
enum = req.getParameterNames();
System.out.println("Printing parameters after addParameter()");
while(enum.hasMoreElements())
{
	String param = (String)enum.nextElement();
	System.out.println("Parameter: "+param+" = "+req.getParameter(param));
}
*/
				}

				/*relay the HTML code unless we're inside the <servlet> tag*/
				if(!isInsideTag)
				{
					out.println(lineText);
				}

				/*read in the next line in the HTML file*/
				lineText = fis.readLine();
			}
		}
		catch(Exception e)
		{
			System.out.println("Caught "+e+" in SSIServlet.doGet()");
		}
		finally
		{
			try{
				fis.close();
				out.close();
			}
			catch(Exception e){System.out.println("Caught "+e+" in finally clause!");}
		}
	}
}
