dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl This file contains autoconf macros used by jukebox. -*-sh-*-
dnl 
dnl Copyright (C) 1997 Free Software Foundation, Inc.
dnl Copyright (C) 1999 Vadim Tkachenko <vt@freehold.crocodile.org> 
dnl 
dnl Authoritative source URL for this file is <http://freehold.crocodile.org/~vt/jukebox/acinclude.m4>

dnl These are the top-level macros provided:
dnl 
dnl AC_PATH_JDK		Finds the JDK or accepts the location argument
dnl AC_PROG_JAVATOOL	Finds the JDK tool or accepts the location argument
dnl AC_PATH_JAVACLASS	Finds the jar file or directory with the classes or
dnl			accepts the location argument
dnl
dnl Also, there are others, but I wouldn't recommend to use them just for
dnl consistency sake (VT).

dnl Find the 'false program, I'll need it as a substitute later
dnl Result goes in FALSE
AC_DEFUN(AC_PROG_FALSE,
[
AC_PATH_PROG(FALSE,false,$PATH)
])

dnl Find the JDK
dnl Results go in JDK_HOME
dnl Also sets JAVA_PLATFORM to 1 for 1.1 and to 2 for 1.2
dnl See also AC_WITH_PLATFORM

AC_DEFUN(AC_PATH_JDK,
[

    AC_MSG_CHECKING([for JDK location (please wait)])

    dnl The order is: --with-jdk first, environment second, guessed value third.
    
    dnl This is a safe default. Could screw up on the security features, but
    dnl oh well, this is what --with-java2 is for.
    
    JAVA_PLATFORM="1"

    AC_ARG_WITH(jdk-home,
    [  --with-jdk-home=DIR     Where is your JDK root directory.],
    [
    
        # This stuff works if the command line parameter --with-jdk-home was
        # specified, so it takes priority rightfully.
        
	JDK_HOME=${withval}
	
	if ${TEST} ! -d "${JDK_HOME}" ; then
	    AC_MSG_ERROR(Not a directory: ${JDK_HOME})
	fi
	
	AC_MSG_RESULT(${JDK_HOME})
	
    ],
    [
        # This works if the parameter was NOT specified, so it's a good time
        # to see what the enviroment says.
        
        # Since Sun uses JAVA_HOME a lot, we check it first and ignore the
        # JDK_HOME, otherwise just use whatever JDK_HOME was specified.
        
        if ${TEST} -n "${JAVA_HOME}" ; then
            
            JDK_HOME=${JAVA_HOME}
        fi
    ])

    if ${TEST} -z "${JDK_HOME}" ; then
    
        # Oh well, nobody set neither JAVA_HOME nor JDK_HOME, have to guess
        
        # The following code is based on the code submitted by Henner Zeller
        # for ${srcdir}/src/scripts/package/rpm/ApacheJServ.spec
        
        # Two variables will be set as a result:
        #
        # JDK_HOME
        # JAVA_PLATFORM
        
        
        for JDK_PREFIX in \
    	    /usr/local \
    	    /usr/local/lib \
    	    /usr \
    	    /usr/lib \
            /opt  \
    	    / 
        do
            for JAVA_PLATFORM in 3 2 1 ;
            do
            
                for subversion in .9 .8 .7 .6 .5 .4 .3 .2 .1 "" ;
                do
                    for VARIANT in java java- jdk jdk-;
                    do
                        GUESS="${JDK_PREFIX}/${VARIANT}1.${JAVA_PLATFORM}${subversion}"
dnl                        AC_MSG_CHECKING([${GUESS}])
                        
                        if ${TEST} -d "${GUESS}/bin" \
                        && ${TEST} -d "${GUESS}/include" ; then
                        
                            JDK_HOME="${GUESS}"
                            AC_MSG_RESULT([${GUESS}])
                            break
                        fi

                    done

                    if ${TEST} -n "${JDK_HOME}" ; then
                        break;
                    fi

                done

                if ${TEST} -n "${JDK_HOME}" ; then
                    break;
                fi

            done

            if ${TEST} -n "${JDK_HOME}" ; then
                break;
            fi

        done
        
        if ${TEST} -n "${JDK_HOME}" ; then
        
            dnl Just to have the messages looking uniformly
            
            AC_MSG_CHECKING(Java platform)
            AC_MSG_RESULT([guess ${JAVA_PLATFORM}])
        fi
        
    else
    
        AC_MSG_CHECKING(Java platform)

        AC_ARG_WITH(java-platform,
        [  --with-java-platform=VAL Force the Java platorm
                          (value is 1 for 1.1.x or 2 for 1.2.x or greater)],
        [
            dnl This requires a bit of tweaking to be handled properly, but
            dnl the default is good enough
            
            JAVA_PLATFORM="2"
        ])

        AC_MSG_RESULT(forced Java ${JAVA_PLATFORM})

    fi

if ${TEST} -z "${JDK_HOME}" ; then

    AC_MSG_ERROR([JDK home not found, please specify one with --with-jdk-home option (run ./configure --help for more options)])
fi

AC_SUBST(JDK_HOME)
AC_PROVIDE([$0])
])

dnl Find the  rmic program (so far useful only for EJBoss
dnl (http://www.ejboss.org/), but preserved because doesn't break anything and
dnl allows this file to be reused for Jserv, ECS, Jukebox and EJBoss.
dnl 
dnl I guess I'd work on this one later. I don't like it, it's not generic (VT).

dnl Result goes in RMIC (bare location) and RMICX (with classpath and flag
dnl adjustments)

dnl The order is: --with-rmic first, environment second, guessed value third.

AC_DEFUN(AC_PROG_RMIC,
[
    AC_REQUIRE([AC_PATH_JDK])
    AC_REQUIRE([AC_PROG_FALSE])
    AC_MSG_CHECKING(rmic binary)

    AC_ARG_WITH(rmic,
    [  --with-rmic=prog        Java RMI compiler you want to use, if not the one from JDK],
    [
        if ${TEST} "$withval" = "yes" || ${TEST} "$withval" = "no" ; then
            AC_MSG_ERROR(You must specify the rmic binary as the parameter for --with-rmic)
        fi
        
        if ${TEST} ! -x "$withval" ; then
            AC_MSG_ERROR(Bad value for --with-rmic: $withval)
        fi
    ],
    [
        RMIC="${JDK_HOME}/bin/rmic"
        if ${TEST} ! -x "${RMIC}" ; then
            AC_MSG_ERROR(rmic binary not found in ${JDK_HOME})
        fi
    ])
    
    AC_MSG_RESULT(${RMIC})
    AC_SUBST(RMIC)
    AC_PROVIDE([$0])

    if ${TEST} "${JAVA_PLATFORM}" = "2" ; then
    	RMICX="${RMIC} -classpath \${TARGET_CLASSPATH}:${JDK_HOME}/jre/lib/rt.jar"
    else
    	RMICX="CLASSPATH=\${CLASSPATH}:\${TARGET_CLASSPATH}:${JDK_HOME}/lib/classes.zip ${RMIC}"
    fi

    AC_SUBST(RMICX)
])

dnl Locate the Java tool within a JDK tree or by --with-* option.

dnl First parameter is the name of the variable it goes to
dnl Second parameter is the name of the binary to look up
dnl Third parameter is the --help message (pay attention to alignment)
dnl If the forth parameter is present and the binary is not found, just
dnl substitute it with $FALSE and display a warning message instead of bailing
dnl out.

dnl Results go to $1 (bare location) and $1X (with classpath and flag
dnl adjustments).

AC_DEFUN(AC_PROG_JAVATOOL,
[
    AC_REQUIRE([AC_PATH_JDK])
    AC_REQUIRE([AC_PROG_FALSE])
    AC_MSG_CHECKING($2)

    AC_ARG_WITH($2,
    [  --with-$2=prog    $3 you want to use],
    [
        if ${TEST} "$withval" = "yes" || ${TEST} "$withval" = "no" ; then
            AC_MSG_ERROR([You must specify the $2 binary as the parameter for --with-$2])
        fi
        
        if ${TEST} ! -x "$withval" ; then
            AC_MSG_ERROR([Bad value for --with-$2: $withval])
        fi
        $1="${withval}"
        
        if ${TEST} -n "`${ECHO} ${withval}|${GREP} -i /jikes`" ; then
            JIKES="true"
        else
            JIKES="false"
        fi

    ],
    [
        $1="${JDK_HOME}/bin/$2"
        if ${TEST} ! -x "${$1}" ; then
            if ${TEST} -n "$4" ; then
                AC_MSG_WARN($4)
                $1=${FALSE}
            else
                AC_MSG_ERROR([$2 binary not found in ${JDK_HOME}])
            fi
        fi
    ])
    
    AC_MSG_RESULT(${$1})
    AC_SUBST($1)
    
    AC_PROVIDE($1)
    
    dnl VT: This ugly bypass is here because autoconf complains about its
    dnl bug. In the future, I'll be checking it once in a while
    

    OPTION=$1
    OPTION="${OPTION}_OPT"

    if ${TEST} "${JAVA_PLATFORM}" = "2" && ${TEST} "${JIKES}" = "false" ; then
    	$1X="${$1} \${$OPTION} -classpath \${TARGET_CLASSPATH}"
    else
        if ${TEST} -z "${TCSETA}" && ${TEST} -r "${JDK_HOME}/lib/classes.zip" ; then
            TARGET_CLASSPATH="$TARGET_CLASSPATH:${JDK_HOME}/lib/classes.zip"
            TCSETA="true"            
        fi
        
        dnl Why 'or'? And! On the other hand, I don't remember whether there
        dnl is an rt.jar in 1.1...
        
        if ${TEST} -z "${TCSETB}" && ${TEST} -r "${JDK_HOME}/jre/lib/rt.jar" ; then
            TARGET_CLASSPATH="$TARGET_CLASSPATH:${JDK_HOME}/jre/lib/rt.jar"
            TCSETB="true"
        fi
        
        $1X="CLASSPATH=\${CLASSPATH}:\${TARGET_CLASSPATH} ${$1} \${$OPTION}"
    fi
    
    AC_SUBST($1X)
])

dnl Find the Java class set.

dnl The first parameter is the name of the variable it goes to
dnl The second parameter is a guessed location basename
dnl The third parameter defines a name of the class that has to be present
dnl in the target entity
dnl The forth parameter is a --help message
dnl If the fifth parameter is not empty, this package is optional.
dnl The output goes into $1_CLASSES

dnl FIXME: Look for the signature class in the ${CLASSPATH}

AC_DEFUN(AC_PATH_JAVACLASS,
[
    AC_MSG_CHECKING($1)
    
    dnl Find out if we have a parameter
    
    AC_ARG_WITH($1,
    [  --with-$1=DIR/JAR $4],
    [
        $1_CLASSES=$withval
    ],
    [
        dnl Guess
        
        $1_CLASSES="/usr/local/$2"
    ])
    
    dnl Find out if it exists at all

    if ${TEST} ! -e "${$1_CLASSES}" ; then
        if ${TEST} -z "$5" ; then
            AC_MSG_ERROR(Does not exist: '${$1_CLASSES}')
        else
            AC_MSG_RESULT(not found in ${$1_CLASSES})
        fi
    else

        dnl Transform the class name into the path name
        
        CLASS="`echo $3|${TR} "." "/"`.class"
        
        dnl Find out what it is
        
        if ${TEST} -d "${$1_CLASSES}" ; then
        
            dnl OK, so this is a directory.
            
            AC_PATH_SEARCHCLASS($1,${$1_CLASSES},${CLASS})
            
            if ${TEST} -z "${$1}" ; then

                AC_PATH_SEARCHJAR($1,${$1_CLASSES},${CLASS})
                
                if ${TEST} -z "${$1}" ; then
                    if ${TEST} -z "$5" ; then
                        AC_MSG_ERROR([no $3 class or jar with it in ${$1_CLASSES}])
                    else
                        AC_MSG_RESULT(not found)
                    fi
                fi
            fi
        else
            
            AC_PATH_VERIFYJAR($1,${$1_CLASSES},${CLASS})
            
            if ${TEST} -z "${$1}" ; then
                AC_MSG_ERROR([$3 not found in ${$1_CLASSES}])
            fi
        fi
    fi
    
    $1_CLASSES=${$1}
    
    if ${TEST} -n "${$1_CLASSES}" ; then
        AC_MSG_RESULT([${$1_CLASSES}])
    fi
    AC_SUBST($1_CLASSES)
    AC_PROVIDE($1_CLASSES)
    
    dnl It appears that it's not possible to use the substitution in AM_CONDITIONAL,
    dnl so by now it's required to use it in configure.in, unfortunately.
    
    dnl AM_CONDITIONAL($1,${TEST} -n "${$1_CLASSES}")
])

dnl This one verifies if the $3 class exists in the $2 jar file and places
dnl the $2 in $1 if it is, otherwise sets it to empty string.
 
AC_DEFUN(AC_PATH_VERIFYJAR,
[
    if ${TEST} -z "${JAR}" ; then
    
        dnl This happens when you try to call AC_PATH_VERIFYJAR *before* defining JAR.
        dnl Modify your configure.in to include AC_PATH_JAVATOOL(JAR) above the invocation of,
        dnl most likely, AC_PATH_JAVACLASS.
        
        AC_MSG_ERROR([Find this string in acinclude.m4 and read the comments])
    fi
    
    dnl You may want to call it before, just to make the output look good
    
    $1=`${JAR} -tvf $2 2>&1|${GREP} $3`
    
    if ${TEST} -n "${$1}" ; then
    	$1=$2
    else
        $1=""
    fi
    AC_SUBST($1)
])

dnl Find a $3 class file in the $2 directory.
dnl If the directory is a classpath root, return it in $1.
dnl If it is not, but the class is there, bail out.
dnl If it doesn't contain the class file at all, return the empty string.

# IMPORTANT: Don't replace 'cd' with '${CD}. Reason: at least on Solaris, it
# breaks the behavior by treating ${CD} as an executable program, and
# consequently RETURNING TO THE CURRENT DIRECTORY after ${CD} is executed.

AC_DEFUN(AC_PATH_SEARCHCLASS,
[
    PRESENT=`(cd $2 && ${FIND} . -name "*.class"|${GREP} "$3"|${CUT} -c 3-)`
    
    if ${TEST} -n "${PRESENT}" ; then
    
        PRESENT=`echo ${PRESENT}|${GREP} -x "${CLASS}"`
        
        if ${TEST} -z "${PRESENT}" ; then

            dnl OK, here's a misajustment - let's try to fix it later by
            dnl calculating the length difference, so far - error
            
            AC_MSG_ERROR([$2 is not a classpath root for $3 - adjust it])
        else
            $1=$2
        fi
    fi
    
    AC_SUBST($1)
])

dnl Find all the jar and zip files below $2 and check them for $3 class until found.
dnl Bail out if there's no file in there.
dnl If the jar/zip is found, return it in $1.

dnl (VT: looks like AC_PATH_VERIFYJAR, may be just use it?)

AC_DEFUN(AC_PATH_SEARCHJAR,
[
    JARS=`${FIND} $2 -name "*.jar" -or -name "*.zip"|tr "\n" " "`

    if ${TEST} -n "$JARS" ; then
        for JARFILE in ${JARS} ; do
dnl            AC_MSG_CHECKING('$JARFILE' for $3)
            PRESENT=`${JAR} -tf ${JARFILE} 2>&1|${GREP} $3`
            
dnl            AC_MSG_RESULT(Got '${PRESENT}')
            
            if ${TEST} -n "${PRESENT}" ; then
                $1=${JARFILE}
                AC_SUBST($1)
                break
            fi
        done
    fi
])

dnl This one displays one-line summary on the optional jar/class component,
dnl if the correspondend environment variable is set.
dnl
dnl First parameter is the environment variable name, without _CLASSES appended.

AC_DEFUN(AC_REPORT_OPTIONAL, [

    if ${TEST} -n "${$1_CLASSES}" ; then
        AC_MSG_RESULT($1 (optional) used: ${$1_CLASSES})
    else
        AC_MSG_RESULT($1: (optional) not used)
    fi
])

AC_DEFUN(AC_PATH_EXTRA,
[
    if ${TEST} -n "${$1_CLASSES}" ; then
        TARGET_CLASSPATH="${TARGET_CLASSPATH}:${$1_CLASSES}"
    fi
])

AC_DEFUN(CHECK_GNU_MAKE,[ 
    AC_CACHE_CHECK([for GNU make], _cv_gnu_make_command, [ 
       ifGNUmake='#' ; 
       _cv_gnu_make_command='' ; 
       if ${TEST} -x ${MAKE} ; then
           if ( ${MAKE} --version 2> /dev/null | ${GREP} GNU ) ; then 
               _cv_gnu_make_command=${MAKE} ; 
               ifGNUmake='' ; 
           fi
       fi
       if ${TEST} -n "${ifGNUmake}" ; then
          AC_MSG_ERROR([GNU make was not found, please install it first])
       fi
    ]) 
]) 

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])


# serial 40 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" \
LN_S="$LN_S" NM="$NM" RANLIB="$RANLIB" \
DLLTOOL="$DLLTOOL" AS="$AS" OBJDUMP="$OBJDUMP" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $host \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

# Check for any special flags to pass to ltconfig.
libtool_flags="--cache-file=$cache_file"
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
ifdef([AC_PROVIDE_AC_LIBTOOL_DLOPEN],
[libtool_flags="$libtool_flags --enable-dlopen"])
ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[libtool_flags="$libtool_flags --enable-win32-dll"])
AC_ARG_ENABLE(libtool-lock,
  [  --disable-libtool-lock  avoid locking (might break parallel builds)])
test "x$enable_libtool_lock" = xno && libtool_flags="$libtool_flags --disable-lock"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$host" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

ifdef([AC_PROVIDE_AC_LIBTOOL_WIN32_DLL],
[*-*-cygwin* | *-*-mingw*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  AC_CHECK_TOOL(OBJDUMP, objdump, false)
  ;;
])
esac
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])])

# AC_LIBTOOL_WIN32_DLL - declare package support for building win32 dll's
AC_DEFUN(AC_LIBTOOL_WIN32_DLL, [AC_BEFORE([$0], [AC_LIBTOOL_SETUP])])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED, [dnl
define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC, [dnl
define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL, [dnl
define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
AC_ENABLE_FAST_INSTALL(no)])

# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_SUBST(LD)
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
AC_SUBST(NM)
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$host" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library, adds --enable-ltdl-convenience to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdlc.la
  INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library, and adds --enable-ltdl-install to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [AC_BEFORE([$0],[AC_LIBTOOL_SETUP])dnl
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdl.la
    INCLTDL=ifelse($#,1,-I$1,['-I${top_builddir}/libltdl'])
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
    INCLTDL=
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

dnl This is just to silence aclocal about the macro not being used
ifelse([AC_DISABLE_FAST_INSTALL])dnl

