/* ====================================================================
 * Copyright (c) 1998 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

/*
 * EnvDumpServlet - dump the servlet environment to the output
 * by Ian Kluft - January 1998
 */

package org.apache.jserv;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class EnvDumpServlet extends HttpServlet {
	/**
	*	doGet()
	*
	*	@exception ServletException If a ServletException occurred
	*
	*/
    public void doGet (HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
    {
	res.setContentType("text/html");

	PrintWriter out = new PrintWriter(res.getOutputStream());

	// HTML header
	out.println("<html>");
	out.println("<head>");
	out.println("<title>Servlet Environment Dump</title>");
	out.println("</head>");
	out.println("<body bgcolor=\"#ffffff\">");
	out.println("<h1>Servlet Environment Dump</h1>");

	// print headers
	Enumeration headers = req.getHeaderNames();
	out.println("<b>Headers</b>");
	out.println("available via HttpServletRequest.getHeader()");
	out.println("<br>");
	while ( headers.hasMoreElements()) {
	    String hdr = headers.nextElement().toString();
	    out.println( hdr + " = " + req.getHeader(hdr));
	    out.println("<br>");
	}

	// print attributes
	String prefix = "org.apache.jserv.";
	Object attrsObj = req.getAttribute("org.apache.jserv.attribute_names");
	if ( attrsObj != null && attrsObj instanceof Enumeration ) {
	    Enumeration attrs = (Enumeration) attrsObj;
	    out.println("<p>");
	    out.println("<b>Attributes</b>");
	    out.println("available via HttpServletRequest.getAttribute()");
	    out.println("<br>");
	    while ( attrs.hasMoreElements()) {
	        String attr = attrs.nextElement().toString();
		if ( req.getAttribute(prefix + attr) != null ) {
	            out.println( prefix + attr + " = " +
			req.getAttribute(prefix + attr).toString());
		} else {
	            out.println( prefix + attr + " = NULL " );
		}
	        out.println("<br>");
	    }
	}

	// HTML trailer
	out.println("</body>");
	out.println("</html>");
	out.close();
    }
}
