// ====================================================================
// Copyright (c) 1997, 1998 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//
// This software consists of voluntary contributions made by many
// individuals on behalf of the Apache Group and was originally based
// on public domain software written at the National Center for
// Supercomputing Applications, University of Illinois, Urbana-Champaign.
// For more information on the Apache Group and the Apache HTTP server
// project, please see <http://www.apache.org/>.

// JServ - Serve up Java servlets
// by Alexei Kosut <akosut@apache.org>

// Parts are based on examples from  _Java in a Nutshell_ by David Flanagan:
// Written by David Flanagan.  Copyright (c) 1996 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

// JServClassLoader.java:
// - org.apache.jserv.test.ClassLoaderTest

package org.apache.jserv.test;

import org.apache.jserv.JServClassLoader;
import org.apache.jserv.JServDebug;

import java.io.File;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;

/**
 * Simple program to test the JServClassLoader. The
 * CLASSPATH should contains at least the JDK, the
 * JSDK and the JServ classes.
 * 
 * <P>It expects as first parameter the directory
 * or file that serves as class repository.
 */
public class ClassLoaderTest implements JServDebug.DebugConstants {

    protected File repository;
    protected JServClassLoader loader;
    /**
     * The program. It creates a instance of the loader
     * and loads class specified on stdin until it
     * encounters \quit
     */
    ClassLoaderTest(File rep) {
	this.repository = rep;
	this.loader = new JServClassLoader(repository);
	JServDebug.setTracing( CLASSLOADER, true );
	loadClasses();
    } 

    private void loadClasses() {
	BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

	try {
	    while (true) {
		boolean doClass = true;		//By default load class.

		System.out.print("Class name (begin with \"r:\" to try resource: ");
		System.out.flush();
		String classname = in.readLine();
		if     (classname.equals("\\quit")) {
		    return;
		}
		else if (classname.startsWith("r:")) {
		    doClass = false;
		    classname = classname.substring(2);
		}

		if (doClass) {
		    //Verify if reloading is necessary
		    if (loader.shouldReload(classname)) {
			System.out.println("Reinstanciating ClassLoader.");
			loader = loader.reinstantiate();
			JServDebug.setTracing( CLASSLOADER, true );
		    }
		    try {
			Class c = loader.loadClass(classname);
		    } catch(Throwable t) {
			System.out.print("Caught " + t.getClass().getName() +
					 " while loading " + classname + "\n");
			t.printStackTrace();
		    }
		}
		else {
		    try {
			//Load resource
			InputStream r = loader.getResourceAsStream(classname);
			if (r == null) {
			    System.out.println("Resource " + classname + " wasn't found.");
			}
			else {
			    System.out.println("Resource " + classname + " was found.");
			}
		    }
		    catch(Throwable t) {
			System.out.println("Caught " + t.getClass().getName() +
					   "while loading resource " + classname);
		    }
		}
	    }
	}
	catch(IOException ioe) {
	    ioe.printStackTrace();
	}
    }

    /**
     * The driver. 
     */
    public static void main(String[]args) {
	if (args.length != 1) {
	    usage();
	    return;
	} new ClassLoaderTest(new File(args[0]));
    }

    private static void usage() {
	System.out.println("Usage: java org.apache.jserv.test.ClassLoaderTest rep");
	System.out.println("Where rep is a zip file or directory.");
	System.exit(1);
    }
}

