// ====================================================================
// Copyright (c) 1997, 1998 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//
// This software consists of voluntary contributions made by many
// individuals on behalf of the Apache Group and was originally based
// on public domain software written at the National Center for
// Supercomputing Applications, University of Illinois, Urbana-Champaign.
// For more information on the Apache Group and the Apache HTTP server
// project, please see <http://www.apache.org/>.

// JServ - Serve up Java servlets
// by Alexei Kosut <akosut@apache.org>

// Parts are based on examples from  _Java in a Nutshell_ by David Flanagan:
// Written by David Flanagan.  Copyright (c) 1996 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

// ServletMonitor.java:
// - org.apache.jserv.test.ServletMonitor

package org.apache.jserv.test;

import java.util.Enumeration;

import java.io.IOException;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlets that list the servlets in this virtual host
 * and their init parameters.
 *
 * @author Francis J. Lacoste
 * @version $Revision: 1.5 $
 */
public class ServletMonitor extends HttpServlet {

    public String getServletInfo() {
	return "ServletMonitor $Revision: 1.5 $.\nDisplay informations about " +
	    "the servlets available in a virtual host.";
    }

    /**	
    * Service the request.
 	*
 	* @exception ServletException If a ServletException occurred
	*
	*/
    public void service(HttpServletRequest request,
			HttpServletResponse response)
	 throws IOException, ServletException
    {

	response.setContentType("text/html");

	ServletOutputStream out = response.getOutputStream();
	out.println("<HTML>");
	out.println("<HEAD><TITLE>Servlet Monitor</TITLE></HEAD>");
	out.println("<BODY>");

	out.println("<H1>List of servlet in the host " +
		    request.getHeader   ("Host") + "</H1>");

	Enumeration servlets = getServletContext().getServletNames();
	while (servlets.hasMoreElements()) {
	    String servletName = (String)servlets.nextElement();
	    out.println("<H2>" + servletName + "</H2>");

	    Servlet servlet = getServletContext().getServlet( servletName );
	    ServletConfig config = servlet.getServletConfig();

	    out.println("<PRE>");
	    out.println( "Class: " + servlet.getClass().toString() );
	    out.println("Servlet info: " +
			(servlet.getServletInfo() == null ?
			 "???" : servlet.getServletInfo())
			);

	    out.println("");
	    Enumeration params = config.getInitParameterNames();
	    if ( params.hasMoreElements() ) {
		out.println("Initialization parameters:");
		out.println("");

		while (params.hasMoreElements()) {
		    String name = (String) params.nextElement();
		    String value = config.getInitParameter(name);
		    out.println(name + ": " + value);
		} out. println("");
	    } out.  println("</PRE>");
	}
	out.println("</BODY>");
	out.println("</HTML>");

    }

}
