// ====================================================================
// Copyright (c) 1997 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//
// This software consists of voluntary contributions made by many
// individuals on behalf of the Apache Group and was originally based
// on public domain software written at the National Center for
// Supercomputing Applications, University of Illinois, Urbana-Champaign.
// For more information on the Apache Group and the Apache HTTP server
// project, please see <http://www.apache.org/>.

// JServ - Serve up Java servlets
// by Alexei Kosut <akosut@apache.org>

// Parts are based on examples from  _Java in a Nutshell_ by David Flanagan:
// Written by David Flanagan.  Copyright (c) 1996 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

// JServSignals.java:
// - apache.jserv.JServSignals

package apache.jserv;

import java.io.*;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

// This class does all the JServ signal-handling stuff. It reads from
// System.in, and looks for lf-terminated lines that look like "S%d\n",
// where %d is the number of the signal.

class JServSignals extends Thread implements JServSendError {
    private static final int SIGHUP = 1;
    private static final int SIGTERM = 15;

    Hashtable servlets;
    Properties properties;

    // Constructor - starts the thread
    
    protected JServSignals(Hashtable servlets, Properties properties) {
	this.servlets = servlets;
	this.properties = properties;

	setDaemon(true);
	start();
    }

    // This thread just waits for something to appear on in.
    public void run() {
	String line;
	byte sig[] = new byte[3];
	
	try {
	    for (;;) {
		try {
		    while (System.in.available() == 0) sleep(100);
		} catch (InterruptedException e) {}

		if (System.in.read(sig, 0, 3) < 3)
		    break;

		line = new String(sig);

		if (line.equals("S01"))
		    restartServlets();	// SIGHUP
		else if (line.equals("S15"))
		    destroyServlets();	// SIGTERM

	    }
	} catch (IOException e) {}

	// We reached eof (null) or got an IO exception. Either way,
	// something happened to our parent. Maybe it got killed.
	// We should get killed, too.
	//
	// It's okay, though. If it's an accident, mod_jserv will
	// notice that we've died, and will reactivate us.

	destroyServlets();
    }

    // This method will be called when a SIGTERM is caught.
    private void destroyServlets() {
	// Destroy all the servlets and exit
	clearServlets();
	System.exit(0);
    }

    // This method will be called when a SIGHUP is caught.
    private void restartServlets() {
	// Clear the servlets
	clearServlets();
	// Restart the startup servlets
	JServHandler.loadStartupServlets(servlets, properties, this);
    }

    // This clears the servlets
    private void clearServlets() {
	synchronized(servlets) {
	    // Call all the servlet destory methods
	    for (Enumeration e = servlets.elements(); e.hasMoreElements();) {
		// We should get a writer lock on this (accessing the servlet
		// via HTTP is a reader lock). i.e., we wait for all
		// requests to finish. Right now, we don't.
		JServContext context = (JServContext)(e.nextElement());

		context.lock.writeLock();
		context.servlet.destroy();
		context.lock.writeUnlock();
	    }
	    
	    // Unlink and reset the servlet list
	    servlets.clear();
	}
    }

    // If we get an error while loading an init servlet, ignore it.
    // Nothing we can do now if it wants to fail.
    public void sendError(int sc, String msg) {}
}
