/*
 * Copyright (C) 1997 Pharos IP Pty Ltd
 * Confidential.  All rights reserved.
 * $Id: LoadClassTest.java,v 1.5 1998/01/20 07:17:03 jonbolt Exp $
 */

package org.apache.jserv.test;

import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * This servlet checks that classes loaded by name operate correctly
 * under the <CODE>mod_jserv</CODE> classloader.
 *
 * @author Martin Pool
 * @version $Revision: 1.5 $
 **/
public class LoadClassTest extends HttpServlet
{
   /**
    *
    * @exception  ServletException if there is any sort of Exception
    *
    **/
    public void doGet(HttpServletRequest req,
		      HttpServletResponse res)
	 throws ServletException
    {
	try {
	    String myName = this.getClass().getName();
	    Object o = Class.forName(myName).newInstance();
	    res.setContentType("text/plain");
	    res.getOutputStream().println("Object created OK");
	}
	catch (Exception e) {
	    e.printStackTrace();
	    throw new ServletException(e.toString());
	}
    }
}
