dnl This file contains autoconf macros used by jogl. -*-sh-*-
dnl 
dnl Copyright (C) 1997 Free Software Foundation, Inc.
dnl 
dnl These are the macros provided:
dnl 
dnl AC_PATH_JDK
dnl AC_PROG_JAVAC
dnl AC_PROG_JAVA

dnl Find the JDK
dnl Results go in JDK_HOME
dnl Also sets JAVA_PLATFORM
AC_DEFUN(AC_PATH_JDK,
[
jdk_specified=false

AC_ARG_WITH(jdk-home,
[  --with-jdk-home=DIR     Where your java header files are if not 
                          located in a JDK like structure.],
[
	JDK_HOME=${withval}
	jdk_specified=true
])

if test ! x$JAVA_HOME = x && test x$JDK_HOME = x; then
    JDK_HOME=${JAVA_HOME}
    jdk_specified=true
fi

if test ! x$JDK_HOME = x; then
    jdk_specified=true
fi

# try to find it if not specified
if test x$JDK_HOME = x; then
    for i in \
	/ \
	/usr \
	/usr/local \
	/usr/lib \
	/usr/local/lib 
    do
	for j in \
	    jdk1.1.7 \
	    jdk1.1.6 \
	    jdk1.1.5 \
	    jdk1.1.4 \
	    jdk1.1.3 \
	    jdk1.1.2 \
	    jdk1.1.1 \
	    jdk1.1 
	do
	    if test -d "${i}/${j}/bin" && test -d "${i}/${j}/include"; then
		JDK_HOME="${i}/${j}"
	    fi
	done
    done
fi

if test ! x${JDK_HOME} = x; then
    if test -r "${JDK_HOME}/lib/classes.zip"; then
	JDK_CLASSES="${JDK_HOME}/lib/classes.zip"
    fi
fi

AC_SUBST(JDK_HOME)
AC_SUBST(JDK_CLASSES)

])

dnl Find the java program
dnl Result goes in JAVA
AC_DEFUN(AC_PROG_JAVA,
[
AC_REQUIRE([AC_PATH_JDK])

AC_ARG_WITH(java,
[  --with-java=DIR        Where the java runtime that you would like to
                          use is located.],
[
	if test -x ${withval}; then
	    JAVA=${withval}
	else
	    AC_PATH_PROG(JAVA, ${withval})
        fi

	
])

if test x$JAVA = x && test x$jdk_specified = xfalse; then
    AC_PATH_PROG(JAVA, java)
fi

# also look in the JDK_HOME as it may 
if test ! x$JDK_HOME = x && test x$JAVA = x; then
    AC_MSG_CHECKING(for java in ${JDK_HOME}/bin)
    if test -x "${JDK_HOME}/bin/java"; then
	JAVA="${JDK_HOME}/bin/java"
	AC_MSG_RESULT(${JAVA})
	AC_SUBST(JAVA)
    else
	AC_MSG_RESULT(no)
    fi
fi

if test x$jdk_specified = xtrue && test x$JAVA = x; then
    AC_PATH_PROG(JAVA, java)
fi    
])

dnl Find the java compiler
dnl Result goes in JAVAC
AC_DEFUN(AC_PROG_JAVAC,
[
AC_REQUIRE([AC_PATH_JDK])

AC_ARG_WITH(javac,
[  --with-javac=DIR       Where your javac program is located.],
[
	if test -x ${withval}; then
	    JAVAC=${withval}
	else
	    AC_PATH_PROG(JAVAC, ${withval})
        fi
])

if test x$JAVAC = x && test x$jdk_specified = xfalse; then
    AC_PATH_PROG(JAVAC, javac)
fi

# also look in the JDK_HOME as it may 
if test ! x$JDK_HOME = x && test x$JAVAC = x; then
    AC_MSG_CHECKING(for javac in ${JDK_HOME}/bin)
	
    if test -x "${JDK_HOME}/bin/javac"; then
	JAVAC="${JDK_HOME}/bin/javac"
	AC_MSG_RESULT(${JAVAC})
	AC_SUBST(JAVAC)
    else
	AC_MSG_RESULT(no)
    fi
fi

if test x$jdk_specified = xtrue && test x$JAVAC = x; then
    AC_PATH_PROG(JAVAC, javac)
fi


])


dnl Find the java compiler
dnl Result goes in JAR
AC_DEFUN(AC_PROG_JAR,
[
AC_REQUIRE([AC_PATH_JDK])

if test x$jdk_specified = xfalse; then
    AC_PATH_PROG(JAR, jar)
fi

# also look in the JDK_HOME as it may 
if test ! x$JDK_HOME = x && test x$JAR = x; then
    AC_MSG_CHECKING(for jar in ${JDK_HOME}/bin)
	
    if test -x "${JDK_HOME}/bin/jar"; then
	JAR="${JDK_HOME}/bin/jar"
	AC_MSG_RESULT(${JAR})
	AC_SUBST(JAR)
    else
	AC_MSG_RESULT(no)
    fi
fi

if test x$jdk_specified = xtrue && test x$JAR = x; then
    AC_PATH_PROG(JAR, jar)
fi
])
