/*
 * Copyright (c) 1997-1998 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Java Apache 
 *    Project for use in the Apache JServ servlet engine project
 *    (http://java.apache.org/)."
 *
 * 4. The names "Apache JServ", "Apache JServ Servlet Engine" and 
 *    "Java Apache Project" must not be used to endorse or promote products 
 *    derived from this software without prior written permission.
 *
 * 5. Products derived from this software may not be called "Apache JServ"
 *    nor may "Apache" nor "Apache JServ" appear in their names without 
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Java Apache 
 *    Project for use in the Apache JServ servlet engine project
 *    (http://java.apache.org/)."
 *    
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Group. For more information
 * on the Java Apache Project and the Apache JServ Servlet Engine project,
 * please see <http://java.apache.org/>.
 *
 */

/*****************************************************************************
 * Description: Apache JServ 1.0 apache backward compatibility include file  *
 * Author:      Pierpaolo Fumagalli <ianosh@iname.com>                       *
 * Version:     1.0 Beta                                                     *
 *****************************************************************************/
#ifndef __JSERV_COMPAT_H__
#define __JSERV_COMPAT_H__

/* ========================================================================= */
/* Apache 1.3.0 and below function renaming (ap_table_elts was a left-over from
   1.2 to 1.3.0 and renamed in 1.3.1 */
#if MODULE_MAGIC_NUMBER < 19980713
#define ap_table_elts           table_elts
#define ap_is_empty_table       is_empty_table
#endif

/* ========================================================================= */
/* Apache 1.2.6 and below function renaming */
#if MODULE_MAGIC_NUMBER < 19980527

/* ========================================================================= */
/* Override MODULE VAR EXPORT nedeed for WinNT to VOID */
#define MODULE_VAR_EXPORT 

/* ========================================================================= */
/* Log levels and functions */
#define APLOG_MARK                      __FILE__,__LINE__
#define	APLOG_EMERG	                    0
#define	APLOG_ALERT	                    1
#define	APLOG_CRIT	                    2
#define	APLOG_ERR	                    3
#define	APLOG_WARNING	                4
#define	APLOG_NOTICE	                5
#define	APLOG_INFO                      6
#define	APLOG_DEBUG                     7
#define	APLOG_LEVELMASK                 7
#define APLOG_NOERRNO                   (APLOG_LEVELMASK + 1)
#define ap_log_error                    compat_log_error
void compat_log_error(const char *file, int line, int level,
                      const server_rec *s, const char *fmt, ...);

/* ========================================================================= */
/* Different functions needing OVERRIDE */
#define AP_MD5_CTX                      MD5_CTX
#define B_SOCKET                        0
#define ap_MD5Final                     MD5Final
#define ap_MD5Init                      MD5Init
#define ap_MD5Update                    MD5Update
#define ap_add_cgi_vars                 add_cgi_vars               
#define ap_add_common_vars              add_common_vars            
#define ap_bclose                       bclose                     
#define ap_bcreate                      bcreate          
#define ap_bflush                       bflush                     
#define ap_bpushfd                      bpushfd                    
#define ap_bwrite                       bwrite                     
#define ap_cleanup_for_exec             cleanup_for_exec
#define ap_destroy_pool                 destroy_pool
#define ap_get_client_block             get_client_block           
#define ap_get_module_config            get_module_config
#define ap_hard_timeout                 hard_timeout
#define ap_internal_redirect_handler    internal_redirect_handler
#define ap_kill_timeout                 kill_timeout
#define ap_make_sub_pool                make_sub_pool
#define ap_make_table                   make_table
#define ap_overlay_tables               overlay_tables
#define ap_pcalloc                      pcalloc
#define ap_pstrcat                      pstrcat
#define ap_pstrdup                      pstrdup
#define ap_pstrndup                     pstrndup
#define ap_register_cleanup             register_cleanup
#define ap_reset_timeout                reset_timeout
#define ap_rprintf                      rprintf
#define ap_rputs                        rputs
#define ap_rwrite                       rwrite
#define ap_send_http_header             send_http_header
#define ap_server_root_relative         server_root_relative
#define ap_set_content_length           set_content_length
#define ap_set_module_config            set_module_config
#define ap_setup_client_block           setup_client_block         
#define ap_should_client_block          should_client_block        
#define ap_table_get                    table_get
#define ap_table_set                    table_set
#define ap_table_setn                   table_set
#define ap_table_unset                  table_unset
#define ap_user_name                    user_name
#define ap_group_id                     group_id

/* ========================================================================= */
/* Functions from apache 1.3 not present in 1.2 backward-ported for compat. */
#define ap_null_cleanup                 compat_null
#define ap_pvsprintf                    compat_pvsprintf
#define ap_psprintf                     compat_psprintf
#define ap_add_version_component        compat_null
#define ap_psocket                      compat_psocket          
#define ap_scan_script_header_err_buff  compat_scan_script_header_err_buff
#define ap_send_fb                      compat_send_fb                    
#define ap_pclosesocket                 compat_pclosesocket               

long compat_send_fb(BUFF *fb, request_rec *r);
int compat_psocket(pool *p, int domain, int type, int protocol);
int compat_pclosesocket(pool *a, int sock);
char *compat_pvsprintf(pool *p, const char *fmt, va_list ap);
char *compat_psprintf(pool *p, const char *fmt, ...);
void compat_null(void *data);
int compat_scan_script_header_err_buff(request_rec *r, BUFF *f, char *buffer);

#endif 
       
#endif /*__JSERV_COMPAT_H__*/
