::
:: Win32 build script for C side
::
:: @author Stefano Mazzocchi <stefano@apache.org>
:: @version $Revision: 1.5 $ $Date: 1998/11/19 17:32:04 $
::

@echo off

:: WARNING: directories in different drives and names with spaces may cause
:: problems in this script. Use may want to use short name here.

:: Compile wrapper or module?
if "%build%"=="" set build=module

:: Set the JServ home directory
if "%jserv_home%"=="" set jserv_home=c:\jserv

:: Set the C source directory
if "%c_src%"=="" set c_src=%jserv_home%\src\c

:: Set the Apache source directory
if "%apache_src%"=="" set apache_src=c:\apache\src

:: Set the module destination directory
if "%c_module_dest%"=="" set c_module_dest=%jserv_home%\bin\c

:: Set the wrapper destination directory
if "%c_wrapper_dest%"=="" set c_wrapper_dest=%jserv_home%\bin\c

:: Set the C make tool
if "%make%"=="" set make=nmake

echo.
echo Compile C distribution:
echo.

echo  * Checking source existance...
if not exist %c_src%\mod_jserv.c goto srcnotfound

echo  * Checking for Apache source existance...
if not exist %apache_src%\main\http_main.c goto apachenotfound

echo  * Checking if destination directory exists and is readable...
echo temp > %c_dest%\temp.tmp
if not exist %c_dest%\temp.tmp goto destnotfound
del %c_dest%\temp.tmp > nul

echo  * Compiling Apache JServ %build% using %make%...
if not "%make%"=="nmake" goto other
:::::::: Use Microsoft Visual C++ 5.0 (thru nmake)
if "%build%"=="wrapper" goto wrapper
if "%build%"=="module" goto module
echo.
echo Don't know how to make %build%
goto error

:wrapper
%make% /f %c_src%\makefile.win32 /nologo APACHE_SRC=%apache_src% MOD_JSERV_SRC=%c_src% STANDALONE=true
if errorlevel 1 goto fatal
move ApacheJServ.exe %c_wrapper_dest%\ApacheJServ.exe > nul
%make% /f %c_src%\makefile.win32 /nologo MOD_JSERV_SRC=%c_src% clean
goto done

:module
%make% /f %c_src%\makefile.win32 /nologo APACHE_SRC=%apache_src% MOD_JSERV_SRC=%c_src%
if errorlevel 1 goto fatal
move ApacheModuleJServ.dll %c_module_dest%\ApacheModuleJServ.dll > nul
%make% /f %c_src%\makefile.win32 /nologo MOD_JSERV_SRC=%c_src% clean
goto done

:other
echo.
echo Don't know how to use %make%
goto error

:srcnotfound
echo.
echo The specified path does not contain the proper C source.
echo Please, check the path %c_src% and try again.
goto error

:apachenotfound
echo.
echo The specified path does not contain the proper Apache source.
echo Please, check the path %apache_src% and try again.
goto error

:destnotfound
echo.
echo The specified destination path doesn't exist or it's readonly.
echo Please, check the path %c_dest% and try again.
goto error

:fatal
echo Sore error occurred during compilation.
%make% /f %c_src%\makefile.win32 /nologo clean
goto error

:error
goto end

:done
echo  * done.

:end
