// ====================================================================
// Copyright (c) 1997 The Apache Group.  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer. 
//
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in
//    the documentation and/or other materials provided with the
//    distribution.
//
// 3. All advertising materials mentioning features or use of this
//    software must display the following acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// 4. The names "Apache Server" and "Apache Group" must not be used to
//    endorse or promote products derived from this software without
//    prior written permission.
//
// 5. Redistributions of any form whatsoever must retain the following
//    acknowledgment:
//    "This product includes software developed by the Apache Group
//    for use in the Apache HTTP server project (http://www.apache.org/)."
//
// THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
// EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
// ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
// ====================================================================
//
// This software consists of voluntary contributions made by many
// individuals on behalf of the Apache Group and was originally based
// on public domain software written at the National Center for
// Supercomputing Applications, University of Illinois, Urbana-Champaign.
// For more information on the Apache Group and the Apache HTTP server
// project, please see <http://www.apache.org/>.

// JServ - Serve up Java servlets
// by Alexei Kosut <akosut@apache.org>

// Parts are based on examples from  _Java in a Nutshell_ by David Flanagan:
// Written by David Flanagan.  Copyright (c) 1996 O'Reilly & Associates.
// You may study, use, modify, and distribute this example for any purpose.
// This example is provided WITHOUT WARRANTY either expressed or implied.

// JServContext.java:
// - apache.jserv.JServContext

package apache.jserv;

import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;

// This class implements the parts of the servlet that are longer-lived
// than a single request, ServletConfig and ServletContext

class JServContext implements ServletConfig, ServletContext {
    private Hashtable servlets;

    // The servlet itself
    protected Servlet servlet;

    // Servlet metdata
    private Properties initargs;
    protected Stack log_messages;
    protected JServLock lock;

    // Constructor

    public JServContext(Servlet servlet, Hashtable servlets,
			Properties initargs) {
	this.servlet = servlet;
	
	this.servlets = servlets;
	this.initargs = initargs;

	log_messages = new Stack();
	lock = new JServLock();
    }

    // Methods from ServletConfig

    public ServletContext getServletContext() {
	return this;
    }

    public String getInitParameter(String name) {
	return initargs.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
	return initargs.propertyNames();
    }

    // Methods from ServletContext

    public Servlet getServlet(String name) throws ServletException {
	synchronized (servlets) {
	    JServContext context = (JServContext)servlets.get(name);
	    if (context == null)
		return null;
	    return context.servlet;
	}
    }

    public Enumeration getServlets() {
	synchronized (servlets) {
	    Vector mys = new Vector(servlets.size());

	    for (Enumeration e = servlets.elements(); e.hasMoreElements();)
		mys.addElement(((JServContext)e.nextElement()).servlet);

	    return mys.elements();
	}
    }

    public void log(String msg) {
	synchronized (log_messages) {
	    log_messages.push(msg);
	}
    }

    public String getRealPath(String path) {
	// FIXME: See the note under JServConnection.getRealPath()
	// Until then, we return null for "not supported"
	return null;
    }

    public String getMimeType(String file) {
	// FIXME: See above. This should talk to Apache, do a subrequest
	// and return the content type. But we can't do that right now,
	// so we test a few common types, and return them. *sigh*

	if (file.endsWith(".html") || file.endsWith(".htm"))
	    return "text/html";
	if (file.endsWith(".txt"))
	    return "text/plain";
	if (file.endsWith(".gif"))
	    return "image/gif";
	if (file.endsWith(".jpg") || file.endsWith(".jpeg"))
	    return "image/jpeg";
	if (file.endsWith(".class"))
	    return "application/octet-stream";

	// Return plain text as the default
	return "text/plain";
    }

    public String getServerInfo() {
	// This isn't quite SERVER_INFO, but I guess it's the
	// most direct 'server' to the servlet.
	return JServHandler.version;
    }

    public Object getAttribute(String name) {
	// We don't have any attributes for the network service
	return null;
    }
}
