#!/bin/sh

# ------------------------------------------------------
# Please see the document visitor_roles_permissions.html 
# for more information on how to use this 
# ------------------------------------------------------

HEADER_FILE=header_jyve_access_rights
PERMISSIONS_FILE=jyve_permissions_roles
USERS_FILE=jyve_users_roles
OUTPUT_FILE=Generated_MySQL_Schema.sql


JYVE_CLASSES="../bin/classes"

# -------------- NO NEED TO TOUCH ANYTHING BELOW --------------
ARGS="-headerFile ${HEADER_FILE} -permissionsFile ${PERMISSIONS_FILE} -usersFile ${USERS_FILE} -outputFile ${OUTPUT_FILE}"

MAIN_CLASS=${JYVE_CLASSES}/org/apache/jyve/util/GenerateRights.class

echo Main Class: ${MAIN_CLASS}
echo Jyve Classes: ${JYVE_CLASSES}
echo Arguments: ${ARGS}

if test -z "${JAVA_HOME}" ; then
    echo "ERROR: JAVA_HOME not found in your environment."
    echo "Please, set the JAVA_HOME variable in your environment to match the"
    echo "location of the Java Virtual Machine you want to use."
    exit
fi
if ! test -f "${MAIN_CLASS}" ; then
    echo "ERROR: ${MAIN_CLASS} not found!"
    echo "Please, the JYVE_CLASSES variable in GenerateRights.sh"
    echo "or make sure to execute ../build/build-jyve.sh first!"
    exit
fi

CP=${CLASSPATH}:${JYVE_CLASSES}
echo Classpath: ${CP}
${JAVA_HOME}/bin/java -classpath ${CP} org.apache.jyve.util.GenerateRights ${ARGS}
