from xpcom import components
import os, sys

if os.name == 'nt':
  import ctypes
  class Pun (ctypes.Structure):
    _fields_ = [("x", ctypes.c_ulong), ("y", ctypes.c_ulong)]
elif os.name == 'posix':
  sys.path.append(os.path.dirname(__file__)+"/lin")
  from Xlib import display

class pyRaton:
    _com_interfaces_ = [components.interfaces.pyIRaton]
    _reg_clsid_ = "{90c1eb02-ccf6-4400-8a20-ae1599c4d03b}"
    _reg_contractid_ = "@phpyjs.com/pyRaton;1"
    _reg_desc_ = "Mouse Position"
    
    def __init__ (self):
        if os.name == "posix":
            self.d = display
        elif os.name == "nt":
            self.u = ctypes.windll.user32
    
    def setPos (self, x, y):
        if os.name == "posix":
            e = self.d.Display()
            r = e.screen().root
            r.warp_pointer(x,y)
            e.sync()
        elif os.name == "nt":
            self.u.SetCursorPos(x,y)

    def getPosX(self):
        if os.name == "posix":
            r = self.d.Display().screen().root
            dat = r.query_pointer()._data
            return dat["root_x"]
        elif os.name == "nt":
            p = Pun()
            self.u.GetCursorPos(ctypes.byref(p))
            return p.x

    def getPosY(self):
        if os.name == "posix":
            r = self.d.Display().screen().root
            dat = r.query_pointer()._data
            return dat["root_y"]
        elif os.name == "nt":
            p = Pun()
            self.u.GetCursorPos(ctypes.byref(p))
            return p.y

PYXPCOM_CLASSES = [
    pyRaton,
]
