/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.portal.actionController;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.CommandHandlerActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.SamplesUIPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesActionController
extends AbstractActionController {
    protected static final String IMPORT_SAMPLE_COMMAND = "com.aptana.samples.ui.commands.import";
    protected static final String IMPORT_SAMPLE_COMMAND_ID = "id";

    @ControllerAction
    public Object getSamples() {
        ArrayList samples = new ArrayList();
        ISamplesManager samplesManager = SamplesPlugin.getDefault().getSamplesManager();
        List categories = samplesManager.getCategories();
        for (SampleCategory category : categories) {
            for (SamplesReference sample : samplesManager.getSamplesForCategory(category.getId())) {
                HashMap<String, String> sampleInfo = new HashMap<String, String>();
                sampleInfo.put(SAMPLE_INFO.CATEGORY.toString(), category.getName());
                sampleInfo.put(SAMPLE_INFO.NAME.toString(), sample.getName());
                sampleInfo.put(SAMPLE_INFO.ID.toString(), sample.getId());
                sampleInfo.put(SAMPLE_INFO.DESCRIPTION.toString(), sample.getDescription());
                sampleInfo.put(SAMPLE_INFO.IMAGE.toString(), "");
                samples.add(sampleInfo);
            }
        }
        return JSON.toString((Object[])samples.toArray(new Map[samples.size()]));
    }

    @ControllerAction
    public Object importSample(Object attributes) {
        String sampleID = this.getSampleId(attributes);
        if (sampleID == null) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"The importSample ControllerAction should get a sampleID attribute", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        CommandHandlerActionController commandHandler = new CommandHandlerActionController();
        HashMap<String, String> commandArguments = new HashMap<String, String>();
        commandArguments.put(IMPORT_SAMPLE_COMMAND_ID, sampleID);
        return commandHandler.execute((Object)new Object[]{IMPORT_SAMPLE_COMMAND, commandArguments});
    }

    private String getSampleId(Object attributes) {
        if (attributes instanceof Object[]) {
            Object[] arr = (Object[])attributes;
            if (arr.length == 1 && arr[0] != null) {
                return arr[0].toString();
            }
            String message = MessageFormat.format("Wrong argument count passed to SamplesActionController::importSample. Expected 1 and got {0}", arr.length);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        } else {
            String message = MessageFormat.format("Wrong argument type passed to SamplesActionController::importSample. Expected Object[] and got {0}", attributes == null ? "null" : attributes.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return null;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SAMPLE_INFO {
        CATEGORY("category"),
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        IMAGE("image");

        private String name;

        private SAMPLE_INFO(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

