/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.portal.actionController;

import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.dispatch.browserNotifications.AbstractBrowserNotification;
import com.aptana.samples.ISampleListener;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.SamplesUIPlugin;
import com.aptana.samples.ui.portal.actionController.SamplesActionController;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;

public class SamplesNotification
extends AbstractBrowserNotification {
    private ISampleListener listener;

    public synchronized void start() {
        this.isListening = true;
        SamplesPlugin.getDefault().getSamplesManager().addSampleListener(this.getListener());
        IdeLog.logInfo((Plugin)SamplesUIPlugin.getDefault(), (String)"Samples Portal notifier started", (String)"com.aptana.portal.ui/debug/startpage");
    }

    public synchronized void stop() {
        this.isListening = false;
        SamplesPlugin.getDefault().getSamplesManager().removeSampleListener(this.getListener());
        this.listener = null;
        IdeLog.logInfo((Plugin)SamplesUIPlugin.getDefault(), (String)"Samples Portal notifier stopped", (String)"com.aptana.portal.ui/debug/startpage");
    }

    protected void notifyAdd(SamplesReference sample) {
        IdeLog.logInfo((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample added. Notifying portal...", (String)"com.aptana.portal.ui/debug/startpage");
        this.notifyTargets("samples", "added", this.createSampleInfo(sample), true);
    }

    protected void notifyRemoved(SamplesReference sample) {
        IdeLog.logInfo((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample removed. Notifying portal...", (String)"com.aptana.portal.ui/debug/startpage");
        this.notifyTargets("samples", "deleted", this.createSampleInfo(sample), true);
    }

    protected String createSampleInfo(SamplesReference sample) {
        HashMap<String, String> sampleInfo = new HashMap<String, String>();
        SampleCategory category = sample.getCategory();
        sampleInfo.put(SamplesActionController.SAMPLE_INFO.CATEGORY.toString(), category != null ? category.getName() : "");
        sampleInfo.put(SamplesActionController.SAMPLE_INFO.NAME.toString(), sample.getName());
        sampleInfo.put(SamplesActionController.SAMPLE_INFO.ID.toString(), sample.getId());
        sampleInfo.put(SamplesActionController.SAMPLE_INFO.DESCRIPTION.toString(), sample.getDescription());
        sampleInfo.put(SamplesActionController.SAMPLE_INFO.IMAGE.toString(), "");
        return JSON.toString(sampleInfo);
    }

    protected synchronized ISampleListener getListener() {
        if (this.listener == null) {
            this.listener = new ISampleListener(){

                public void sampleRemoved(SamplesReference sample) {
                    if (SamplesNotification.this.isListening) {
                        SamplesNotification.this.notifyRemoved(sample);
                    }
                }

                public void sampleAdded(SamplesReference sample) {
                    if (SamplesNotification.this.isListening) {
                        SamplesNotification.this.notifyAdd(sample);
                    }
                }
            };
        }
        return this.listener;
    }
}

