/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.views;

import com.aptana.samples.ISampleListener;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.views.SamplesViewContentProvider;
import com.aptana.samples.ui.views.SamplesViewLabelProvider;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

public class SamplesView
extends ViewPart {
    public static final String ID = "com.aptana.samples.ui.SamplesView";
    private TreeViewer treeViewer;
    private ISampleListener sampleListener = new ISampleListener(){

        public void sampleAdded(SamplesReference sample) {
            this.refresh();
        }

        public void sampleRemoved(SamplesReference sample) {
            this.refresh();
        }

        private void refresh() {
            UIUtils.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (SamplesView.this.treeViewer != null && !SamplesView.this.treeViewer.getControl().isDisposed()) {
                        SamplesView.this.treeViewer.refresh();
                    }
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.hookContextMenu();
        this.applyTheme();
        SamplesView.getSamplesManager().addSampleListener(this.sampleListener);
    }

    public void setFocus() {
    }

    public void dispose() {
        SamplesView.getSamplesManager().removeSampleListener(this.sampleListener);
        super.dispose();
        ThemePlugin.getDefault().getControlThemerFactory().dispose((Viewer)this.treeViewer);
    }

    public void collapseAll() {
        this.treeViewer.collapseAll();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 772);
        treeViewer.setContentProvider((IContentProvider)new SamplesViewContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new SamplesViewLabelProvider());
        treeViewer.setInput((Object)SamplesView.getSamplesManager());
        treeViewer.setComparator(new ViewerComparator());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        return treeViewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void applyTheme() {
        ThemePlugin.getDefault().getControlThemerFactory().apply((Viewer)this.treeViewer);
    }

    private static ISamplesManager getSamplesManager() {
        return SamplesPlugin.getDefault().getSamplesManager();
    }
}

