/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.usage.IAnalyticsUser;
import com.aptana.usage.IAnalyticsUserManager;
import com.aptana.usage.UsagePlugin;
import com.aptana.usage.internal.AnalyticsInfo;
import com.aptana.usage.internal.AnalyticsInfoManager;
import com.aptana.usage.internal.DefaultAnalyticsInfo;
import com.eaio.uuid.MACAddress;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsEvent {
    private static final String SPEC_VERSION = "2";
    private static final String EMPTY_JSON_PAYLOAD = "{}";
    private static final AnalyticsInfo APP_INFO;
    private static String sessionId;
    private String dateTime;
    private String eventType;
    private String eventName;
    private String eventString;
    private String JSONPayloadString;

    static {
        AnalyticsInfo info = AnalyticsInfoManager.getInstance().getInfo("com.aptana.usage.analytics");
        APP_INFO = info == null ? new DefaultAnalyticsInfo() : info;
    }

    public AnalyticsEvent(String eventType, String eventName, Map<String, String> eventPayload) {
        this(eventType, eventName);
        try {
            this.JSONPayloadString = eventPayload != null ? JSON.toString(eventPayload) : EMPTY_JSON_PAYLOAD;
            this.dateTime = Long.toString(System.currentTimeMillis());
            this.init();
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)"Unable to log analytics information", (Throwable)ex);
        }
    }

    public AnalyticsEvent(String eventType, String eventName, String eventPayload, String dateTime) {
        this(eventType, eventName);
        try {
            this.JSONPayloadString = eventPayload;
            this.dateTime = dateTime;
            this.init();
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)"Unable to log analytics information", (Throwable)ex);
        }
    }

    private AnalyticsEvent(String eventType, String eventName) {
        this.eventName = eventName;
        this.eventType = eventType;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getJSONPayloadString() {
        return this.JSONPayloadString;
    }

    public String getEventString() {
        return this.eventString;
    }

    public static String getUserAgent() {
        return APP_INFO.getUserAgent();
    }

    public static IAnalyticsUserManager getUserManager() {
        return APP_INFO.getUserManager();
    }

    private void init() {
        StringBuilder event = new StringBuilder();
        IAnalyticsUserManager userManager = AnalyticsEvent.getUserManager();
        IAnalyticsUser user = userManager == null ? null : userManager.getUser();
        this.addPostEntry(event, "event", this.eventName);
        this.addPostEntry(event, "type", this.eventType);
        if (StringUtil.isEmpty((String)sessionId)) {
            if (user != null) {
                sessionId = user.getSessionID();
            }
            if (StringUtil.isEmpty((String)sessionId)) {
                sessionId = UUID.randomUUID().toString();
            }
        }
        this.addPostEntry(event, "sid", sessionId);
        this.addPostEntry(event, "guid", APP_INFO.getAppGuid());
        this.addPostEntry(event, "mid", CorePlugin.getMID());
        this.addPostEntry(event, "app_id", APP_INFO.getAppId());
        this.addPostEntry(event, "creator_user_id", user == null ? "" : user.getUID());
        this.addPostEntry(event, "app_name", APP_INFO.getAppName());
        this.addPostEntry(event, "app_version", EclipseUtil.getPluginVersion((String)APP_INFO.getVersionPluginId()));
        this.addPostEntry(event, "mac_addr", MACAddress.getMACAddress());
        this.addPostEntry(event, "platform", "macosx".equals(Platform.getOS()) ? "osx" : Platform.getOS());
        this.addPostEntry(event, "version", "1.1.0");
        this.addPostEntry(event, "os", System.getProperty("os.name"));
        this.addPostEntry(event, "ostype", String.valueOf(System.getProperty("sun.arch.data.model")) + "bit");
        this.addPostEntry(event, "osver", System.getProperty("os.version"));
        this.addPostEntry(event, "osarch", System.getProperty("os.arch"));
        this.addPostEntry(event, "oscpu", Integer.toString(Runtime.getRuntime().availableProcessors()));
        this.addPostEntry(event, "un", user == null ? "" : user.getUsername());
        this.addPostEntry(event, "ver", SPEC_VERSION);
        TimeZone tz = TimeZone.getDefault();
        int results = -(tz.getDSTSavings() + tz.getRawOffset());
        results = results / 1000 / 60;
        this.addPostEntry(event, "tz", Integer.toString(results));
        try {
            InetAddress ip = InetAddress.getLocalHost();
            this.addPostEntry(event, "ip", ip.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            this.addPostEntry(event, "ip", "");
        }
        if (!EMPTY_JSON_PAYLOAD.equals(this.getJSONPayloadString())) {
            String formattedJSON = this.getJSONPayloadString();
            if (formattedJSON.contains("languageModules")) {
                formattedJSON = formattedJSON.replace("\"{", "{");
                formattedJSON = formattedJSON.replace("}\"", "}");
                formattedJSON = formattedJSON.replace("\\\"", "\"");
            }
            this.addPostEntry(event, "data", formattedJSON);
        }
        event.deleteCharAt(event.lastIndexOf("&"));
        this.eventString = event.toString();
    }

    private void addPostEntry(StringBuilder event, String key, String value) {
        if (value == null) {
            value = "";
        }
        event.append(key);
        event.append("=");
        try {
            event.append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            event.append(value);
        }
        event.append("&");
    }
}

