/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.AptanaDB;
import com.aptana.usage.IResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyticsLogger {
    private static final String TABLE_NAME = "analyticsLogs";
    private static final String DATE_TIME = "dateTime";
    private static final String EVENT_TYPE = "eventType";
    private static final String EVENT_NAME = "eventName";
    private static final String DATA = "data";
    private static final String GET_EVENTS = MessageFormat.format("SELECT {0},{1},{2},{3} FROM {4} ORDER BY {0}", "eventType", "eventName", "data", "dateTime", "analyticsLogs");
    private static AnalyticsLogger INSTANCE;

    public static synchronized AnalyticsLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AnalyticsLogger();
            if (!AptanaDB.tableExists(TABLE_NAME)) {
                String query = MessageFormat.format("CREATE TABLE {0}({1} varchar(255), {2} varchar(255), {3} varchar(32000), {4} varchar(255))", TABLE_NAME, EVENT_TYPE, EVENT_NAME, DATA, DATE_TIME);
                AptanaDB.getInstance().execute(query);
            }
        }
        return INSTANCE;
    }

    public void logEvent(AnalyticsEvent event) {
        String query = MessageFormat.format("INSERT INTO {0}({1},{2},{3}, {4}) VALUES(''{5}'',''{6}'',''{7}'',''{8}'')", TABLE_NAME, EVENT_TYPE, EVENT_NAME, DATA, DATE_TIME, event.getEventType(), event.getEventName(), event.getJSONPayloadString(), event.getDateTime());
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvents() {
        String query = "DELETE FROM analyticsLogs";
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvent(AnalyticsEvent event) {
        String query = MessageFormat.format("DELETE FROM {0} WHERE {1}=''{2}'' AND {3}=''{4}'' AND {5}=''{6}'' AND {7}=''{8}''", TABLE_NAME, EVENT_TYPE, event.getEventType(), EVENT_NAME, event.getEventName(), DATA, event.getJSONPayloadString(), DATE_TIME, event.getDateTime());
        AptanaDB.getInstance().execute(query);
    }

    public List<AnalyticsEvent> getEvents() {
        final ArrayList<AnalyticsEvent> events = new ArrayList<AnalyticsEvent>();
        AptanaDB.getInstance().execute(GET_EVENTS, new IResultSetHandler(){

            public void processResultSet(ResultSet resultSet) throws SQLException {
                String eventType = resultSet.getString(1);
                String eventName = resultSet.getString(2);
                String data = resultSet.getString(3);
                String dateTime = resultSet.getString(4);
                events.add(new AnalyticsEvent(eventType, eventName, data, dateTime));
            }
        });
        return events;
    }
}

