/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ResourceUtil;
import com.aptana.usage.IResultSetHandler;
import com.aptana.usage.Messages;
import com.aptana.usage.UsagePlugin;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.datalocation.Location;

public class AptanaDB {
    private static final String DATABASE_NAME = "aptanaDB";
    private static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PROTOCOL = "jdbc:derby:";
    private static AptanaDB INSTANCE;
    private boolean _driverLoaded;

    private AptanaDB() {
    }

    public static AptanaDB getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AptanaDB();
            INSTANCE.loadDriver();
        }
        return INSTANCE;
    }

    public void execute(String query) {
        this.execute(query, null);
    }

    public void execute(String query, IResultSetHandler handler) {
        block34: {
            Connection connection = AptanaDB.getInstance().getConnection();
            if (connection != null) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    try {
                        statement = connection.createStatement();
                        if (IdeLog.isTraceEnabled((Plugin)UsagePlugin.getDefault(), (String)"com.aptana.usage/debug/db")) {
                            IdeLog.logTrace((Plugin)UsagePlugin.getDefault(), (String)query);
                        }
                        if (handler == null) {
                            statement.execute(query);
                        } else {
                            resultSet = statement.executeQuery(query);
                            while (resultSet.next()) {
                                handler.processResultSet(resultSet);
                            }
                        }
                    }
                    catch (SQLException e) {
                        IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)Messages.AptanaDB_Error_Execute_Query, (Throwable)e);
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                    throw throwable;
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public Connection getConnection() {
        if (this._driverLoaded) {
            try {
                return DriverManager.getConnection("jdbc:derby:aptanaDB;create=true");
            }
            catch (SQLException e) {
                IdeLog.logWarning((Plugin)UsagePlugin.getDefault(), (String)Messages.AptanaDB_FailedToConnect, (Throwable)e);
            }
        }
        return null;
    }

    public void shutdown() {
        if (this._driverLoaded) {
            try {
                DriverManager.getConnection("jdbc:derby:aptanaDB;shutdown=true");
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean tableExists(String tableName) {
        Statement statement;
        Connection connection;
        block30: {
            block31: {
                connection = null;
                statement = null;
                connection = AptanaDB.getInstance().getConnection();
                if (connection != null) break block30;
                if (statement == null) break block31;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection == null) return false;
            try {
                connection.close();
                return false;
            }
            catch (SQLException sQLException) {}
            return false;
        }
        try {
            try {
                statement = connection.createStatement();
                statement.execute("SELECT COUNT(*) FROM " + tableName);
            }
            catch (SQLException sqle) {
                String errorStateCode = sqle.getSQLState();
                if (errorStateCode.equals("42X05")) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (connection == null) return false;
                    try {
                        connection.close();
                        return false;
                    }
                    catch (SQLException sQLException) {}
                    return false;
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection == null) return true;
                try {
                    connection.close();
                    return true;
                }
                catch (SQLException sQLException) {}
                return true;
            }
        }
        catch (Throwable throwable) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        if (connection == null) return true;
        try {
            connection.close();
            return true;
        }
        catch (SQLException sQLException) {}
        return true;
    }

    private void loadDriver() {
        try {
            Location location = Platform.getConfigurationLocation();
            if (!(location != null && !location.isReadOnly() || (location = Platform.getInstallLocation()) != null && !location.isReadOnly() || (location = Platform.getUserLocation()) != null && !location.isReadOnly())) {
                location = null;
            }
            if (location != null) {
                File homeDirectory = ResourceUtil.resourcePathToFile((URL)location.getURL());
                homeDirectory.mkdirs();
                System.setProperty("derby.system.home", homeDirectory.getAbsolutePath());
                Class.forName(DRIVER).newInstance();
                this._driverLoaded = true;
            }
        }
        catch (InstantiationException e) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)Messages.AptanaDB_FailedToInstantiate, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)Messages.AptanaDB_FailedToAccess, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)Messages.AptanaDB_FailedToLoad, (Throwable)e);
        }
    }
}

