/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.CorePlugin;
import com.aptana.core.util.EclipseUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.StudioAnalytics;
import com.aptana.usage.UsagePlugin;
import com.aptana.usage.internal.AnalyticsInfo;
import com.aptana.usage.internal.AnalyticsInfoManager;
import com.aptana.usage.internal.DefaultAnalyticsInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.IStartup;
import org.osgi.service.prefs.BackingStoreException;

public class PingStartup
implements IStartup {
    private static final String STUDIO_FIRST_RUN = "studio.first-run";
    private static final String STUDIO_ENROLL = "ti.enroll";
    private static final Map<String, String> STUDIO_NATURE_MAP = new HashMap<String, String>();
    private static IResourceChangeListener resourceListener;

    static {
        STUDIO_NATURE_MAP.put("com.aptana.projects.webnature", "web");
        STUDIO_NATURE_MAP.put("com.aptana.editor.php.phpNature", "php");
        STUDIO_NATURE_MAP.put("com.aptana.ruby.core.rubynature", "ruby");
        STUDIO_NATURE_MAP.put("org.radrails.rails.core.railsnature", "rails");
        resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 4) {
                    try {
                        String[] natures;
                        IProject project = event.getResource().getProject();
                        IProjectDescription description = project.getDescription();
                        String[] stringArray = natures = description.getNatureIds();
                        int n = natures.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String nature = stringArray[n2];
                            String projectType = (String)STUDIO_NATURE_MAP.get(nature);
                            if (projectType != null) {
                                PingStartup.sendProjectDeleteEvent(project, projectType);
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        UsagePlugin.logError(e);
                    }
                }
            }
        };
    }

    public void earlyStartup() {
        boolean hasEnrolled;
        ConfigurationScope scope = EclipseUtil.configurationScope();
        boolean hasRun = Platform.getPreferencesService().getBoolean("com.aptana.usage", "ide-has-run", false, new IScopeContext[]{scope});
        if (!hasRun && !(hasRun = Platform.getPreferencesService().getBoolean("com.aptana.db", "ide-has-run", false, new IScopeContext[]{scope}))) {
            StudioAnalytics.getInstance().sendEvent(new AnalyticsEvent(STUDIO_FIRST_RUN, STUDIO_FIRST_RUN, null));
            IEclipsePreferences store = scope.getNode("com.aptana.usage");
            store.putBoolean("ide-has-run", true);
            try {
                store.flush();
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        if (!(hasEnrolled = Platform.getPreferencesService().getBoolean("com.aptana.usage", "has_enrolled", false, new IScopeContext[]{scope}))) {
            AnalyticsInfo info = AnalyticsInfoManager.getInstance().getInfo("com.aptana.usage.analytics");
            String guid = info.getAppGuid();
            if (new DefaultAnalyticsInfo().getAppGuid().equals(guid)) {
                LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
                payload.put("guid", guid);
                payload.put("mid", CorePlugin.getMID());
                StudioAnalytics.getInstance().sendEvent(new AnalyticsEvent(STUDIO_ENROLL, STUDIO_ENROLL, payload));
            }
            IEclipsePreferences store = scope.getNode("com.aptana.usage");
            store.putBoolean("has_enrolled", true);
            try {
                store.flush();
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 4);
    }

    public static void removeResourceListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
    }

    public static String getApplicationId() {
        String id = Platform.getPreferencesService().getString("com.aptana.usage", "ide-id", null, null);
        boolean save = false;
        if (id == null && (id = Platform.getPreferencesService().getString("com.aptana.db", "ide-id", null, null)) != null) {
            save = true;
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
            save = true;
        }
        if (save) {
            IEclipsePreferences prefs = EclipseUtil.configurationScope().getNode("com.aptana.usage");
            prefs.put("ide-id", id);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        return id;
    }

    private static void sendProjectDeleteEvent(IProject project, String projectType) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", project.getName());
        StudioAnalytics.getInstance().sendEvent(new FeatureEvent("project.delete." + projectType, payload));
    }
}

