/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.AnalyticsLogger;
import com.aptana.usage.IAnalyticsUser;
import com.aptana.usage.IAnalyticsUserManager;
import com.aptana.usage.Messages;
import com.aptana.usage.UsagePlugin;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioAnalytics {
    private static final String ANALYTICS_URL;
    private static final int TIMEOUT = 5000;
    private static StudioAnalytics instance;
    private int responseCode = 0;
    private Object lock = new Object();

    static {
        String url = EclipseUtil.getSystemProperty((String)"studio.analyticsURL");
        ANALYTICS_URL = url == null ? "https://api.appcelerator.net/p/v1/app-track" : url;
    }

    public static synchronized StudioAnalytics getInstance() {
        if (instance == null) {
            instance = new StudioAnalytics();
        }
        return instance;
    }

    public void sendEvent(final AnalyticsEvent event) {
        if (Platform.inDevelopmentMode() && !EclipseUtil.isTesting()) {
            return;
        }
        Job job = new Job("Sending Analytics Ping ..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected IStatus run(IProgressMonitor monitor) {
                IAnalyticsUser user;
                block8: {
                    block7: {
                        IAnalyticsUserManager userManager = AnalyticsEvent.getUserManager();
                        if (userManager == null) {
                            int n = StudioAnalytics.this.sendPing(event, null);
                            StudioAnalytics.this.responseCode = n;
                            if (StudioAnalytics.isValidResponse(n)) return Status.OK_STATUS;
                            AnalyticsLogger.getInstance().logEvent(event);
                            return Status.OK_STATUS;
                        }
                        user = userManager.getUser();
                        if (user == null || !user.isOnline()) break block7;
                        int n = StudioAnalytics.this.sendPing(event, user);
                        StudioAnalytics.this.responseCode = n;
                        if (StudioAnalytics.isValidResponse(n)) break block8;
                    }
                    AnalyticsLogger.getInstance().logEvent(event);
                    return Status.OK_STATUS;
                }
                Object object = StudioAnalytics.this.lock;
                synchronized (object) {
                    List<AnalyticsEvent> events = AnalyticsLogger.getInstance().getEvents();
                    Collections.sort(events, new AnalyticsEventComparator());
                    for (AnalyticsEvent aEvent : events) {
                        int n = StudioAnalytics.this.sendPing(aEvent, user);
                        StudioAnalytics.this.responseCode = n;
                        if (!StudioAnalytics.isValidResponse(n)) {
                            return Status.OK_STATUS;
                        }
                        AnalyticsLogger.getInstance().clearEvent(aEvent);
                    }
                    return Status.OK_STATUS;
                }
            }
        };
        job.setSystem(!EclipseUtil.showSystemJobs());
        job.setPriority(40);
        job.schedule();
        if (EclipseUtil.isTesting()) {
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getLastResponseCode() {
        return this.responseCode;
    }

    /*
     * Loose catch block
     */
    private int sendPing(AnalyticsEvent event, IAnalyticsUser user) {
        int n;
        FilterOutputStream output;
        HttpURLConnection connection;
        block19: {
            int code;
            connection = null;
            output = null;
            URL url = new URL(ANALYTICS_URL);
            connection = (HttpURLConnection)url.openConnection();
            if (user != null) {
                connection.setRequestProperty("Cookie", user.getCookie());
            }
            connection.setRequestProperty("User-Agent", AnalyticsEvent.getUserAgent());
            connection.setDoOutput(true);
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("POST");
            output = new DataOutputStream(connection.getOutputStream());
            String data = event.getEventString();
            ((DataOutputStream)output).writeBytes(data);
            ((DataOutputStream)output).flush();
            if (IdeLog.isTraceEnabled((Plugin)UsagePlugin.getDefault(), (String)"com.aptana.usage/debug/usage")) {
                IdeLog.logTrace((Plugin)UsagePlugin.getDefault(), (String)MessageFormat.format("Sending usage: {0}, {1}", url, data));
            }
            if ((code = connection.getResponseCode()) == 401 || code == 403) {
                UsagePlugin.logError(MessageFormat.format(Messages.StudioAnalytics_connection_unauthorized, Integer.toString(code)));
            } else if (code < 200 || code > 205) {
                UsagePlugin.logError(MessageFormat.format(Messages.StudioAnalytics_connection_failed, Integer.toString(code)));
            }
            n = code;
            if (output == null) break block19;
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        if (connection != null) {
            connection.disconnect();
        }
        return n;
        catch (Exception e) {
            block20: {
                try {
                    UsagePlugin.logError(e);
                    if (output == null) break block20;
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                    throw throwable;
                }
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
            return 503;
        }
    }

    private static boolean isValidResponse(int code) {
        return code < 500 || code >= 510;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnalyticsEventComparator
    implements Comparator<AnalyticsEvent> {
        private static String PROJECT_CREATE = "project.create";
        private static String PROJECT_DELETE = "project.delete";

        private AnalyticsEventComparator() {
        }

        @Override
        public int compare(AnalyticsEvent o1, AnalyticsEvent o2) {
            return this.calculatePriority(o1) - this.calculatePriority(o2);
        }

        private int calculatePriority(AnalyticsEvent event) {
            String eventName = event.getEventName();
            if (eventName.startsWith(PROJECT_CREATE)) {
                return -1;
            }
            if (eventName.startsWith(PROJECT_DELETE)) {
                return 1;
            }
            return 0;
        }
    }
}

