/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.AptanaDB;
import com.aptana.usage.PingStartup;
import com.aptana.usage.StudioAnalytics;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class UsagePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.usage";
    public static final String OLD_PLUGIN_ID = "com.aptana.db";
    private static final String STUDIO_START = "ti.start";
    private static final String STUDIO_END = "ti.end";
    private static UsagePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (!EclipseUtil.isTesting()) {
            StudioAnalytics.getInstance().sendEvent(new AnalyticsEvent(STUDIO_START, STUDIO_START, null));
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (!EclipseUtil.isTesting()) {
            StudioAnalytics.getInstance().sendEvent(new AnalyticsEvent(STUDIO_END, STUDIO_END, null));
        }
        if (!Platform.inDevelopmentMode()) {
            AptanaDB.getInstance().shutdown();
        }
        PingStartup.removeResourceListener();
        plugin = null;
        super.stop(context);
    }

    public static UsagePlugin getDefault() {
        return plugin;
    }

    public static void logError(String message) {
        if (Platform.inDevelopmentMode()) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)message);
        }
    }

    public static void logError(Exception e) {
        if (Platform.inDevelopmentMode()) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (Throwable)e);
        }
    }
}

