/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import com.aptana.usage.IAnalyticsUserManager;
import com.aptana.usage.UsagePlugin;
import com.aptana.usage.internal.AnalyticsInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class AnalyticsInfoManager {
    private static final String EXTENSION_POINT_ID = "analyticsInfo";
    private static final String ELEMENT_ANALYTICS = "analytics";
    private static final String ELEMENT_INFO = "info";
    private static final String ATTR_ID = "id";
    private static final String ATTR_INFO = "info";
    private static final String ATTR_OVERRIDES = "overrides";
    private static final String ATTR_APP_ID = "appId";
    private static final String ATTR_APP_NAME = "appName";
    private static final String ATTR_APP_GUID = "appGuid";
    private static final String ATTR_VERSION_PLUGIN_ID = "versionPluginId";
    private static final String ATTR_USER_AGENT = "userAgent";
    private static final String ATTR_USER_MANAGER = "userManager";
    private static AnalyticsInfoManager instance;
    private Map<String, Analytics> fAnalyticsMap;

    public static synchronized AnalyticsInfoManager getInstance() {
        if (instance == null) {
            instance = new AnalyticsInfoManager();
        }
        return instance;
    }

    public AnalyticsInfo getInfo(String id) {
        Analytics analytics = this.fAnalyticsMap.get(id);
        return analytics == null ? null : analytics.info;
    }

    private AnalyticsInfoManager() {
        this.loadExtension();
    }

    private void loadExtension() {
        final HashMap analyticsInfoMap = new HashMap();
        final HashMap<String, Analytics> analyticsMap = new HashMap<String, Analytics>();
        EclipseUtil.processConfigurationElements((String)"com.aptana.usage", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String name = element.getName();
                if ("info".equals(name)) {
                    String appId = element.getAttribute(AnalyticsInfoManager.ATTR_APP_ID);
                    if (StringUtil.isEmpty((String)appId)) {
                        return;
                    }
                    String appName = element.getAttribute(AnalyticsInfoManager.ATTR_APP_NAME);
                    if (StringUtil.isEmpty((String)appName)) {
                        return;
                    }
                    String appGuid = element.getAttribute(AnalyticsInfoManager.ATTR_APP_GUID);
                    if (StringUtil.isEmpty((String)appGuid)) {
                        return;
                    }
                    String versionPluginId = element.getAttribute(AnalyticsInfoManager.ATTR_VERSION_PLUGIN_ID);
                    if (StringUtil.isEmpty((String)versionPluginId)) {
                        return;
                    }
                    String userAgent = element.getAttribute(AnalyticsInfoManager.ATTR_USER_AGENT);
                    if (StringUtil.isEmpty((String)userAgent)) {
                        return;
                    }
                    IAnalyticsUserManager userManager = null;
                    String userManagerClass = element.getAttribute(AnalyticsInfoManager.ATTR_USER_MANAGER);
                    if (!StringUtil.isEmpty((String)userManagerClass)) {
                        try {
                            Object clazz = element.createExecutableExtension(AnalyticsInfoManager.ATTR_USER_MANAGER);
                            if (clazz instanceof IAnalyticsUserManager) {
                                userManager = (IAnalyticsUserManager)clazz;
                            }
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (Throwable)e);
                        }
                    }
                    analyticsInfoMap.put(appId, new AnalyticsInfo(appId, appName, appGuid, versionPluginId, userAgent, userManager));
                } else if (AnalyticsInfoManager.ELEMENT_ANALYTICS.equals(name)) {
                    String id = element.getAttribute(AnalyticsInfoManager.ATTR_ID);
                    if (StringUtil.isEmpty((String)id)) {
                        return;
                    }
                    String infoId = element.getAttribute("info");
                    if (StringUtil.isEmpty((String)infoId)) {
                        return;
                    }
                    AnalyticsInfo info = (AnalyticsInfo)analyticsInfoMap.get(infoId);
                    if (info == null) {
                        return;
                    }
                    String overridesId = element.getAttribute(AnalyticsInfoManager.ATTR_OVERRIDES);
                    analyticsMap.put(id, new Analytics(info, overridesId));
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newInOrderSet((Object[])new String[]{"info", AnalyticsInfoManager.ELEMENT_ANALYTICS});
            }
        });
        for (Analytics analytics : analyticsMap.values()) {
            if (analytics.overridesId == null || !analyticsMap.containsKey(analytics.overridesId)) continue;
            analyticsMap.put(analytics.overridesId, analytics);
        }
        this.fAnalyticsMap = new HashMap<String, Analytics>(analyticsMap);
    }

    private static class Analytics {
        public AnalyticsInfo info;
        public String overridesId;

        private Analytics(AnalyticsInfo info, String overridesId) {
            this.info = info;
            this.overridesId = overridesId;
        }
    }
}

