/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Struct"}, parent="Object")
public class Struct
extends RubyObject
implements StructLayout.Storage {
    private final StructLayout layout;
    private final Object[] referenceCache;
    private AbstractMemory memory;
    private IRubyObject[] valueCache;

    public static RubyClass createStructClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = runtime2.defineClassUnder("Struct", runtime2.getObject(), Allocator.INSTANCE, module);
        result2.defineAnnotatedMethods(Struct.class);
        result2.defineAnnotatedConstants(Struct.class);
        return result2;
    }

    Struct(Ruby runtime2) {
        this(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Struct"));
    }

    Struct(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, Struct.getStructLayout(runtime2, klass), null);
    }

    Struct(Ruby runtime2, RubyClass klass, StructLayout layout2, IRubyObject memory) {
        super(runtime2, klass);
        this.layout = layout2;
        if (memory != null && !(memory instanceof AbstractMemory)) {
            throw runtime2.newTypeError("wrong argument type " + memory.getMetaClass().getName() + " (expected Pointer or Buffer)");
        }
        this.memory = (AbstractMemory)memory;
        this.referenceCache = new IRubyObject[layout2.getReferenceFieldCount()];
    }

    static final boolean isStruct(Ruby runtime2, RubyClass klass) {
        return klass.isKindOfModule(runtime2.fastGetModule("FFI").getClass("Struct"));
    }

    static final int getStructSize(Ruby runtime2, IRubyObject structClass) {
        return Struct.getStructLayout(runtime2, structClass).getSize();
    }

    static final StructLayout getStructLayout(Ruby runtime2, IRubyObject structClass) {
        if (!(structClass instanceof RubyClass)) {
            throw runtime2.newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected subclass of Struct");
        }
        try {
            StructLayout layout2 = (StructLayout)((RubyClass)structClass).fastGetInstanceVariable("@layout");
            if (layout2 == null) {
                throw runtime2.newRuntimeError("No struct layout set for " + ((RubyClass)structClass).getName());
            }
            return layout2;
        }
        catch (RaiseException ex) {
            throw runtime2.newRuntimeError("No layout set for struct " + ((RubyClass)structClass).getName());
        }
        catch (ClassCastException ex) {
            throw runtime2.newRuntimeError("Invalid layout set for struct " + ((RubyClass)structClass).getName());
        }
    }

    static final Struct newStruct(Ruby runtime2, RubyClass klass, IRubyObject ptr) {
        return new Struct(runtime2, klass, Struct.getStructLayout(runtime2, klass), ptr);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.memory = MemoryPointer.allocate(context.getRuntime(), this.layout.getSize(), 1, true);
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject ptr) {
        if (!(ptr instanceof AbstractMemory)) {
            throw context.getRuntime().newTypeError("wrong argument type " + ptr.getMetaClass().getName() + " (expected Pointer or Buffer)");
        }
        if (((AbstractMemory)ptr).getSize() < (long)this.layout.getSize()) {
            throw context.getRuntime().newArgumentError("memory object has insufficient space for " + this.getMetaClass().getName());
        }
        this.memory = (AbstractMemory)ptr;
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (other == this) {
            return this;
        }
        if (!(other instanceof Struct)) {
            throw context.getRuntime().newTypeError("not an instance of Struct");
        }
        Struct orig = (Struct)other;
        this.memory = (AbstractMemory)orig.getMemory().slice(context.getRuntime(), 0L, this.layout.getSize()).dup();
        System.arraycopy(orig.referenceCache, 0, this.referenceCache, 0, this.referenceCache.length);
        return this;
    }

    private static final Struct allocateStruct(ThreadContext context, IRubyObject klass, int flags) {
        Ruby runtime2 = context.getRuntime();
        StructLayout layout2 = Struct.getStructLayout(runtime2, klass);
        return new Struct(runtime2, (RubyClass)klass, layout2, new Buffer(runtime2, layout2.getSize(), flags));
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject getFieldValue(ThreadContext context, IRubyObject fieldName) {
        return this.layout.getValue(context, fieldName, this, this.getMemory());
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject setFieldValue(ThreadContext context, IRubyObject fieldName, IRubyObject fieldValue) {
        this.layout.putValue(context, fieldName, this, this.getMemory(), fieldValue);
        return fieldValue;
    }

    @JRubyMethod(name={"cspec", "layout"})
    public IRubyObject getLayout(ThreadContext context) {
        return this.layout;
    }

    @JRubyMethod(name={"pointer"})
    public IRubyObject pointer(ThreadContext context) {
        return this.getMemory();
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        return this.layout.members(context);
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getMemory().getMemoryIO().isNull());
    }

    @JRubyMethod(name={"order"}, required=0)
    public final IRubyObject order(ThreadContext context) {
        return context.getRuntime().newSymbol(this.getMemoryIO().order().equals(ByteOrder.LITTLE_ENDIAN) ? "little" : "big");
    }

    @JRubyMethod(name={"order"}, required=1)
    public final IRubyObject order(ThreadContext context, IRubyObject byte_order) {
        ByteOrder order2 = Util.parseByteOrder(context.getRuntime(), byte_order);
        return new Struct(context.getRuntime(), this.getMetaClass(), this.layout, this.getMemory().order(context.getRuntime(), order2));
    }

    public final AbstractMemory getMemory() {
        return this.memory != null ? this.memory : (this.memory = MemoryPointer.allocate(this.getRuntime(), this.layout.getSize(), 1, true));
    }

    final MemoryIO getMemoryIO() {
        return this.getMemory().getMemoryIO();
    }

    public final IRubyObject getCachedValue(StructLayout.Member member) {
        return this.valueCache != null ? this.valueCache[this.layout.getCacheableFieldIndex(member)] : null;
    }

    public final void putCachedValue(StructLayout.Member member, IRubyObject value2) {
        if (this.valueCache == null) {
            this.valueCache = new IRubyObject[this.layout.getCacheableFieldCount()];
        }
        this.valueCache[this.layout.getCacheableFieldIndex((StructLayout.Member)member)] = value2;
    }

    public void putReference(StructLayout.Member member, IRubyObject value2) {
        this.referenceCache[this.layout.getReferenceFieldIndex((StructLayout.Member)member)] = value2;
    }

    public void putReference(StructLayout.Member member, Object value2) {
        this.referenceCache[this.layout.getReferenceFieldIndex((StructLayout.Member)member)] = value2;
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Struct(runtime2, klass);
        }
    }
}

