/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonOccurrencesUpdater;
import com.aptana.editor.common.CommonSourceViewerConfiguration;
import com.aptana.editor.common.Messages;
import com.aptana.editor.common.UntitledFileStorageEditorInput;
import com.aptana.editor.common.actions.FilterThroughCommandAction;
import com.aptana.editor.common.actions.FoldingActionsGroup;
import com.aptana.editor.common.dnd.SnippetTransfer;
import com.aptana.editor.common.extensions.FindBarEditorExtension;
import com.aptana.editor.common.extensions.IThemeableEditor;
import com.aptana.editor.common.extensions.ThemeableEditorExtension;
import com.aptana.editor.common.internal.AbstractFoldingEditor;
import com.aptana.editor.common.internal.peer.CharacterPairMatcher;
import com.aptana.editor.common.internal.peer.PeerCharacterCloser;
import com.aptana.editor.common.internal.scripting.CommandElementsProvider;
import com.aptana.editor.common.outline.CommonOutlinePage;
import com.aptana.editor.common.properties.CommonEditorPropertySheetPage;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.common.text.reconciler.RubyRegexpFolder;
import com.aptana.editor.common.viewer.CommonProjectionViewer;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.scripting.keybindings.ICommandElementsProvider;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.CommonLineNumberChangeRulerColumn;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractThemeableEditor
extends AbstractFoldingEditor
implements IThemeableEditor {
    private static final char[] DEFAULT_PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"'};
    private ICommandElementsProvider fCommandElementsProvider;
    private CommonOutlinePage fOutlinePage;
    private boolean fCursorChangeListened;
    private SelectionChangedListener fSelectionChangedListener;
    private FindBarEditorExtension fThemeableEditorFindBarExtension;
    private ThemeableEditorExtension fThemeableEditorColorsExtension;
    private IPropertyChangeListener fThemeListener;
    private PeerCharacterCloser fPeerCharacterCloser;
    private FoldingActionsGroup foldingActionsGroup;
    private ControlListener fWordWrapControlListener;
    private CommonOccurrencesUpdater occurrencesUpdater;
    private Job linkWithEditorJob;
    protected boolean outlineAutoExpanded;
    private long lastModificationStamp = -1L;
    private IParseRootNode lastAstForModificationStamp;
    private Object modificationStampLock = new Object();

    protected AbstractThemeableEditor() {
        this.fThemeableEditorFindBarExtension = new FindBarEditorExtension((IAdaptable)this);
        this.fThemeableEditorColorsExtension = new ThemeableEditorExtension(this);
    }

    public final ISourceViewer getISourceViewer() {
        return super.getSourceViewer();
    }

    public final IVerticalRuler getIVerticalRuler() {
        return super.getVerticalRuler();
    }

    public void createPartControl(Composite parent) {
        this.fThemeableEditorColorsExtension.setParent(parent);
        Composite findBarComposite = this.fThemeableEditorFindBarExtension.createFindBarComposite(parent);
        Assert.isNotNull((Object)findBarComposite);
        super.createPartControl(findBarComposite);
        this.fThemeableEditorFindBarExtension.createFindBar(this.getSourceViewer());
        this.fThemeableEditorColorsExtension.overrideThemeColors();
        this.fPeerCharacterCloser = new PeerCharacterCloser((ITextViewer)this.getSourceViewer());
        this.fPeerCharacterCloser.install();
        this.fPeerCharacterCloser.setAutoInsertEnabled(this.getPreferenceStore().getBoolean("com.aptana.editor.common.editorPeerCharacterClose"));
        this.fPeerCharacterCloser.setAutoWrapEnabled(this.getPreferenceStore().getBoolean("com.aptana.editor.common.editorWrapSelection"));
        this.fCursorChangeListened = true;
        this.fSelectionChangedListener = new SelectionChangedListener();
        this.fSelectionChangedListener.install(this.getSelectionProvider());
        this.fThemeListener = new PropertyChangeListener();
        ThemePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fThemeListener);
        this.fThemeableEditorFindBarExtension.activateContexts(new String[]{"com.aptana.editor.context", "com.aptana.scripting.context"});
        if (this.isWordWrapEnabled()) {
            this.setWordWrapEnabled(true);
        }
        this.installOccurrencesUpdater();
    }

    protected void installOccurrencesUpdater() {
        this.occurrencesUpdater = new CommonOccurrencesUpdater(this);
        this.occurrencesUpdater.initialize(this.getPreferenceStore());
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        super.initializeDragAndDrop(viewer);
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService == null) {
            return;
        }
        StyledText st = viewer.getTextWidget();
        DropTarget dropTarget = (DropTarget)st.getData("DropTarget");
        if (dropTarget != null) {
            Object[] transfers = dropTarget.getTransfer();
            List allTransfers = CollectionsUtil.newList((Object[])transfers);
            allTransfers.add(SnippetTransfer.getInstance());
            dropTarget.setTransfer(allTransfers.toArray(new Transfer[allTransfers.size()]));
            dropTarget.addDropListener((DropTargetListener)new SnippetDropTargetListener());
        } else {
            dndService.addMergedDropTarget((Control)st, 1, new Transfer[]{SnippetTransfer.getInstance()}, (DropTargetListener)new SnippetDropTargetListener());
        }
    }

    public Object getAdapter(Class adapter) {
        Object adaptable;
        if (SourceViewerConfiguration.class == adapter) {
            return this.getSourceViewerConfiguration();
        }
        if (IContentOutlinePage.class == adapter) {
            return this.getOutlinePage();
        }
        if (ISourceViewer.class == adapter || ITextViewer.class == adapter) {
            return this.getSourceViewer();
        }
        if (IPreferenceStore.class == adapter) {
            return this.getPluginPreferenceStore();
        }
        if (this.fThemeableEditorFindBarExtension != null && (adaptable = this.fThemeableEditorFindBarExtension.getFindBarDecoratorAdapter(adapter)) != null) {
            return adaptable;
        }
        if (adapter == IPropertySheetPage.class) {
            return new CommonEditorPropertySheetPage(this.getSourceViewer());
        }
        return super.getAdapter(adapter);
    }

    public CommonOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = this.createOutlinePage();
        }
        return this.fOutlinePage;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return null;
    }

    public ILabelProvider getOutlineLabelProvider() {
        return null;
    }

    protected CommonOutlinePage createOutlinePage() {
        ITreeContentProvider outlineContentProvider = this.getOutlineContentProvider();
        ILabelProvider outlineLabelProvider = this.getOutlineLabelProvider();
        if (outlineContentProvider == null || outlineLabelProvider == null) {
            return null;
        }
        CommonOutlinePage outline = new CommonOutlinePage(this, this.getOutlinePreferenceStore());
        outline.setContentProvider(outlineContentProvider);
        outline.setLabelProvider(outlineLabelProvider);
        return outline;
    }

    protected abstract IPreferenceStore getPluginPreferenceStore();

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        super.initializeLineNumberRulerColumn(rulerColumn);
        if (rulerColumn instanceof CommonLineNumberChangeRulerColumn) {
            ((CommonLineNumberChangeRulerColumn)rulerColumn).showLineNumbers(this.isLineNumberVisible());
        }
        this.fThemeableEditorColorsExtension.initializeLineNumberRulerColumn(rulerColumn);
    }

    private boolean isLineNumberVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null ? store.getBoolean("lineNumberRuler") : false;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        CommonProjectionViewer viewer = new CommonProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles){

            public Object getAdapter(Class adapter) {
                if (AbstractThemeableEditor.class == adapter || ITextEditor.class == adapter) {
                    return AbstractThemeableEditor.this;
                }
                return super.getAdapter(adapter);
            }
        };
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.fThemeableEditorColorsExtension.createBackgroundPainter((ISourceViewer)viewer);
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        super.configureSourceViewerDecorationSupport(support);
        support.setCharacterPairMatcher((ICharacterPairMatcher)new CharacterPairMatcher(this.getPairMatchingCharacters()));
        support.setMatchingCharacterPainterPreferenceKeys("com.aptana.editor.common.enableCharacterPairColoring", "com.aptana.editor.common.characterPairColor");
    }

    public char[] getPairMatchingCharacters() {
        return DEFAULT_PAIR_MATCHING_CHARS;
    }

    public void dispose() {
        try {
            SourceViewerConfiguration svc = this.getSourceViewerConfiguration();
            if (svc instanceof CommonSourceViewerConfiguration) {
                ((CommonSourceViewerConfiguration)svc).dispose();
            }
            if (this.fWordWrapControlListener != null) {
                StyledText textWidget;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null && (textWidget = sourceViewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                    textWidget.removeControlListener(this.fWordWrapControlListener);
                }
                this.fWordWrapControlListener = null;
            }
            if (this.occurrencesUpdater != null) {
                this.occurrencesUpdater.dispose();
                this.occurrencesUpdater = null;
            }
            if (this.fSelectionChangedListener != null) {
                this.fSelectionChangedListener.uninstall(this.getSelectionProvider());
                this.fSelectionChangedListener = null;
            }
            if (this.fThemeListener != null) {
                ThemePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fThemeListener);
                this.fThemeListener = null;
            }
            if (this.fThemeableEditorColorsExtension != null) {
                this.fThemeableEditorColorsExtension.dispose();
                this.fThemeableEditorColorsExtension = null;
            }
            if (this.fThemeableEditorFindBarExtension != null) {
                this.fThemeableEditorFindBarExtension.dispose();
                this.fThemeableEditorFindBarExtension = null;
            }
            if (this.foldingActionsGroup != null) {
                this.foldingActionsGroup.dispose();
                this.foldingActionsGroup = null;
            }
            if (this.fOutlinePage != null) {
                this.fOutlinePage.dispose();
                this.fOutlinePage = null;
            }
            this.fCommandElementsProvider = null;
            this.fPeerCharacterCloser = null;
            IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
            if (dndService != null) {
                ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
                StyledText st = viewer.getTextWidget();
                dndService.removeMergedDropTarget((Control)st);
            }
        }
        finally {
            super.dispose();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setEditorContextMenuId(this.getSite().getId());
    }

    protected void initializeEditor() {
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()}));
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.getEditorInput() instanceof UntitledFileStorageEditorInput) {
            this.performSaveAs(progressMonitor);
        } else {
            super.doSave(progressMonitor);
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        progressMonitor = progressMonitor == null ? new NullProgressMonitor() : progressMonitor;
        IEditorInput input = this.getEditorInput();
        if (input instanceof UntitledFileStorageEditorInput) {
            Shell shell = this.getSite().getShell();
            boolean saveToProject = false;
            boolean byPassDialog = Platform.getPreferencesService().getBoolean("com.aptana.editor.common", "com.aptana.editor.common.rememberUntitledFileSaveType", false, null);
            if (byPassDialog) {
                saveToProject = Platform.getPreferencesService().getBoolean("com.aptana.editor.common", "com.aptana.editor.common.saveUntitledFileToProject", false, null);
            } else {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, Messages.AbstractThemeableEditor_SaveToggleDialog_Title, null, Messages.AbstractThemeableEditor_SaveToggleDialog_Message, 0, new String[]{Messages.AbstractThemeableEditor_SaveToggleDialog_LocalFilesystem, Messages.AbstractThemeableEditor_SaveToggleDialog_Project}, 0, null, false);
                int code = dialog.open();
                if (code == -1) {
                    return;
                }
                boolean bl = saveToProject = code != 256;
                if (dialog.getToggleState()) {
                    IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
                    prefs.putBoolean("com.aptana.editor.common.rememberUntitledFileSaveType", true);
                    prefs.putBoolean("com.aptana.editor.common.saveUntitledFileToProject", saveToProject);
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
            if (!saveToProject) {
                boolean success;
                block24: {
                    IFileStore fileStore;
                    FileDialog fileDialog = new FileDialog(shell, 8192);
                    String path = fileDialog.open();
                    if (path == null) {
                        progressMonitor.setCanceled(true);
                        return;
                    }
                    File localFile = new File(path);
                    if (localFile.exists() && !MessageDialog.openConfirm((Shell)shell, (String)Messages.AbstractThemeableEditor_ConfirmOverwrite_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_ConfirmOverwrite_Message, path))) {
                        progressMonitor.setCanceled(true);
                    }
                    try {
                        fileStore = EFS.getStore((URI)localFile.toURI());
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        MessageDialog.openError((Shell)shell, (String)Messages.AbstractThemeableEditor_Error_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_Error_Message, path));
                        return;
                    }
                    IDocumentProvider provider = this.getDocumentProvider();
                    if (provider == null) {
                        return;
                    }
                    IFile file = this.getWorkspaceFile(fileStore);
                    Object newInput = file != null ? new FileEditorInput(file) : new FileStoreEditorInput(fileStore);
                    success = false;
                    try {
                        try {
                            provider.aboutToChange(newInput);
                            provider.saveDocument(progressMonitor, newInput, provider.getDocument((Object)input), true);
                            success = true;
                        }
                        catch (CoreException e) {
                            IStatus status = e.getStatus();
                            if (status == null || status.getSeverity() != 8) {
                                MessageDialog.openError((Shell)shell, (String)Messages.AbstractThemeableEditor_Error_Title, (String)MessageFormat.format(Messages.AbstractThemeableEditor_Error_Message, path));
                            }
                            provider.changed(newInput);
                            if (success) {
                                this.setInput((IEditorInput)newInput);
                            }
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        provider.changed(newInput);
                        if (success) {
                            this.setInput((IEditorInput)newInput);
                        }
                        throw throwable;
                    }
                    provider.changed(newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                }
                progressMonitor.setCanceled(!success);
            } else {
                super.performSaveAs(progressMonitor);
            }
        } else {
            super.performSaveAs(progressMonitor);
        }
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = workspaceRoot.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public String getContentType() {
        try {
            IContentType contentType = ((TextFileDocumentProvider)this.getDocumentProvider()).getContentType((Object)this.getEditorInput());
            if (contentType != null) {
                return contentType.getId();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
        if (viewer == null || viewer.getTextWidget() == null) {
            return;
        }
        super.initializeViewerColors(viewer);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        super.handlePreferenceStoreChanged(event);
        this.fThemeableEditorColorsExtension.handlePreferenceStoreChanged(event);
        if (property.equals("lineNumberRuler")) {
            ((CommonLineNumberChangeRulerColumn)this.fLineNumberRulerColumn).showLineNumbers(this.isLineNumberVisible());
        } else if (property.equals("com.aptana.editor.common.editorPeerCharacterClose")) {
            this.fPeerCharacterCloser.setAutoInsertEnabled(Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue())));
        } else if (property.equals("com.aptana.editor.common.editorWrapSelection")) {
            this.fPeerCharacterCloser.setAutoWrapEnabled(Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue())));
        } else if (property.equals("com.aptana.editor.common.enableFolding")) {
            SourceViewerConfiguration config = this.getSourceViewerConfiguration();
            if (config instanceof CommonSourceViewerConfiguration) {
                ((CommonSourceViewerConfiguration)config).forceReconcile();
            }
        } else if ("com.aptana.editor.common.useGlobalDefaults".equals(property)) {
            IPreferenceStore store = this.getPreferenceStore();
            if (store != null) {
                this.getSourceViewer().getTextWidget().setTabs(store.getInt("tabWidth"));
            }
            if (this.isTabsToSpacesConversionEnabled()) {
                this.installTabsToSpacesConverter();
            } else {
                this.uninstallTabsToSpacesConverter();
            }
            return;
        }
    }

    public Object computeHighlightedOutlineNode(int caretOffset) {
        return this.getOutlineElementAt(caretOffset);
    }

    public int getCaretOffset() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return -1;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            return extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        }
        int offset = sourceViewer.getVisibleRegion().getOffset();
        return offset + styledText.getCaretOffset();
    }

    public void select(IRange element, boolean checkIfOutlineActive) {
        try {
            if (element != null && (!checkIfOutlineActive || this.isOutlinePageActive())) {
                this.fCursorChangeListened = false;
                this.setSelectedElement(element);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setSelectedElement(IRange element) {
        if (element == null) {
            return;
        }
        try {
            int offset = element.getStartingOffset();
            int length = element.getLength();
            this.setHighlightRange(offset, length, false);
            this.selectAndReveal(offset, length);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void selectionChanged() {
        try {
            if (this.fCursorChangeListened) {
                if (this.hasOutlinePageCreated() && this.isLinkedWithEditor()) {
                    final int caretOffset = this.getCaretOffset();
                    if (this.linkWithEditorJob != null) {
                        this.linkWithEditorJob.cancel();
                    }
                    this.linkWithEditorJob = new Job("Computing Outline node to select..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            final Object outlineNode = AbstractThemeableEditor.this.computeHighlightedOutlineNode(caretOffset);
                            UIUtils.getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    AbstractThemeableEditor.this.getOutlinePage().select(outlineNode);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    this.linkWithEditorJob.setSystem(true);
                    this.linkWithEditorJob.schedule();
                }
            } else {
                this.fCursorChangeListened = true;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void createActions() {
        super.createActions();
        this.setAction("com.aptana.editor.common.scripting.commands.FilterThroughCommand", FilterThroughCommandAction.create((ITextEditor)this));
        this.fThemeableEditorFindBarExtension.createFindBarActions();
        TextOperationAction action = new TextOperationAction(Messages.getBundleForConstructedKeys(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("com.aptana.editor.commands.Format");
        this.setAction("com.aptana.editor.action.Format", (IAction)action);
        this.markAsStateDependentAction("com.aptana.editor.action.Format", true);
        this.markAsSelectionDependentAction("com.aptana.editor.action.Format", true);
        this.foldingActionsGroup = new FoldingActionsGroup((ITextEditor)this);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(Messages.Folding_GroupName, "folding");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        this.getFoldingActionsGroup().fillMenu((IMenuManager)foldingMenu);
    }

    synchronized ICommandElementsProvider getCommandElementsProvider() {
        if (this.fCommandElementsProvider == null) {
            this.fCommandElementsProvider = new CommandElementsProvider((ITextEditor)this, (ITextViewer)this.getSourceViewer());
        }
        return this.fCommandElementsProvider;
    }

    protected String getCursorPosition() {
        String raw = null;
        try {
            raw = super.getCursorPosition();
            StringTokenizer tokenizer = new StringTokenizer(raw, " :");
            String line = tokenizer.nextToken();
            String column = tokenizer.nextToken();
            return MessageFormat.format(Messages.AbstractThemeableEditor_CursorPositionLabel, line, column);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return raw;
        }
    }

    protected Object getOutlineElementAt(int caret) {
        IParseNode astNode;
        block5: {
            block4: {
                try {
                    if (this.fOutlinePage != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    return null;
                }
            }
            astNode = this.getASTNodeAt(caret, this.fOutlinePage.getCurrentAst());
            if (astNode != null) break block5;
            return null;
        }
        return this.fOutlinePage.getOutlineItem(astNode);
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return CommonEditorPlugin.getDefault().getPreferenceStore();
    }

    protected IDocument getDocument() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getDocument((Object)this.getEditorInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetInput(IEditorInput input) throws CoreException {
        Object object = this.modificationStampLock;
        synchronized (object) {
            this.lastModificationStamp = -1L;
            this.lastAstForModificationStamp = null;
        }
        super.doSetInput(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseRootNode getAST() {
        IDocument document;
        block11: {
            try {
                document = this.getDocument();
                if (document != null) break block11;
                return null;
            }
            catch (Exception e) {
                IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)e.getMessage(), (Throwable)e, (String)"com.aptana.editor.common/debug/ast");
                return null;
            }
        }
        long modificationStamp = -1L;
        if (document instanceof IDocumentExtension4) {
            Object object = this.modificationStampLock;
            synchronized (object) {
                IDocumentExtension4 iDocumentExtension = (IDocumentExtension4)document;
                modificationStamp = iDocumentExtension.getModificationStamp();
                if (modificationStamp != -1L && modificationStamp == this.lastModificationStamp) {
                    return this.lastAstForModificationStamp;
                }
            }
        }
        IParseRootNode ast = ParserPoolFactory.parse((String)this.getContentType(), (String)document.get()).getRootNode();
        Object object = this.modificationStampLock;
        synchronized (object) {
            this.lastAstForModificationStamp = ast;
            this.lastModificationStamp = modificationStamp;
            return this.lastAstForModificationStamp;
        }
    }

    protected IParseNode getASTNodeAt(int offset, IParseRootNode root) {
        block3: {
            try {
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                return null;
            }
        }
        return root.getNodeAtOffset(offset);
    }

    protected FoldingActionsGroup getFoldingActionsGroup() {
        return this.foldingActionsGroup;
    }

    private boolean isLinkedWithEditor() {
        return this.getOutlinePreferenceStore().getBoolean("com.aptana.editor.common.linkOutlineWithEditor");
    }

    private boolean isOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        return window.getPartService().getActivePart();
    }

    public boolean isTabsToSpacesConversionEnabled() {
        return super.isTabsToSpacesConversionEnabled();
    }

    public int getTabSize() {
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null) {
            return config.getTabWidth(this.getSourceViewer());
        }
        return 4;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean hasOutlinePageCreated() {
        return this.fOutlinePage != null;
    }

    public boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("com.aptana.editor.common.enableFolding");
    }

    public boolean isMarkingOccurrences() {
        IPreferenceStore store = this.getPreferenceStore();
        return store != null && store.getBoolean("com.aptana.editor.common.editorMarkOccurrences");
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new RubyRegexpFolder(this, document);
    }

    public boolean getWordWrapEnabled() {
        return this.getSourceViewer().getTextWidget().getWordWrap();
    }

    public void setWordWrapEnabled(boolean enabled) {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        if (textWidget.getWordWrap() != enabled) {
            textWidget.setWordWrap(enabled);
            this.fLineNumberRulerColumn.redraw();
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new CommonLineNumberChangeRulerColumn(this.getSharedColors());
        ((IChangeRulerColumn)this.fLineNumberRulerColumn).setHover((IAnnotationHover)this.createChangeHover());
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    private boolean isWordWrapEnabled() {
        return Platform.getPreferencesService().getBoolean("com.aptana.editor.common", "com.aptana.editor.common.enableWordWrap", false, null);
    }

    public void refreshOutline(final IParseRootNode ast) {
        if (!this.hasOutlinePageCreated()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CommonOutlinePage page = AbstractThemeableEditor.this.getOutlinePage();
                page.refresh(ast);
                if (!AbstractThemeableEditor.this.outlineAutoExpanded) {
                    page.expandToLevel(2);
                    AbstractThemeableEditor.this.outlineAutoExpanded = true;
                }
            }
        });
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AbstractThemeableEditor.this.handlePreferenceStoreChanged(event);
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)selectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AbstractThemeableEditor.this.selectionChanged();
        }
    }

    private class SnippetDropTargetListener
    extends DropTargetAdapter {
        private SnippetDropTargetListener() {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                SnippetElement snippet = (SnippetElement)event.data;
                CommandResult commandResult = CommandExecutionUtils.executeCommand((CommandElement)snippet, InvocationType.MENU, (ITextEditor)AbstractThemeableEditor.this);
                if (commandResult == null) {
                    BundleElement bundle = snippet.getOwningBundle();
                    String bundleName = bundle == null ? "Unknown bundle" : bundle.getDisplayName();
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)StringUtil.format((String)"Error executing command {0} in bundle {1}. Command returned null.", (Object[])new String[]{snippet.getDisplayName(), bundleName}), (String)"com.aptana.editor.common/debug/drag_drop");
                } else {
                    CommandExecutionUtils.processCommandResult((CommandElement)snippet, commandResult, (ITextEditor)AbstractThemeableEditor.this);
                    AbstractThemeableEditor.this.setFocus();
                }
            }
        }

        public void dragOver(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                event.feedback |= 8;
            }
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.data instanceof SnippetElement) {
                event.detail = 1;
            }
        }
    }
}

