/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.editor.common.CommonAnnotationModelFactory;
import com.aptana.editor.common.CommonEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public abstract class CommonDocumentProvider
extends TextFileDocumentProvider {
    public void connect(Object element) throws CoreException {
        super.connect(element);
        IDocument document = this.getDocument(element);
        if (document != null) {
            String fileName = null;
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                IFile file = input.getFile();
                fileName = file.getName();
            } else if (element instanceof IPathEditorInput) {
                IPathEditorInput input = (IPathEditorInput)element;
                fileName = input.getPath().lastSegment();
            } else if (element instanceof IURIEditorInput) {
                IURIEditorInput input = (IURIEditorInput)element;
                fileName = new Path(input.getURI().getPath()).lastSegment();
            }
            CommonEditorPlugin.getDefault().getDocumentScopeManager().setDocumentScope(document, this.getDefaultContentType(fileName), fileName);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new CommonAnnotationModelFactory().createAnnotationModel(file.getFullPath());
    }

    public void disconnect(Object element) {
        IDocumentPartitioner partitioner;
        IDocument document;
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo != null && fileInfo.fCount == 1 && (document = this.getDocument(element)) != null && (partitioner = document.getDocumentPartitioner()) != null) {
            partitioner.disconnect();
            document.setDocumentPartitioner(null);
        }
        super.disconnect(element);
    }

    protected abstract String getDefaultContentType(String var1);
}

