/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.FilenameDifferentiator;
import com.aptana.editor.common.internal.scripting.ContentTypeTranslation;
import com.aptana.editor.common.internal.scripting.DocumentScopeManager;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.spelling.SpellingPreferences;
import com.aptana.index.core.IndexPlugin;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.StudioAnalytics;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class CommonEditorPlugin
extends AbstractUIPlugin {
    public static final String SNIPPET = "/icons/snippet.png";
    public static final String COMMAND = "/icons/command.png";
    public static final String PLUGIN_ID = "com.aptana.editor.common";
    private static final String TEMPLATES = "com.aptana.editor.common.templates";
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final String COMMAND_ID = "com.aptana.editor.common.commands.toggleOutline";
    private static final String COMMAND_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String UID = Platform.getPreferencesService().getString("com.aptana.usage", "ide-id", null, null);
    private static CommonEditorPlugin plugin;
    private Map<ContextTypeRegistry, ContributionTemplateStore> fTemplateStoreMap;
    private FilenameDifferentiator differentiator;
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)part;
                String id = editorPart.getEditorSite().getId();
                HashMap<String, String> payload = new HashMap<String, String>();
                payload.put("instance", part.toString());
                if (UID != null) {
                    payload.put("uid", UID);
                }
                StudioAnalytics.getInstance().sendEvent((AnalyticsEvent)new FeatureEvent("editor.closed" + this.getLastSegment(id), payload));
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)part;
                String id = editorPart.getEditorSite().getId();
                HashMap<String, String> payload = new HashMap<String, String>();
                payload.put("instance", part.toString());
                if (UID != null) {
                    payload.put("uid", UID);
                }
                StudioAnalytics.getInstance().sendEvent((AnalyticsEvent)new FeatureEvent("editor.opened" + this.getLastSegment(id), payload));
            }
        }

        private String getLastSegment(String id) {
            if (id == null) {
                return "";
            }
            int index = id.lastIndexOf(".");
            return index < 0 ? "." + id : id.substring(index);
        }
    };
    private final IPerspectiveListener fPerspectiveListener = new IPerspectiveListener(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.setCommandState(this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null);
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            if (changeId.equals("viewHide")) {
                if (this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) == null) {
                    this.setCommandState(false);
                }
            } else if (changeId.equals("viewShow") && this.findView(page, CommonEditorPlugin.OUTLINE_VIEW_ID) != null) {
                this.setCommandState(true);
            }
        }

        private void setCommandState(boolean state) {
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = service.getCommand(CommonEditorPlugin.COMMAND_ID);
            State commandState = command.getState(CommonEditorPlugin.COMMAND_STATE);
            if ((Boolean)commandState.getValue() != state) {
                commandState.setValue((Object)state);
                service.refreshElements(CommonEditorPlugin.COMMAND_ID, null);
            }
        }

        protected IViewReference findView(IWorkbenchPage page, String viewId) {
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if (viewId.equals(ref.getId())) {
                    return ref;
                }
                ++n2;
            }
            return null;
        }
    };
    private final IWindowListener fWindowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.removePerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(CommonEditorPlugin.this.fPartListener);
            }
            window.addPerspectiveListener(CommonEditorPlugin.this.fPerspectiveListener);
        }
    };
    private DocumentScopeManager fDocumentScopeManager;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private SpellingPreferences spellingPreferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listenForThemeChanges();
        IndexPlugin.getDefault();
        this.differentiator = new FilenameDifferentiator();
        this.differentiator.schedule();
        this.spellingPreferences = new SpellingPreferences();
        new UIJob("adding part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.addPartListener();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void listenForThemeChanges() {
        UIJob job = new UIJob("Set occurrence colors to theme"){

            private void setOccurrenceColors() {
                IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors");
                Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
                prefs.put("OccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSearchResultColor()));
                try {
                    prefs.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CommonEditorPlugin.this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        if (event.getKey().equals("THEME_CHANGED")) {
                            this.setOccurrenceColors();
                        }
                    }
                };
                this.setOccurrenceColors();
                EclipseUtil.instanceScope().getNode("com.aptana.theme").addPreferenceChangeListener(CommonEditorPlugin.this.fThemeChangeListener);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(2000L);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fThemeChangeListener != null) {
                EclipseUtil.instanceScope().getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
                this.fThemeChangeListener = null;
            }
            this.differentiator.dispose();
            this.removePartListener();
            if (this.fDocumentScopeManager != null) {
                this.fDocumentScopeManager.dispose();
            }
            if (this.spellingPreferences != null) {
                this.spellingPreferences.dispose();
                this.spellingPreferences = null;
            }
        }
        finally {
            this.fDocumentScopeManager = null;
            this.differentiator = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static CommonEditorPlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(SNIPPET, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)SNIPPET));
        reg.put(COMMAND, CommonEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)COMMAND));
    }

    public Image getImageFromImageRegistry(String imageID) {
        return this.getImageRegistry().get(imageID);
    }

    public SpellingPreferences getSpellingPreferences() {
        return this.spellingPreferences;
    }

    public ContributionTemplateStore getTemplateStore(ContextTypeRegistry contextTypeRegistry) {
        ContributionTemplateStore store;
        if (this.fTemplateStoreMap == null) {
            this.fTemplateStoreMap = new HashMap<ContextTypeRegistry, ContributionTemplateStore>();
        }
        if ((store = this.fTemplateStoreMap.get(contextTypeRegistry)) == null) {
            store = new ContributionTemplateStore(contextTypeRegistry, this.getPreferenceStore(), TEMPLATES);
            try {
                store.load();
                this.fTemplateStoreMap.put(contextTypeRegistry, store);
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        return store;
    }

    public synchronized IDocumentScopeManager getDocumentScopeManager() {
        if (this.fDocumentScopeManager == null) {
            this.fDocumentScopeManager = new DocumentScopeManager();
        }
        return this.fDocumentScopeManager;
    }

    public IContentTypeTranslator getContentTypeTranslator() {
        return ContentTypeTranslation.getDefault();
    }

    private void addPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(this.fPartListener);
                    }
                    window.addPerspectiveListener(this.fPerspectiveListener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
            }
        }
        catch (Exception exception) {}
    }

    private void removePartListener() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {}
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IPartService partService = window.getPartService();
                if (partService != null) {
                    partService.removePartListener(this.fPartListener);
                }
                window.removePerspectiveListener(this.fPerspectiveListener);
                ++n2;
            }
            PlatformUI.getWorkbench().removeWindowListener(this.fWindowListener);
        }
    }
}

